/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javax.swing.table.DefaultTableModel;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class ModuleContentTableModel
extends DefaultTableModel {
    private String[] idents;
    private boolean isEditable;
    private Class[] columnTypes;

    public ModuleContentTableModel() {
        super(new Object[0][], new String[]{"ID", "Model", "Manufactur"});
        this.columnTypes = new Class[]{String.class, String.class, String.class};
        this.isEditable = false;
    }

    public ModuleContentTableModel(String[] idents) {
        super(new Object[0][], idents);
        this.idents = idents;
        if (idents != null) {
            this.columnTypes = new Class[idents.length];
        }
        this.isEditable = false;
    }

    public void addRow(ModuleContent o) {
        super.addRow(this.parse(o));
    }

    private Object[] parse(ModuleContent c) {
        if (this.idents == null) {
            return new Object[0];
        }
        LinkedHashMap<String, TagData> l = c.getList();
        Object[] o = new Object[this.idents.length];
        if (l != null) {
            for (int i = 0; i < this.idents.length; ++i) {
                try {
                    o[i] = l.containsKey(this.idents[i]) ? l.get(this.idents[i]).getTagValue() : "";
                    this.columnTypes[i] = l.get(this.idents[i]).getTagTypeClass();
                    continue;
                }
                catch (Exception err) {
                    String s = "[MDE] error occurred when parsing ModuleContent";
                    LogMessage msg = new LogMessage();
                    msg.print(s);
                    msg.print((Throwable)err);
                    ImporterAgent.getRegistry().getLogger().error((Object)this, msg);
                }
            }
        }
        return o;
    }

    public ModuleContent getRowData(int rowIndex, ModuleContent content) {
        if (rowIndex > this.getRowCount() || rowIndex < 0) {
            return null;
        }
        ArrayList data = new ArrayList();
        for (int c = 0; c < this.getColumnCount(); ++c) {
            String val = (String)this.getValueAt(rowIndex, c);
            content.set(this.getColumnName(c), val.split(","));
        }
        return content;
    }

    public void insertRow(int index, ModuleContent o) {
        super.insertRow(index, this.parse(o));
    }

    public String getIdents() {
        if (this.idents != null) {
            return Arrays.toString(this.idents);
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.isEditable;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public Class getColumnClass(int columnIndex) {
        return this.columnTypes[columnIndex];
    }
}

