/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omero.gateway.model.MapAnnotationData;
import omero.model.MapAnnotation;
import omero.model.MapAnnotationI;
import omero.model.NamedValue;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class MapAnnotationObject {
    private String fileName;
    private List<MapAnnotationData> mapAnnotation;

    public MapAnnotationObject(String fileName, MapAnnotationData map) {
        this.fileName = fileName;
        this.mapAnnotation = new ArrayList<MapAnnotationData>();
        this.mapAnnotation.add(map);
    }

    public MapAnnotationObject(String fileName, List<MapAnnotationData> maps) {
        this.fileName = fileName;
        this.mapAnnotation = maps;
    }

    public MapAnnotationObject(HashMap<String, List<TagData>> input) {
        if (input == null || input.isEmpty()) {
            return;
        }
        MapAnnotationI ma = new MapAnnotationI();
        ArrayList<NamedValue> values = new ArrayList<NamedValue>();
        for (Map.Entry<String, List<TagData>> entry : input.entrySet()) {
            if (entry.getValue() == null) continue;
            for (TagData t : entry.getValue()) {
                if (t.getTagValue() == null || t.getTagValue().trim().isEmpty()) continue;
                values.add(new NamedValue(entry.getKey() + " | " + t.getTagName(), t.getTagWholeValue()));
            }
        }
        ma.setMapValue(values);
        MapAnnotationData res = new MapAnnotationData((MapAnnotation)ma);
        res.setDescription("MDE_v1.1.0");
        res.setNameSpace("MDE");
        this.mapAnnotation = new ArrayList<MapAnnotationData>();
        this.mapAnnotation.add(res);
    }

    public MapAnnotationObject(MapAnnotationObject orig) {
        this.fileName = orig.fileName;
        this.mapAnnotation = new ArrayList<MapAnnotationData>();
        List<MapAnnotationData> origList = orig.getMapAnnotationList();
        if (origList != null) {
            for (MapAnnotationData m : origList) {
                List valuesOrig = (List)m.getContent();
                MapAnnotationI ma = new MapAnnotationI();
                ArrayList<NamedValue> values = new ArrayList<NamedValue>();
                for (NamedValue val : valuesOrig) {
                    values.add(new NamedValue(val.name, val.value));
                }
                ma.setMapValue(values);
                MapAnnotationData newdata = new MapAnnotationData((MapAnnotation)ma);
                newdata.setDescription(m.getDescription());
                newdata.setNameSpace(m.getNameSpace());
                this.mapAnnotation.add(new MapAnnotationData((MapAnnotation)ma));
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public List<MapAnnotationData> getMapAnnotationList() {
        return this.mapAnnotation;
    }

    public static void printMapAnnotation(MapAnnotationData map) {
        if (map == null) {
            return;
        }
        ImporterAgent.getRegistry().getLogger().debug(null, "\t PRINT MAPANNOTATIONS:  ns=" + map.getNameSpace() + ", desc=" + map.getDescription());
        List values = (List)map.getContent();
        if (values != null) {
            for (NamedValue val : values) {
                ImporterAgent.getRegistry().getLogger().debug(null, "\t\t" + val.name + ": " + val.value);
            }
        }
    }

    public static void printMapAnnotations(Map<String, MapAnnotationObject> map) {
        System.out.println("******* MAP ************");
        for (Map.Entry<String, MapAnnotationObject> next : map.entrySet()) {
            ImporterAgent.getRegistry().getLogger().debug(null, "\t PRINT MAPANNOTATION OBJECT - : " + next.getKey());
            MapAnnotationObject.printObject(next.getValue());
        }
        System.out.println("******* END MAP************");
    }

    public static void printObject(MapAnnotationObject o) {
        if (o == null) {
            return;
        }
        ImporterAgent.getRegistry().getLogger().debug(null, "\t file : " + o.getFileName());
        List<MapAnnotationData> list = o.getMapAnnotationList();
        int index = 0;
        if (list != null) {
            for (MapAnnotationData m : list) {
                ImporterAgent.getRegistry().getLogger().debug(null, "\t Series_" + index++);
                MapAnnotationObject.printMapAnnotation(m);
            }
        }
    }

    public void printObject() {
        MapAnnotationObject.printObject(this);
    }
}

