/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout;

import java.util.LinkedHashMap;
import java.util.List;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleController;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.inout.TagDataParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ModuleContentParser {
    final String ATTR_ID = "ID";
    final String ATTR_TYPE = "Type";
    final String ELEM_TAGDATA = "TagData";

    public Element createXMLElem(ModuleContent c, String idx, Document doc, String elemName, boolean saveVal) {
        if (c == null) {
            return null;
        }
        Element result = doc.createElement(elemName);
        result.setAttribute("ID", idx);
        result.setAttribute("Type", c.getType());
        List<TagData> list = c.getTagList();
        if (list == null || !saveVal) {
            return result;
        }
        TagDataParser td_parser = new TagDataParser();
        for (TagData tagData : list) {
            Element child = td_parser.createXMLElem(tagData, doc, "TagData", saveVal);
            if (child == null) continue;
            result.appendChild(child);
        }
        return result;
    }

    public ModuleContent parseFromConfig(Element eElement, String type, boolean pre, String[] parents) {
        return new ModuleContent(this.elementsToTagDataList(eElement.getElementsByTagName("TagData"), type, pre), type, parents);
    }

    public ModuleContent parseDataFromConfig(Element eElement, String type, boolean pre, String[] parents, boolean getdata) {
        ModuleContent mc = ModuleController.getInstance().getContentOfType(type);
        if (mc != null) {
            mc.setParents(parents);
            if (getdata) {
                mc.setData(this.elementsToTagDataList(eElement.getElementsByTagName("TagData"), type, pre));
            } else {
                mc.setData(null);
            }
        }
        return mc;
    }

    private LinkedHashMap<String, TagData> elementsToTagDataList(NodeList nodeList, String parent, boolean pre) {
        if (nodeList == null) {
            return null;
        }
        LinkedHashMap<String, TagData> list = new LinkedHashMap<String, TagData>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            TagData t = new TagDataParser().parseFromConfig(n, pre, parent);
            if (t == null) continue;
            list.put(t.getTagName(), t);
        }
        return list;
    }
}

