/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.util;

import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import omero.cmd.CmdCallback;
import omero.cmd.CmdCallbackI;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FilesetData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXTaskPane;
import org.openmicroscopy.shoola.agents.events.importer.BrowseContainer;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.fsimporter.IconManager;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.agents.fsimporter.util.ImportStatus;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.ui.EditorDialog;
import org.openmicroscopy.shoola.agents.util.ui.ThumbnailLabel;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.model.ThumbnailData;
import org.openmicroscopy.shoola.env.data.util.Status;
import org.openmicroscopy.shoola.env.data.util.StatusLabel;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FileImportComponent
extends JPanel
implements PropertyChangeListener,
FileImportComponentI {
    private static final Dimension SIZE = new Dimension(16, 16);
    private static final int LENGTH = 350;
    private FileImportComponentI.ContainerType type;
    private JXBusyLabel busyLabel;
    private JPanel namePane;
    private JLabel resultLabel;
    private ThumbnailLabel imageLabel;
    private List<ThumbnailLabel> imageLabels;
    private Object image;
    private Status status;
    private JLabel fileNameLabel;
    private Map<File, FileImportComponent> components;
    private MouseAdapter adapter;
    private DataObject containerFromFolder;
    private JButton cancelButton;
    private DataObject data;
    private DatasetData dataset;
    private Object refNode;
    private DataObject containerObject;
    private JXTaskPane pane;
    private FileImportComponentI parent;
    private boolean browsable;
    private boolean reimported;
    private boolean singleGroup;
    private JButton actionMenuButton;
    private JPopupMenu menu;
    private ImportStatus resultIndex;
    private int index;
    private CmdCallback callback;
    private ImportableFile importable;
    private Collection<TagAnnotationData> tags;
    private JLabel refLabel;
    private JButton refButton;

    private void retry() {
        Object o = this.status.getImportResult();
        if (o instanceof Exception || this.image instanceof Exception) {
            this.firePropertyChange("retry", null, this);
        }
    }

    private JPopupMenu createActionMenu() {
        JMenuItem item;
        if (this.menu != null) {
            return this.menu;
        }
        this.menu = new JPopupMenu();
        String logText = "View Import Log";
        String checksumText = "View Checksum";
        String exceptionText = "View Exception";
        String copyExceptionText = "Copy Exception to Clipboard";
        Object result = this.status.getImportResult();
        switch (this.resultIndex) {
            case FAILURE_LIBRARY: {
                this.menu.add(new JMenuItem(new AbstractAction(exceptionText){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileImportComponent.this.viewError();
                    }
                }));
                this.menu.add(new JMenuItem(new AbstractAction(copyExceptionText){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileImportComponent.this.copyErrorToClipboard();
                    }
                }));
                break;
            }
            case FAILURE: {
                this.menu.add(new JMenuItem(new AbstractAction("Submit"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileImportComponent.this.submitError();
                    }
                }));
                this.menu.add(new JMenuItem(new AbstractAction(exceptionText){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileImportComponent.this.viewError();
                    }
                }));
                this.menu.add(new JMenuItem(new AbstractAction(copyExceptionText){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileImportComponent.this.copyErrorToClipboard();
                    }
                }));
                break;
            }
            case UPLOAD_FAILURE: {
                this.menu.add(new JMenuItem(new AbstractAction("Retry"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileImportComponent.this.retry();
                    }
                }));
                break;
            }
            case SUCCESS: {
                logText = "Import Log";
                checksumText = "Checksum";
                item = new JMenuItem(new AbstractAction("In Full Viewer"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileImportComponent.this.launchFullViewer();
                    }
                });
                boolean b = false;
                if (result instanceof Collection) {
                    b = ((Collection)result).size() == 1;
                }
                item.setEnabled(b && !this.status.isHCS());
                this.menu.add(item);
                item = new JMenuItem(new AbstractAction("In Data Browser"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileImportComponent.this.browse();
                    }
                });
                item.setEnabled(this.browsable);
                this.menu.add(item);
            }
        }
        item = new JMenuItem(new AbstractAction(logText){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileImportComponent.this.displayLogFile();
            }
        });
        item.setEnabled(this.status.getLogFileID() > 0L);
        this.menu.add(item);
        item = new JMenuItem(new AbstractAction(checksumText){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileImportComponent.this.showChecksumDetails();
            }
        });
        item.setEnabled(this.status.hasChecksum());
        this.menu.add(item);
        return this.menu;
    }

    private void displayLogFile() {
        this.firePropertyChange("loadLogfile", null, this);
    }

    private void showChecksumDetails() {
        this.firePropertyChange("checksumDisplay", null, this.status);
    }

    private void formatResultTooltip() {
        Object o;
        StringBuffer buf = new StringBuffer();
        buf.append("<html><body>");
        buf.append("<b>Date Uploaded: </b>");
        buf.append(UIUtilities.formatShortDateTime(null));
        buf.append("<br>");
        if (this.image instanceof PlateData) {
            PlateData p = (PlateData)this.image;
            buf.append("<b>Plate ID: </b>");
            buf.append(p.getId());
            buf.append("<br>");
        }
        if (!this.status.isHCS() && (o = this.status.getImportResult()) instanceof Set) {
            Set list = (Set)o;
            int n = list.size();
            if (n == 1) {
                buf.append("<b>Image ID: </b>");
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    buf.append(((PixelsData)i.next()).getImage().getId());
                    buf.append("<br>");
                }
            } else if (n > 1) {
                buf.append("<b>Number of Images: </b>");
                buf.append(n);
                buf.append("<br>");
            }
        }
        buf.append("<b>Size: </b>");
        buf.append(FileUtils.byteCountToDisplaySize((long)this.status.getSizeUpload()));
        buf.append("<br>");
        buf.append("<b>Group: </b>");
        buf.append(this.importable.getGroup().getName());
        buf.append("<br>");
        buf.append("<b>Owner: </b>");
        buf.append(EditorUtil.formatExperimenter(this.importable.getUser()));
        buf.append("<br>");
        if (this.containerObject instanceof ProjectData) {
            buf.append("<b>Project: </b>");
            buf.append(((ProjectData)this.containerObject).getName());
            buf.append("<br>");
        } else if (this.containerObject instanceof ScreenData) {
            buf.append("<b>Screen: </b>");
            buf.append(((ScreenData)this.containerObject).getName());
            buf.append("<br>");
        } else if (this.containerObject instanceof DatasetData) {
            buf.append("<b>Dataset: </b>");
            buf.append(((DatasetData)this.containerObject).getName());
            buf.append("<br>");
        } else if (this.dataset != null) {
            buf.append("<b>Dataset: </b>");
            buf.append(this.dataset.getName());
            buf.append("<br>");
        }
        if (!CollectionUtils.isEmpty(this.tags)) {
            buf.append("<b>Tags: </b>");
            Iterator<TagAnnotationData> i = this.tags.iterator();
            while (i.hasNext()) {
                buf.append(i.next().getTagValue());
                buf.append(" ");
            }
        }
        buf.append("</body></html>");
        String tip = buf.toString();
        this.fileNameLabel.setToolTipText(tip);
        this.resultLabel.setToolTipText(tip);
    }

    private void formatResult() {
        if (this.callback != null) {
            try {
                ((CmdCallbackI)this.callback).close(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SwingUtilities.invokeLater(() -> {
            if (this.namePane.getPreferredSize().width > 350) {
                this.fileNameLabel.setText(EditorUtil.getPartialName(this.getFile().getName()));
            }
            this.resultLabel.setVisible(true);
            this.busyLabel.setVisible(false);
            this.busyLabel.setBusy(false);
            this.remove(this.refLabel);
            this.remove(this.refButton);
            this.refLabel = this.resultLabel;
            this.refButton = this.actionMenuButton;
            this.addControlsToDisplay();
            IconManager icons = IconManager.getInstance();
            Object result = this.status.getImportResult();
            if (this.image instanceof ImportException) {
                result = this.image;
            }
            if (result instanceof ImportException) {
                ImportException e = (ImportException)result;
                this.resultLabel.setIcon(icons.getIcon(10));
                this.resultLabel.setToolTipText(UIUtilities.formatExceptionForToolTip(e));
                this.actionMenuButton.setVisible(true);
                this.actionMenuButton.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
                this.actionMenuButton.setText("Failed");
                int status = e.getStatus();
                this.resultIndex = status == ImportException.CHECKSUM_MISMATCH ? ImportStatus.UPLOAD_FAILURE : (status == ImportException.MISSING_LIBRARY ? ImportStatus.FAILURE_LIBRARY : ImportStatus.FAILURE);
            } else if (result instanceof CmdCallback) {
                this.callback = (CmdCallback)result;
            } else {
                this.formatResultTooltip();
                this.resultLabel.setIcon(icons.getIcon(16));
                this.actionMenuButton.setVisible(true);
                this.actionMenuButton.setForeground(UIUtilities.HYPERLINK_COLOR);
                this.actionMenuButton.setText("View");
                this.resultIndex = ImportStatus.SUCCESS;
            }
        });
    }

    private void submitError() {
        Object o = this.status.getImportResult();
        if (o instanceof Exception) {
            this.firePropertyChange("submitError", null, this);
        }
    }

    private void viewError() {
        Object o = this.status.getImportResult();
        if (o instanceof ImportException) {
            String v = UIUtilities.printErrorText((ImportException)o);
            JFrame f = ImporterAgent.getRegistry().getTaskBar().getFrame();
            EditorDialog d = new EditorDialog(f, v, 2);
            d.allowEdit(false);
            UIUtilities.centerAndShow(d);
        }
    }

    private void copyErrorToClipboard() {
        Object o = this.status.getImportResult();
        if (o instanceof ImportException) {
            String v = UIUtilities.printErrorText((ImportException)o);
            UIUtilities.copyToClipboard(v);
        }
    }

    private void browse() {
        EventBus bus = ImporterAgent.getRegistry().getEventBus();
        DataObject d = this.dataset;
        if (this.dataset == null || this.data instanceof ScreenData) {
            d = this.data;
        }
        if (d == null) {
            return;
        }
        bus.post(new BrowseContainer(d, null));
    }

    private void cancel(boolean fire) {
        boolean b;
        boolean bl = b = this.status.isCancellable() || this.getFile().isDirectory();
        if (!this.isCancelled() && !this.hasImportFailed() && b && !this.status.isMarkedAsDuplicate()) {
            SwingUtilities.invokeLater(() -> {
                this.busyLabel.setBusy(false);
                this.busyLabel.setVisible(false);
                this.status.markedAsCancel();
                this.cancelButton.setEnabled(false);
                this.cancelButton.setVisible(false);
                this.firePropertyChange("cancelImport", null, this);
            });
        }
    }

    private void launchFullViewer() {
        EventBus bus;
        Object data;
        int plugin = ImporterAgent.runAsPlugin();
        if (this.image == null) {
            this.image = this.status.getImportResult();
        }
        Object ho2 = this.image;
        if (this.image instanceof Collection) {
            Collection l = (Collection)this.image;
            if (CollectionUtils.isEmpty((Collection)l) || l.size() > 1) {
                return;
            }
            for (Object ho2 : l) {
            }
        }
        if (ho2 instanceof ThumbnailData) {
            data = (ThumbnailData)ho2;
            bus = ImporterAgent.getRegistry().getEventBus();
            ViewImage evt = new ViewImage(new SecurityContext(this.importable.getGroup().getId()), new ViewImageObject(((ThumbnailData)data).getImageID()), null);
            evt.setPlugin(plugin);
            bus.post(evt);
        } else if (ho2 instanceof PixelsData) {
            data = (PixelsData)ho2;
            bus = ImporterAgent.getRegistry().getEventBus();
            ViewImage evt = new ViewImage(new SecurityContext(this.importable.getGroup().getId()), new ViewImageObject(((PixelsData)data).getImage().getId()), null);
            evt.setPlugin(plugin);
            bus.post(evt);
        } else if (this.image instanceof PlateData) {
            this.firePropertyChange("browse", null, this.image);
        }
    }

    private void initComponents() {
        this.actionMenuButton = new JButton();
        this.actionMenuButton.setVisible(false);
        this.actionMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JPopupMenu popup = FileImportComponent.this.createActionMenu();
                popup.show(FileImportComponent.this.actionMenuButton, 0, FileImportComponent.this.actionMenuButton.getHeight());
            }
        });
        this.adapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    FileImportComponent.this.launchFullViewer();
                }
            }
        };
        this.setLayout(new FlowLayout(0));
        this.busyLabel = new JXBusyLabel(SIZE);
        this.busyLabel.setVisible(false);
        this.busyLabel.setBusy(false);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setForeground(UIUtilities.HYPERLINK_COLOR);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FileImportComponent.this.cancelLoading();
            }
        });
        this.cancelButton.setVisible(true);
        this.namePane = new JPanel();
        this.namePane.setLayout(new FlowLayout(0, 5, 5));
        IconManager icons = IconManager.getInstance();
        ImageIcon icon = this.getFile().isFile() ? icons.getIcon(7) : icons.getIcon(8);
        this.imageLabel = new ThumbnailLabel(icon);
        this.imageLabel.addPropertyChangeListener(this);
        this.imageLabels = new ArrayList<ThumbnailLabel>();
        for (int i = 0; i < 3; ++i) {
            ThumbnailLabel label = new ThumbnailLabel();
            if (i == 2) {
                Font f = label.getFont();
                label.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
            }
            label.setVisible(false);
            label.addPropertyChangeListener(this);
            this.imageLabels.add(label);
        }
        this.fileNameLabel = new JLabel(this.getFile().getName());
        this.namePane.add(this.imageLabel);
        Iterator<ThumbnailLabel> j = this.imageLabels.iterator();
        while (j.hasNext()) {
            this.namePane.add(j.next());
        }
        this.namePane.add(Box.createHorizontalStrut(4));
        this.namePane.add(this.fileNameLabel);
        this.namePane.add(Box.createHorizontalStrut(10));
        this.resultLabel = new JLabel();
        this.status = new Status(this.importable.getFile());
        this.status.addPropertyChangeListener(this);
        this.image = null;
        this.refButton = this.cancelButton;
        this.refLabel = this.busyLabel;
    }

    private void buildGUI() {
        double[][] design = new double[][]{{350.0, -1.0, -2.0, -2.0, -2.0, -2.0}, {-2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])design));
        this.removeAll();
        if (this.namePane.getPreferredSize().width > 350) {
            this.fileNameLabel.setText(EditorUtil.getPartialName(this.getFile().getName()));
        }
        this.add((Component)UIUtilities.buildComponentPanel(this.namePane, false), "0, 0, l, c");
        this.add((Component)new StatusLabel(this.status), "1, 0, l, c");
        this.addControlsToDisplay();
    }

    private void addControlsToDisplay() {
        this.add((Component)this.refLabel, "2, 0, l, c");
        this.add((Component)UIUtilities.buildComponentPanel(this.refButton, false), "3, 0, l, c");
    }

    private void attachListeners(FileImportComponent c) {
        PropertyChangeListener[] listeners = this.getPropertyChangeListeners();
        if (listeners != null && listeners.length > 0) {
            for (int j = 0; j < listeners.length; ++j) {
                c.addPropertyChangeListener(listeners[j]);
            }
        }
    }

    private void insertFiles(Map<File, Status> files) {
        this.resultIndex = ImportStatus.SUCCESS;
        if (files == null || files.size() == 0) {
            return;
        }
        this.components = Collections.synchronizedMap(new HashMap());
        Iterator<Map.Entry<File, Status>> i = files.entrySet().iterator();
        DatasetData d = this.dataset;
        Object node = this.refNode;
        if (this.importable.isFolderAsContainer()) {
            node = null;
            d = new DatasetData();
            d.setName(this.getFile().getName());
        }
        while (i.hasNext()) {
            Map.Entry<File, Status> entry = i.next();
            File f = entry.getKey();
            ImportableFile copy = this.importable.copy();
            copy.setFile(f);
            FileImportComponent c = new FileImportComponent(copy, this.browsable, this.singleGroup, this.getIndex(), this.tags);
            if (f.isFile()) {
                c.setLocation(this.data, d, node);
                c.setParent(this);
            }
            c.setType(this.getType());
            this.attachListeners(c);
            c.setStatusLabel(entry.getValue());
            entry.getValue().addPropertyChangeListener(this);
            this.components.put(entry.getKey(), c);
        }
        this.removeAll();
        this.pane = EditorUtil.createTaskPane(this.getFile().getName());
        this.pane.setCollapsed(false);
        IconManager icons = IconManager.getInstance();
        this.pane.setIcon((Icon)icons.getIcon(8));
        Font font = this.pane.getFont();
        this.pane.setFont(font.deriveFont(font.getStyle(), font.getSize() - 2));
        this.layoutEntries(false);
        double[][] size = new double[][]{{-1.0}, {-2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.add((Component)this.pane, new TableLayoutConstraints(0, 0));
        this.validate();
        this.repaint();
    }

    public FileImportComponent(ImportableFile importable, boolean browsable, boolean singleGroup, int index, Collection<TagAnnotationData> tags) {
        if (importable == null) {
            throw new IllegalArgumentException("No file specified.");
        }
        if (importable.getGroup() == null) {
            throw new IllegalArgumentException("No group specified.");
        }
        this.index = index;
        this.tags = tags;
        this.importable = importable;
        this.singleGroup = singleGroup;
        this.browsable = browsable;
        this.resultIndex = ImportStatus.QUEUED;
        this.initComponents();
        this.buildGUI();
        this.setLocation(importable.getParent(), importable.getDataset(), importable.getRefNode());
    }

    @Override
    public FileObject getFile() {
        return this.importable.getFile();
    }

    @Override
    public FileObject getOriginalFile() {
        return this.importable.getOriginalFile();
    }

    @Override
    public void setLocation(DataObject data, DatasetData dataset, Object refNode) {
        this.data = data;
        this.dataset = dataset;
        this.refNode = refNode;
        if (refNode != null && refNode instanceof TreeImageDisplay) {
            TreeImageDisplay n = (TreeImageDisplay)refNode;
            Object ho = n.getUserObject();
            if (ho instanceof DatasetData || ho instanceof ProjectData || ho instanceof ScreenData) {
                this.containerObject = (DataObject)ho;
            }
            return;
        }
        if (dataset != null) {
            this.containerObject = dataset;
            return;
        }
        if (data instanceof ScreenData) {
            this.containerObject = data;
        }
    }

    @Override
    public void setImportLogFile(Collection<FileAnnotationData> data, long id) {
    }

    @Override
    public DatasetData getDataset() {
        return this.dataset;
    }

    @Override
    public DataObject getDataObject() {
        return this.data;
    }

    void setStatusLabel(Status label) {
        this.status = label;
        this.status.addPropertyChangeListener(this);
        this.buildGUI();
        this.revalidate();
        this.repaint();
    }

    void setParent(FileImportComponentI parent) {
        this.parent = parent;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    private FileObject getAssociatedFile(int series) {
        List<FileObject> l = this.getFile().getAssociatedFiles();
        for (FileObject f : l) {
            if (f.getIndex() != series) continue;
            return f;
        }
        return null;
    }

    private boolean hasAssociatedFiles() {
        List<FileObject> l = this.getFile().getAssociatedFiles();
        return CollectionUtils.isNotEmpty(l);
    }

    @Override
    public void setStatus(final Object image) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileImportComponent.this.busyLabel.setVisible(false);
                FileImportComponent.this.busyLabel.setBusy(false);
                FileImportComponent.this.cancelButton.setVisible(false);
                FileImportComponent.this.image = image;
                if (image instanceof PlateData) {
                    FileImportComponent.this.menu = null;
                    FileImportComponent.this.imageLabel.setData((PlateData)image);
                    FileImportComponent.this.fileNameLabel.addMouseListener(FileImportComponent.this.adapter);
                    FileImportComponent.this.formatResultTooltip();
                } else if (image instanceof Collection) {
                    Collection c = (Collection)image;
                    if (!c.isEmpty()) {
                        Object obj = c.iterator().next();
                        if (obj instanceof ThumbnailData) {
                            ArrayList list = new ArrayList((Collection)image);
                            int m = list.size();
                            ThumbnailData data = (ThumbnailData)list.get(0);
                            FileImportComponent.this.imageLabel.setData(data);
                            list.remove(0);
                            if (list.size() > 0) {
                                ThumbnailLabel label = FileImportComponent.this.imageLabels.get(0);
                                label.setVisible(true);
                                label.setData(list.get(0));
                                list.remove(0);
                                if (list.size() > 0) {
                                    label = FileImportComponent.this.imageLabels.get(1);
                                    label.setVisible(true);
                                    label.setData(list.get(0));
                                    list.remove(0);
                                    int n = FileImportComponent.this.status.getNumberOfImportedFiles() - m;
                                    if (n > 0) {
                                        label = FileImportComponent.this.imageLabels.get(2);
                                        label.setVisible(true);
                                        StringBuffer buf = new StringBuffer("... ");
                                        buf.append(n);
                                        buf.append(" more");
                                        label.setText(buf.toString());
                                    }
                                }
                            }
                        } else if (obj instanceof PixelsData) {
                            FileImportComponent.this.image = null;
                            for (Object object : c) {
                                FileObject f;
                                if (!(object instanceof PixelsData)) continue;
                                PixelsData pix = (PixelsData)object;
                                if (FileImportComponent.this.hasAssociatedFiles()) {
                                    int series = pix.getImage().getSeries();
                                    f = FileImportComponent.this.getAssociatedFile(series);
                                    if (f == null) continue;
                                    f.setImageID(pix.getImage().getId());
                                    continue;
                                }
                                f = FileImportComponent.this.getOriginalFile();
                                f.setImageID(pix.getImage().getId());
                            }
                            FileImportComponent.this.formatResult();
                        }
                    }
                } else if (image instanceof ImportException) {
                    if (FileImportComponent.this.getFile().isDirectory()) {
                        FileImportComponent.this.image = null;
                    } else {
                        FileImportComponent.this.formatResult();
                    }
                } else if (image instanceof Boolean) {
                    FileImportComponent.this.busyLabel.setBusy(false);
                    FileImportComponent.this.busyLabel.setVisible(false);
                    FileImportComponent.this.cancelButton.setVisible(false);
                    if (FileImportComponent.this.status.isMarkedAsCancel() || FileImportComponent.this.status.isMarkedAsDuplicate()) {
                        FileImportComponent.this.resultIndex = ImportStatus.IGNORED;
                        FileImportComponent.this.image = null;
                    }
                }
                FileImportComponent.this.invalidate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileImportComponentI> getImportErrors() {
        ArrayList<FileImportComponentI> l = null;
        if (this.getFile().isFile()) {
            Object r = this.status.getImportResult();
            if (r instanceof Exception || this.image instanceof Exception) {
                l = new ArrayList<FileImportComponentI>();
                l.add(this);
                return l;
            }
        } else if (this.components != null) {
            Collection<FileImportComponent> values = this.components.values();
            Map<File, FileImportComponent> map = this.components;
            synchronized (map) {
                Iterator<FileImportComponent> i = values.iterator();
                l = new ArrayList();
                while (i.hasNext()) {
                    FileImportComponentI fc = i.next();
                    List<FileImportComponentI> list = fc.getImportErrors();
                    if (CollectionUtils.isEmpty(list)) continue;
                    l.addAll(list);
                }
            }
        }
        return l;
    }

    @Override
    public long getGroupID() {
        return this.importable.getGroup().getId();
    }

    @Override
    public long getExperimenterID() {
        return this.importable.getUser().getId();
    }

    @Override
    public Collection<? extends FileImportComponentI> getChildren() {
        try {
            return this.components.values();
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    @Override
    public ImportErrorObject getImportErrorObject() {
        FilesetData data;
        Object r = this.status.getImportResult();
        Exception e = null;
        if (r instanceof Exception) {
            e = (Exception)r;
        } else if (this.image instanceof Exception) {
            e = (Exception)this.image;
        }
        if (e == null) {
            return null;
        }
        ImportErrorObject object = new ImportErrorObject(this.getFile().getTrueFile(), e, this.getGroupID());
        object.setImportContainer(this.status.getImportContainer());
        long id = this.status.getLogFileID();
        if (id <= 0L && (data = this.status.getFileset()) != null) {
            id = data.getId();
            object.setRetrieveFromAnnotation(true);
        }
        object.setLogFileID(id);
        return object;
    }

    @Override
    public boolean hasImportFailed() {
        return this.resultIndex == ImportStatus.FAILURE || this.resultIndex == ImportStatus.UPLOAD_FAILURE;
    }

    @Override
    public boolean hasUploadFailed() {
        return this.resultIndex == ImportStatus.UPLOAD_FAILURE || this.resultIndex == ImportStatus.FAILURE && !this.status.didUploadStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        boolean b = this.status.isMarkedAsCancel();
        if (b || this.getFile().isFile()) {
            return b;
        }
        if (this.components == null) {
            return false;
        }
        Collection<FileImportComponent> values = this.components.values();
        Map<File, FileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<FileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                if (!i.next().isCancelled()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasImportToCancel() {
        boolean b = this.status.isMarkedAsCancel();
        if (b) {
            return false;
        }
        if (this.getFile().isFile() && !this.hasImportStarted()) {
            return true;
        }
        if (this.components == null) {
            return false;
        }
        Collection<FileImportComponent> values = this.components.values();
        Map<File, FileImportComponent> map = this.components;
        synchronized (map) {
            for (FileImportComponentI fileImportComponentI : values) {
                if (fileImportComponentI.isCancelled() || fileImportComponentI.hasImportStarted()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFailuresToReimport() {
        if (this.getFile().isFile()) {
            return this.hasUploadFailed() && !this.reimported;
        }
        if (this.components == null) {
            return false;
        }
        Collection<FileImportComponent> values = this.components.values();
        Map<File, FileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<FileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                if (!i.next().hasUploadFailed()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFailuresToReupload() {
        if (this.getFile().isFile()) {
            return this.hasUploadFailed() && !this.reimported;
        }
        if (this.components == null) {
            return false;
        }
        Collection<FileImportComponent> values = this.components.values();
        Map<File, FileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<FileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                if (!i.next().hasFailuresToReupload()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasImportStarted() {
        if (this.getFile().isFile()) {
            return this.resultIndex != ImportStatus.QUEUED;
        }
        if (this.components == null) {
            return false;
        }
        Map<File, FileImportComponent> map = this.components;
        synchronized (map) {
            for (FileImportComponent c : this.components.values()) {
                if (c.hasImportStarted()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFailuresToSend() {
        if (this.getFile().isFile()) {
            return this.resultIndex == ImportStatus.FAILURE;
        }
        if (this.components == null) {
            return false;
        }
        Collection<FileImportComponent> values = this.components.values();
        Map<File, FileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<FileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                if (!i.next().hasFailuresToSend()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasComponents() {
        return this.components != null && this.components.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutEntries(boolean failure) {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        if (!this.hasComponents()) {
            return;
        }
        Set<Map.Entry<File, FileImportComponent>> entries = this.components.entrySet();
        Map<File, FileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<Map.Entry<File, FileImportComponent>> i = entries.iterator();
            int index = 0;
            if (failure) {
                while (i.hasNext()) {
                    Map.Entry<File, FileImportComponent> e = i.next();
                    FileImportComponent fc = e.getValue();
                    if (!fc.hasImportFailed()) continue;
                    if (index % 2 == 0) {
                        fc.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
                    } else {
                        fc.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
                    }
                    p.add(fc);
                    ++index;
                }
            } else {
                while (i.hasNext()) {
                    Map.Entry<File, FileImportComponent> e = i.next();
                    FileImportComponent fc = e.getValue();
                    if (index % 2 == 0) {
                        fc.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
                    } else {
                        fc.setBackground(UIUtilities.BACKGROUND_COLOUR_ODD);
                    }
                    p.add(fc);
                    ++index;
                }
            }
        }
        this.pane.removeAll();
        this.pane.add((Component)p);
        this.pane.revalidate();
        this.pane.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportStatus getImportStatus() {
        if (this.getFile().isFile()) {
            if (this.hasImportFailed()) {
                return ImportStatus.FAILURE;
            }
            return this.resultIndex;
        }
        if (this.components == null || this.components.size() == 0) {
            if (this.image instanceof Boolean) {
                if (this.getFile().isDirectory()) {
                    return ImportStatus.SUCCESS;
                }
                if (!this.status.isMarkedAsCancel() && !this.status.isMarkedAsDuplicate()) {
                    return ImportStatus.FAILURE;
                }
            }
            return this.resultIndex;
        }
        Collection<FileImportComponent> values = this.components.values();
        int n = this.components.size();
        int count = 0;
        Map<File, FileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<FileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                if (!i.next().hasImportFailed()) continue;
                ++count;
            }
        }
        if (count == n) {
            return ImportStatus.FAILURE;
        }
        if (count > 0) {
            return ImportStatus.PARTIAL;
        }
        return ImportStatus.SUCCESS;
    }

    @Override
    public boolean hasToRefreshTree() {
        if (this.getFile().isFile()) {
            if (this.hasImportFailed()) {
                return false;
            }
            switch (this.type) {
                case PROJECT: 
                case NA: {
                    return true;
                }
            }
            return false;
        }
        if (this.components == null) {
            return false;
        }
        if (this.importable.isFolderAsContainer() && this.type != FileImportComponentI.ContainerType.PROJECT) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelLoading() {
        if (this.components == null || this.components.isEmpty()) {
            this.cancel(this.getFile().isFile());
            return;
        }
        Collection<FileImportComponent> values = this.components.values();
        Map<File, FileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<FileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                i.next().cancelLoading();
            }
        }
    }

    @Override
    public void setType(FileImportComponentI.ContainerType type) {
        this.type = type;
    }

    @Override
    public FileImportComponentI.ContainerType getType() {
        return this.type;
    }

    @Override
    public boolean isFolderAsContainer() {
        return this.importable.isFolderAsContainer();
    }

    @Override
    public DataObject getContainerFromFolder() {
        return this.containerFromFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileImportComponentI> getFilesToReupload() {
        ArrayList<FileImportComponentI> l = null;
        if (this.getFile().isFile()) {
            if (this.hasFailuresToReupload() && !this.reimported) {
                ArrayList<FileImportComponentI> ret = new ArrayList<FileImportComponentI>();
                ret.add(this);
                return ret;
            }
        } else if (this.components != null) {
            Collection<FileImportComponent> values = this.components.values();
            Map<File, FileImportComponent> map = this.components;
            synchronized (map) {
                Iterator<FileImportComponent> i = values.iterator();
                l = new ArrayList<FileImportComponentI>();
                while (i.hasNext()) {
                    FileImportComponentI fc = i.next();
                    List<FileImportComponentI> list = fc.getFilesToReupload();
                    if (CollectionUtils.isEmpty(list)) continue;
                    l.addAll(list);
                }
            }
        }
        return l;
    }

    @Override
    public void setReimported(boolean reimported) {
        this.reimported = reimported;
        this.repaint();
    }

    @Override
    public void uploadComplete(Object result) {
        if (result instanceof CmdCallback) {
            this.callback = (CmdCallback)result;
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Object getImportResult() {
        return this.status.getImportResult();
    }

    @Override
    public boolean isHCS() {
        return this.status.isHCS();
    }

    @Override
    public long getImportSize() {
        return this.status.getSizeUpload();
    }

    @Override
    public boolean hasResult() {
        return this.image != null;
    }

    @Override
    public ImportableFile getImportableFile() {
        return this.importable;
    }

    @Override
    public void onResultsSaving(String message, boolean busy) {
        SwingUtilities.invokeLater(() -> {
            this.busyLabel.setVisible(busy);
            this.busyLabel.setBusy(busy);
        });
    }

    @Override
    public void setBackground(Color color) {
        if (this.busyLabel != null) {
            this.busyLabel.setBackground(color);
        }
        if (this.namePane != null) {
            this.namePane.setBackground(color);
            for (int i = 0; i < this.namePane.getComponentCount(); ++i) {
                this.namePane.getComponent(i).setBackground(color);
            }
        }
        super.setBackground(color);
    }

    @Override
    public void propagateSuccessfulOfflineImportStatus() {
        if (this.status != null) {
            this.status.notifySuccessfulOfflineImport();
        }
        this.setStatus(null);
        if (this.hasComponents()) {
            for (FileImportComponent c : this.components.values()) {
                c.propagateSuccessfulOfflineImportStatus();
            }
        }
    }

    @Override
    public void propagateOfflineImportFailureStatus(Exception cause) {
        if (this.status != null) {
            this.status.notifyOfflineImportFailure(cause);
        }
        this.setStatus(cause);
        if (this.hasComponents()) {
            for (FileImportComponent c : this.components.values()) {
                c.propagateOfflineImportFailureStatus(cause);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        SwingUtilities.invokeLater(() -> {
            Status sl;
            if ("filesSet".equals(name)) {
                if (this.isCancelled()) {
                    this.busyLabel.setBusy(false);
                    this.busyLabel.setVisible(false);
                    return;
                }
                Map files = (Map)evt.getNewValue();
                int n = files.size();
                this.insertFiles(files);
                this.firePropertyChange("importFilesNumber", null, (Object)n);
            } else if ("fileImportStarted".equals(name)) {
                this.resultIndex = ImportStatus.STARTED;
                Status sl2 = (Status)evt.getNewValue();
                if (sl2.equals(this.status) && this.busyLabel != null) {
                    SwingUtilities.invokeLater(() -> this.cancelButton.setEnabled(sl2.isCancellable()));
                    this.firePropertyChange("fileImportStarted", null, this);
                }
            } else if ("uploadDone".equals(name)) {
                Status sl3 = (Status)evt.getNewValue();
                if (sl3.equals(this.status)) {
                    if (sl3.isMarkedAsCancel()) {
                        this.cancel(true);
                    } else {
                        this.formatResult();
                        this.firePropertyChange("uploadDone", null, this);
                    }
                }
            } else if ("cancellableImport".equals(name)) {
                Status sl4 = (Status)evt.getNewValue();
                if (sl4.equals(this.status)) {
                    this.cancelButton.setVisible(sl4.isCancellable());
                }
            } else if ("scanning".equals(name)) {
                Status sl5 = (Status)evt.getNewValue();
                if (sl5.equals(this.status) && this.busyLabel != null && !this.isCancelled()) {
                    this.busyLabel.setBusy(true);
                    this.busyLabel.setVisible(true);
                }
            } else if ("fileReset".equals(name)) {
                this.importable.setFile((File)evt.getNewValue());
                this.fileNameLabel.setText(this.getFile().getName());
            } else if ("browsePlate".equals(name)) {
                this.firePropertyChange("browse", evt.getOldValue(), evt.getNewValue());
            } else if ("containerFromFolder".equals(name)) {
                this.containerFromFolder = (DataObject)evt.getNewValue();
                if (this.containerFromFolder instanceof DatasetData) {
                    this.containerObject = this.containerFromFolder;
                } else if (this.containerFromFolder instanceof ScreenData) {
                    this.containerObject = this.containerFromFolder;
                }
            } else if ("debugText".equals(name)) {
                this.firePropertyChange(name, evt.getOldValue(), evt.getNewValue());
            } else if ("viewImage".equals(name)) {
                SecurityContext ctx = new SecurityContext(this.importable.getGroup().getId());
                EventBus bus = ImporterAgent.getRegistry().getEventBus();
                Long id = (Long)evt.getNewValue();
                bus.post(new ViewImage(ctx, new ViewImageObject(id), null));
            } else if (("importDone".equals(name) || "processingError".equals(name)) && (sl = (Status)evt.getNewValue()).equals(this.status)) {
                this.firePropertyChange("importDone", null, this);
            }
        });
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getFile().getAbsolutePath());
        if (this.importable.getGroup() != null) {
            buf.append("_" + this.importable.getGroup().getId());
        }
        if (this.importable.getUser() != null) {
            buf.append("_" + this.importable.getUser().getId());
        }
        return buf.toString();
    }
}

