/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterComponent;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterModel;
import org.openmicroscopy.shoola.env.data.events.RemoveGroupEvent;
import org.openmicroscopy.shoola.env.ui.TaskBar;

public class ImporterFactory
implements ChangeListener {
    private static final String NAME = "Importer";
    private static final String MENU_NAME = "Importer";
    private static final ImporterFactory singleton = new ImporterFactory();
    private Importer importer;
    private boolean isAttached = false;
    private JMenu windowMenu = new JMenu("Importer");

    public static boolean doesImporterExist() {
        return ImporterFactory.singleton.importer != null;
    }

    public static Importer getImporter(long groupId, boolean master, int displayMode) {
        ImporterModel model = new ImporterModel(groupId, master, displayMode);
        return singleton.getImporter(model);
    }

    public static Importer getImporter(long groupId, int displayMode) {
        return ImporterFactory.getImporter(groupId, false, displayMode);
    }

    public static void onGroupSwitched(boolean success) {
        if (!success) {
            return;
        }
        if (ImporterFactory.singleton.importer != null && ((ImporterComponent)ImporterFactory.singleton.importer).isMaster()) {
            ((ImporterComponent)ImporterFactory.singleton.importer).onGroupSwitched(success);
            return;
        }
        singleton.clear();
    }

    public static void terminate() {
        if (ImporterFactory.singleton.importer != null) {
            ((ImporterComponent)ImporterFactory.singleton.importer).shutDown();
        }
    }

    public static void onReconnected() {
        if (ImporterFactory.singleton.importer != null) {
            ImporterFactory.singleton.importer.discard();
            ImporterFactory.singleton.windowMenu.removeAll();
            ImporterFactory.singleton.isAttached = false;
            TaskBar tb = ImporterAgent.getRegistry().getTaskBar();
            tb.removeFromMenu(0, ImporterFactory.singleton.windowMenu);
            ImporterFactory.singleton.importer = null;
        }
    }

    public static void setDiplayMode(int displayMode) {
        if (ImporterFactory.singleton.importer == null) {
            return;
        }
        ((ImporterComponent)ImporterFactory.singleton.importer).setDisplayMode(displayMode);
    }

    public static void hasOnGoingImport(SecurityContext ctx) {
        if (ImporterFactory.singleton.importer == null || ctx == null) {
            return;
        }
        if (!((ImporterComponent)ImporterFactory.singleton.importer).hasOnGoingImport(ctx)) {
            ImporterAgent.getRegistry().getEventBus().post(new RemoveGroupEvent(ctx));
        }
    }

    static JMenu getWindowMenu() {
        return ImporterFactory.singleton.windowMenu;
    }

    static boolean isWindowMenuAttachedToTaskBar() {
        return ImporterFactory.singleton.isAttached;
    }

    static void attachWindowMenuToTaskBar() {
        if (ImporterFactory.isWindowMenuAttachedToTaskBar()) {
            return;
        }
        TaskBar tb = ImporterAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, ImporterFactory.singleton.windowMenu);
        ImporterFactory.singleton.isAttached = true;
    }

    private ImporterFactory() {
    }

    private Importer getImporter(ImporterModel model) {
        if (this.importer != null) {
            ((ImporterComponent)this.importer).resetGroup(model.getGroupId());
            return this.importer;
        }
        ImporterComponent comp = new ImporterComponent(model);
        model.initialize(comp);
        comp.initialize();
        this.importer = comp;
        return this.importer;
    }

    private void clear() {
        if (this.importer == null) {
            return;
        }
        this.importer.removeChangeListener(this);
        this.importer.discard();
        this.importer = null;
        this.handleViewerDiscarded();
    }

    private void handleViewerDiscarded() {
        if (!ImporterFactory.singleton.isAttached) {
            return;
        }
        if (ImporterFactory.singleton.importer != null) {
            return;
        }
        TaskBar tb = ImporterAgent.getRegistry().getTaskBar();
        tb.removeFromMenu(0, ImporterFactory.singleton.windowMenu);
        ImporterFactory.singleton.isAttached = false;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        ImporterComponent comp = (ImporterComponent)ce.getSource();
        if (comp.getState() == 3) {
            this.importer = null;
            this.handleViewerDiscarded();
        }
    }
}

