/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;
import omero.gateway.model.DataObject;
import omero.gateway.model.FileAnnotationData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.PojosUtil;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

public class DownloadAction
extends TreeViewerAction {
    private static final String NAME = "Download...";
    private static final String DESCRIPTION = "Download the selected files.";

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: {
                this.setEnabled(false);
                break;
            }
            default: {
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        this.enabled = false;
        Object ho = selectedDisplay.getUserObject();
        if (ho instanceof FileAnnotationData) {
            this.setEnabled(true);
        } else {
            Browser browser = this.model.getSelectedBrowser();
            List list = browser.getSelectedDataObjects();
            for (DataObject data : list) {
                if (!PojosUtil.isDownloadable(data)) continue;
                this.enabled = true;
                break;
            }
        }
        this.setEnabled(this.enabled);
    }

    public DownloadAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        this.description = (String)this.getValue("ShortDescription");
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(108));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay node = browser.getLastSelectedDisplay();
        if (node == null) {
            return;
        }
        JFrame f = TreeViewerAgent.getRegistry().getTaskBar().getFrame();
        int type = 2;
        FileChooser chooser = new FileChooser(f, type, "Download", "Select where to download the file(s).");
        IconManager icons = IconManager.getInstance();
        chooser.setTitleIcon(icons.getIcon(109));
        chooser.setApproveButtonText("Download");
        chooser.setCheckOverride(true);
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                FileChooser src = (FileChooser)evt.getSource();
                if ("approveSelection".equals(name)) {
                    String path = (String)evt.getNewValue();
                    DownloadAction.this.model.download(new File(path), src.isOverride(), null);
                }
            }
        });
        chooser.centerDialog();
    }
}

