/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import javax.swing.SwingUtilities;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SwitchUserAction
extends TreeViewerAction
implements MouseListener {
    public static final String NAME = "Display User...";
    public static final String NAME_TO = "Display User from";
    public static final String DESCRIPTION = "Select users and view their data.";
    private Point point;

    private void handleGroupSelection(GroupData group) {
        if (group == null) {
            this.setEnabled(false);
            return;
        }
        Set<ExperimenterData> l = group.getExperimenters();
        if (l == null) {
            this.setEnabled(true);
            return;
        }
        int level = this.model.getGroupPermissions(group);
        boolean b = false;
        if (level == 0) {
            if (this.model.isLeaderOfGroup(group) || TreeViewerAgent.isAdministrator()) {
                b = l.size() > 1;
            }
        } else {
            b = l.size() > 1;
        }
        this.setEnabled(b);
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        this.handleGroupSelection(this.model.getSelectedGroup());
    }

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        if (browser.getBrowserType() == 6) {
            this.setEnabled(false);
            return;
        }
        if (browser.getState() == 15) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    protected void onBrowserSelection(Browser browser) {
        this.onBrowserStateChange(browser);
    }

    public SwitchUserAction(TreeViewer model) {
        super(model);
        this.setEnabled(false);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(23));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.point != null) {
            SwingUtilities.convertPointToScreen(this.point, (Component)e.getSource());
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

