/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.SelectableMenuItem;

public class DataMenuItem
extends SelectableMenuItem
implements ActionListener {
    public static final String ALL_USERS_TEXT;
    public static final String USERS_TEXT;
    public static final String ITEM_SELECTED_PROPERTY;
    private final Object data;
    private boolean canBeEnabled;
    private String refString = null;

    public DataMenuItem(Object data, Icon icon) {
        this(data, icon, true);
    }

    public DataMenuItem(Object data, Icon icon, boolean canBeEnabled) {
        super(false, data.toString(), canBeEnabled);
        if (data instanceof ExperimenterData) {
            this.setText(EditorUtil.formatExperimenter((ExperimenterData)data));
        } else if (data instanceof GroupData) {
            this.setText(((GroupData)data).getName());
        } else {
            this.setText(data.toString());
        }
        if (icon != null) {
            this.setIcon(icon);
        }
        this.canBeEnabled = canBeEnabled;
        this.data = data;
        this.setEnabled(true);
        this.addActionListener(this);
    }

    public DataMenuItem(Object data, boolean canBeEnabled) {
        this(data, null, canBeEnabled);
    }

    public String getRefString() {
        return this.refString;
    }

    public void setRefString(String refString) {
        this.refString = refString;
    }

    public Object getDataObject() {
        return this.data;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!this.canBeEnabled) {
            enabled = false;
        }
        super.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.firePropertyChange(ITEM_SELECTED_PROPERTY, null, this);
    }

    static {
        ITEM_SELECTED_PROPERTY = "itemSelectedProperty";
        ALL_USERS_TEXT = "Show All Users";
        USERS_TEXT = "Display Users";
    }
}

