/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FolderData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.dnd.DnDTree;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon IMAGE_ICON;
    private static final Icon DATASET_ICON;
    private static final Icon PROJECT_ICON;
    private static final Icon TAG_ICON;
    private static final Icon TAG_SET_ICON;
    private static final Icon OWNER_ICON;
    private static final Icon FILE_TEXT_ICON;
    private static final Icon GROUP_PRIVATE_ICON;
    private static final Icon GROUP_READ_ONLY_ICON;
    private static final Icon GROUP_READ_LINK_ICON;
    private static final Icon GROUP_READ_WRITE_ICON;
    private static final Icon GROUP_PUBLIC_READ_ICON;
    private static final Icon GROUP_PUBLIC_READ_WRITE_ICON;
    private static final Icon FOLDER_ICON;
    private static final Icon FOLDER_ICON_NOT_OWNER;
    private static final Dimension SIZE;
    private boolean numberChildrenVisible;
    private boolean isTargetNode;
    private boolean droppedAllowed;
    private Color draggedColor;
    private boolean selected;
    private int xText;
    private ExperimenterData user;

    private void setIcon(TreeImageDisplay node) {
        Object usrObject = node.getUserObject();
        Icon icon = FILE_TEXT_ICON;
        if (usrObject instanceof ProjectData) {
            icon = PROJECT_ICON;
        } else if (usrObject instanceof DatasetData) {
            icon = DATASET_ICON;
        } else if (usrObject instanceof ImageData) {
            icon = IMAGE_ICON;
        } else if (usrObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)usrObject;
            String ns = tag.getNameSpace();
            icon = "openmicroscopy.org/omero/insight/tagset".equals(ns) ? TAG_SET_ICON : TAG_ICON;
        } else if (usrObject instanceof GroupData) {
            GroupData g = (GroupData)usrObject;
            switch (g.getPermissions().getPermissionsLevel()) {
                case 0: {
                    icon = GROUP_PRIVATE_ICON;
                    break;
                }
                case 1: {
                    icon = GROUP_READ_ONLY_ICON;
                    break;
                }
                case 2: {
                    icon = GROUP_READ_LINK_ICON;
                    break;
                }
                case 3: {
                    icon = GROUP_READ_WRITE_ICON;
                    break;
                }
                case 4: {
                    icon = GROUP_PUBLIC_READ_ICON;
                    break;
                }
                case 5: {
                    icon = GROUP_PUBLIC_READ_WRITE_ICON;
                }
            }
        } else if (usrObject instanceof ExperimenterData) {
            icon = OWNER_ICON;
        } else if (usrObject instanceof FolderData) {
            FolderData f = (FolderData)usrObject;
            icon = f.getOwner() == null || this.user == null || f.getOwner().getId() == this.user.getId() ? FOLDER_ICON : FOLDER_ICON_NOT_OWNER;
        }
        this.setIcon(icon);
    }

    private void setTextColor(Color c) {
        if (c == null) {
            return;
        }
        if (UIUtilities.isDarkColor(c)) {
            this.setForeground(UIUtilities.DEFAULT_TEXT);
        }
    }

    public TreeCellRenderer(ExperimenterData user, boolean b) {
        this.user = user;
        this.numberChildrenVisible = b;
        this.selected = false;
        this.draggedColor = new Color(this.backgroundSelectionColor.getRed(), this.backgroundSelectionColor.getGreen(), this.backgroundSelectionColor.getBlue(), 100);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.isTargetNode = false;
        this.droppedAllowed = true;
        this.selected = sel;
        if (tree instanceof DnDTree) {
            DnDTree dndTree = (DnDTree)tree;
            boolean bl = this.isTargetNode = value == dndTree.getDropTargetNode();
            if (dndTree.getRowDropLocation() == row) {
                this.droppedAllowed = false;
            }
        }
        this.setIcon(FILE_TEXT_ICON);
        if (!(value instanceof TreeImageDisplay)) {
            return this;
        }
        TreeImageDisplay node = (TreeImageDisplay)value;
        int w = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Object ho = node.getUserObject();
        if (node.getLevel() == 0) {
            if (ho instanceof ExperimenterData) {
                this.setIcon(OWNER_ICON);
            }
            if (this.getIcon() != null) {
                w += this.getIcon().getIconWidth();
            }
            w += this.getIconTextGap();
            this.setPreferredSize(new Dimension(w += fm.stringWidth(this.getText()), fm.getHeight()));
            Color c = node.getHighLight();
            if (c == null) {
                c = tree.getForeground();
            }
            this.setForeground(c);
            if (!sel) {
                this.setBorderSelectionColor(this.getBackground());
            } else {
                this.setTextColor(this.getBackgroundSelectionColor());
            }
            return this;
        }
        this.setIcon(node);
        if (this.numberChildrenVisible) {
            this.setText(node.getNodeText());
        } else {
            this.setText(node.getNodeName());
        }
        this.setToolTipText(node.getToolTip());
        Color c = node.getHighLight();
        if (c == null) {
            c = tree.getForeground();
        }
        this.setForeground(c);
        if (!sel) {
            this.setBorderSelectionColor(this.getBackground());
        } else {
            this.setTextColor(this.getBackgroundSelectionColor());
        }
        w = this.getIcon() != null ? (w += this.getIcon().getIconWidth()) : (w += TreeCellRenderer.SIZE.width);
        this.xText = w += this.getIconTextGap();
        w = ho instanceof ImageData ? (w += fm.stringWidth(node.getNodeName())) : (node instanceof TreeFileSet ? (w += fm.stringWidth(this.getText()) + 40) : (w += fm.stringWidth(this.getText())));
        this.setPreferredSize(new Dimension(w, fm.getHeight() + 4));
        this.setEnabled(node.isSelectable());
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isTargetNode) {
            if (!this.droppedAllowed) {
                if (this.selected) {
                    g.setColor(this.backgroundSelectionColor);
                } else {
                    g.setColor(this.backgroundNonSelectionColor);
                }
            } else {
                g.setColor(this.draggedColor);
            }
            g.fillRect(this.xText, 0, this.getSize().width, this.getSize().height);
        }
        this.selected = false;
        this.isTargetNode = false;
        this.droppedAllowed = false;
        super.paintComponent(g);
    }

    static {
        IconManager icons = IconManager.getInstance();
        GROUP_PRIVATE_ICON = icons.getIcon(141);
        GROUP_READ_ONLY_ICON = icons.getIcon(142);
        GROUP_READ_LINK_ICON = icons.getIcon(143);
        GROUP_READ_WRITE_ICON = icons.getIcon(154);
        GROUP_PUBLIC_READ_ICON = icons.getIcon(144);
        GROUP_PUBLIC_READ_WRITE_ICON = icons.getIcon(158);
        IMAGE_ICON = icons.getIcon(44);
        DATASET_ICON = icons.getIcon(45);
        PROJECT_ICON = icons.getIcon(122);
        TAG_ICON = icons.getIcon(64);
        TAG_SET_ICON = icons.getIcon(65);
        OWNER_ICON = icons.getIcon(42);
        FILE_TEXT_ICON = icons.getIcon(102);
        FOLDER_ICON = icons.getIcon(159);
        FOLDER_ICON_NOT_OWNER = icons.getIcon(160);
        SIZE = new Dimension(16, 16);
    }
}

