/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.IllegalArgumentException;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;

public class AdminObject {
    public static final int CREATE_GROUP = 0;
    public static final int CREATE_EXPERIMENTER = 1;
    public static final int UPDATE_GROUP = 2;
    public static final int UPDATE_EXPERIMENTER = 3;
    public static final int RESET_PASSWORD = 4;
    public static final int ADD_EXPERIMENTER_TO_GROUP = 5;
    public static final int ACTIVATE_USER = 6;
    private GroupData group;
    private List<GroupData> groups;
    private Map<ExperimenterData, UserCredentials> experimenters;
    private int index;
    private int permissions = -1;

    private void checkIndex(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported");
    }

    public AdminObject(GroupData group, Map<ExperimenterData, UserCredentials> experimenters, int index) {
        this.checkIndex(index);
        this.group = group;
        this.experimenters = experimenters;
        this.index = index;
        this.permissions = -1;
    }

    public AdminObject(GroupData group, Collection<ExperimenterData> values) {
        if (values != null) {
            Iterator<ExperimenterData> i = values.iterator();
            this.experimenters = new HashMap<ExperimenterData, UserCredentials>();
            while (i.hasNext()) {
                this.experimenters.put(i.next(), null);
            }
        }
        this.group = group;
        this.index = 5;
        this.permissions = -1;
    }

    public AdminObject(Map<ExperimenterData, UserCredentials> experimenters, int index) {
        this(null, experimenters, index);
    }

    public void setPermissions(int permissions) {
        switch (permissions) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.permissions = permissions;
                break;
            }
            default: {
                this.permissions = 0;
            }
        }
    }

    public int getPermissions() {
        return this.permissions;
    }

    public Map<ExperimenterData, UserCredentials> getExperimenters() {
        return this.experimenters;
    }

    public GroupData getGroup() {
        return this.group;
    }

    public void setGroups(List<GroupData> groups) {
        this.groups = groups;
    }

    public List<GroupData> getGroups() {
        return this.groups;
    }

    public int getIndex() {
        return this.index;
    }
}

