/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.io.File;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.util.Status;

public class ImportableFile {
    private GroupData group;
    private FileObject file;
    private boolean folderAsContainer;
    private Status status;
    private DataObject parent;
    private DatasetData dataset;
    private Object refNode;
    private ExperimenterData user;
    private FileObject originalFile;

    public ImportableFile(FileObject file, boolean folderAsContainer) {
        this.file = file;
        this.folderAsContainer = folderAsContainer;
        this.originalFile = file;
    }

    public void setFolderAsContainer(boolean folderAsContainer) {
        this.folderAsContainer = folderAsContainer;
    }

    public void setLocation(DataObject parent, DatasetData dataset) {
        this.parent = parent;
        this.dataset = dataset;
    }

    public DataObject getParent() {
        return this.parent;
    }

    public DatasetData getDataset() {
        return this.dataset;
    }

    public FileObject getFile() {
        return this.file;
    }

    public FileObject getOriginalFile() {
        if (this.originalFile == null) {
            return this.file;
        }
        return this.originalFile;
    }

    public boolean isFolderAsContainer() {
        return this.folderAsContainer;
    }

    public boolean isDatasetCreated() {
        return this.dataset != null && this.dataset.getId() >= 0L;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public Object getRefNode() {
        return this.refNode;
    }

    public void setRefNode(Object refNode) {
        this.refNode = refNode;
    }

    public void setFile(File file) {
        this.file = new FileObject(file);
    }

    public void setGroup(GroupData group) {
        this.group = group;
    }

    public GroupData getGroup() {
        return this.group;
    }

    public void setUser(ExperimenterData user) {
        this.user = user;
    }

    public ExperimenterData getUser() {
        return this.user;
    }

    public ImportableFile copy() {
        ImportableFile newObject = new ImportableFile(this.file, this.folderAsContainer);
        newObject.dataset = this.dataset;
        newObject.parent = this.parent;
        newObject.file = this.file;
        newObject.refNode = this.refNode;
        newObject.group = this.group;
        newObject.user = this.user;
        newObject.status = new Status(this.file);
        return newObject;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.originalFile.getAbsolutePath());
        if (this.group != null) {
            buf.append("_" + this.group.getId());
        }
        if (this.user != null) {
            buf.append("_" + this.user.getId());
        }
        return buf.toString();
    }
}

