/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.log;

import java.io.File;
import omero.log.Logger;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.log.ConsoleLoggerImpl;
import org.openmicroscopy.shoola.env.log.LoggerImpl;
import org.openmicroscopy.shoola.env.log.PluginLoggerImpl;

public class LoggerFactory {
    private static final String LOG_CONFIG_FILE = "logback-spring.xml";

    public static Logger makeNew(Container c) {
        String relPathName;
        File configFile;
        if (c == null) {
            return null;
        }
        Registry reg = c.getRegistry();
        Boolean isLoggingOn = (Boolean)reg.lookup("/services/LOG/on");
        Boolean console = (Boolean)reg.lookup("/services/LOG/output/console");
        if (!isLoggingOn.booleanValue()) {
            new ConsoleLoggerImpl(console == null ? false : console);
        }
        if (!(configFile = new File(relPathName = c.getConfigFileRelative(LOG_CONFIG_FILE))).exists() || !configFile.isFile()) {
            new ConsoleLoggerImpl(console == null ? false : console);
        }
        String logDirName = (String)reg.lookup("/services/LOG/dir");
        String logFileName = (String)reg.lookup("/services/LOG/file");
        String name = (String)reg.lookup("/services/OMERO/home");
        String omeroDir = System.getProperty("user.home") + File.separator + name;
        File home = new File(omeroDir);
        if (!home.exists()) {
            home.mkdir();
        }
        Integer v = (Integer)reg.lookup("Plugin");
        int value = -1;
        if (v != null) {
            value = v;
        }
        if (value < 0) {
            if (!home.isDirectory()) {
                home = new File(c.getHomeDir());
            }
            File logDir = new File(home, logDirName);
            logDir.mkdir();
            File logFile = logDir.isDirectory() ? new File(logDir, logFileName) : new File(home, logFileName);
            return new LoggerImpl(relPathName, logFile.getAbsolutePath(), console == null ? false : console);
        }
        return new PluginLoggerImpl(value);
    }
}

