/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.Timer;
import omero.gateway.Gateway;
import org.openmicroscopy.shoola.util.ui.NotificationDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ShutDownDialog
extends NotificationDialog
implements ActionListener {
    private static final int DEFAULT_TIME = 120;
    private static final String SHUTDOWN_MESSAGE = "If the connection cannot be re-established,\nthe application will shut down in ";
    private Timer timer;
    private int remainingTime;
    private Gateway gateway;
    private int index;
    private int checkupTime;

    private void formatText(int time) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.message);
        buffer.append(SHUTDOWN_MESSAGE);
        buffer.append(UIUtilities.formatTimeInSeconds(time));
        buffer.append(".");
        this.contentPanel.setDescription(buffer.toString());
        this.repaint();
    }

    private void initialize(int time) {
        this.checkupTime = 5;
        this.removeWindowListener(this.windowAdapter);
        this.setDefaultCloseOperation(0);
        this.remainingTime = time;
        this.okButton.setText("Shut Down");
        this.okButton.setToolTipText("Shut down the application.");
        int speed = 1000;
        int pause = 1000;
        this.timer = new Timer(speed, this);
        this.timer.setInitialDelay(pause);
        this.timer.start();
        if (this.index == -1) {
            this.formatText(time);
            this.setSize(400, 200);
        } else {
            this.pack();
        }
        this.setResizable(false);
    }

    public ShutDownDialog(JDialog owner, String title, String message, int time, int index) {
        super(owner, title, message, null);
        this.index = index;
        this.initialize(time);
    }

    public ShutDownDialog(JFrame owner, String title, String message, int time, int index) {
        super(owner, title, message, null);
        this.index = index;
        this.initialize(time);
    }

    public ShutDownDialog(JDialog owner, String title, String message, int index) {
        this(owner, title, message, 120, index);
    }

    public ShutDownDialog(JDialog owner, String title, String message) {
        this(owner, title, message, 120, -1);
    }

    public ShutDownDialog(JFrame owner, String title, String message, int index) {
        this(owner, title, message, 120, index);
    }

    public ShutDownDialog(JFrame owner, String title, String message) {
        this(owner, title, message, 120, -1);
    }

    public void setGateway(Gateway gateway) {
        this.gateway = gateway;
    }

    public void setCheckupTime(int time) {
        if (time <= 0) {
            time = 1;
        }
        this.checkupTime = time;
    }

    @Override
    protected void close() {
        if (this.timer != null) {
            this.timer.stop();
        }
        super.close();
    }

    @Override
    protected void cancel() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.setVisible(false);
        this.dispose();
        this.firePropertyChange("cancelNotification", -2, this.index);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        --this.remainingTime;
        if (this.index == -1) {
            this.formatText(this.remainingTime);
        }
        if (this.remainingTime % this.checkupTime == 0) {
            try {
                if (this.gateway.isNetworkUp(false)) {
                    this.cancel();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.remainingTime == 0) {
            this.close();
        }
    }
}

