/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TreeComponentNode;

public class TreeComponent
extends JPanel
implements PropertyChangeListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final String EXPANDED_PROPERTY = "expanded";
    private Icon collapseIcon;
    private Icon elapseIcon;
    private int orientation;
    private List<TreeComponentNode> nodes;

    private void initialize() {
        this.nodes = new ArrayList<TreeComponentNode>();
        IconManager icons = IconManager.getInstance();
        switch (this.orientation) {
            case 1: {
                this.collapseIcon = icons.getIcon(97);
                this.elapseIcon = icons.getIcon(96);
                this.setLayout(new BoxLayout(this, 1));
                break;
            }
            case 0: {
                this.collapseIcon = icons.getIcon(97);
                this.elapseIcon = icons.getIcon(96);
                this.setLayout(new BoxLayout(this, 0));
            }
        }
    }

    private void expandNodes(boolean expanded) {
        for (TreeComponentNode node : this.nodes) {
            node.setExpanded(expanded);
            node.setIcons(this.collapseIcon, this.elapseIcon);
            node.updateDisplay();
        }
    }

    public TreeComponent() {
        this(1);
    }

    public TreeComponent(int orientation) {
        this.orientation = orientation;
        this.initialize();
    }

    int getOrientation() {
        return this.orientation;
    }

    public void insertNode(JComponent elapse, JComponent collapse) {
        this.insertNode(elapse, collapse, true);
    }

    public void insertNode(JComponent elapse, JComponent collapse, boolean expanded) {
        TreeComponentNode node = new TreeComponentNode(elapse, collapse, expanded);
        node.setIcons(this.collapseIcon, this.elapseIcon);
        node.addPropertyChangeListener("expandedNode", this);
        this.add(node);
        this.nodes.add(node);
    }

    public void collapseNodes() {
        this.expandNodes(false);
    }

    public void expandNodes() {
        this.expandNodes(true);
    }

    public void setTreeEnabled(boolean enabled) {
        for (TreeComponentNode node : this.nodes) {
            node.setNodeEnabled(enabled);
            node.updateDisplay();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TreeComponentNode node = (TreeComponentNode)evt.getSource();
        node.setIcons(this.collapseIcon, this.elapseIcon);
        this.revalidate();
        if (node.isExpanded()) {
            this.firePropertyChange(EXPANDED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
        } else {
            this.firePropertyChange(EXPANDED_PROPERTY, Boolean.TRUE, Boolean.FALSE);
        }
    }
}

