/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.List;
import omero.RString;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.BooleanAnnotationData;
import omero.gateway.model.DataObject;
import omero.gateway.model.DoubleAnnotationData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import omero.gateway.model.LongAnnotationData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.ROIData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;
import omero.gateway.model.TextualAnnotationData;
import omero.gateway.model.TimeAnnotationData;
import omero.gateway.model.XMLAnnotationData;
import omero.model.Annotation;
import omero.model.BooleanAnnotation;
import omero.model.CommentAnnotation;
import omero.model.DoubleAnnotation;
import omero.model.FileAnnotation;
import omero.model.Folder;
import omero.model.FolderAnnotationLink;
import omero.model.FolderI;
import omero.model.FolderImageLink;
import omero.model.FolderRoiLink;
import omero.model.LongAnnotation;
import omero.model.MapAnnotation;
import omero.model.TagAnnotation;
import omero.model.TermAnnotation;
import omero.model.TimestampAnnotation;
import omero.model.XmlAnnotation;
import omero.rtypes;

public class FolderData
extends DataObject {
    private String folderPathString = null;
    private char folderPathSeparatorChar = (char)62;

    public FolderData() {
        this.setDirty(true);
        this.setValue(new FolderI());
    }

    public FolderData(Folder folder) {
        if (folder == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(folder);
    }

    public String getName() {
        RString n = this.asFolder().getName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have been null.");
        }
        return n.getValue();
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asFolder().setName(rtypes.rstring(name));
    }

    public String getDescription() {
        return this.asFolder().getDescription() != null ? this.asFolder().getDescription().getValue() : "";
    }

    public void setDescription(String desc) {
        this.setDirty(true);
        this.asFolder().setDescription(rtypes.rstring(desc));
    }

    public FolderData getParentFolder() {
        Folder f = this.asFolder().getParentFolder();
        return f == null ? null : new FolderData(f);
    }

    public void setParentFolder(Folder parent) {
        Folder f = this.asFolder();
        f.setParentFolder(parent);
    }

    public void setFolder(Folder f) {
        this.setValue(f);
    }

    public int subfolderCount() {
        return this.asFolder().sizeOfChildFolders();
    }

    public int imageCount() {
        return this.asFolder().sizeOfImageLinks();
    }

    public int roiCount() {
        return this.asFolder().sizeOfRoiLinks();
    }

    public List<FolderData> copyChildFolders() {
        Folder f = this.asFolder();
        List<Folder> children = f.copyChildFolders();
        ArrayList<FolderData> result = new ArrayList<FolderData>(children.size());
        for (Folder child : children) {
            result.add(new FolderData(child));
        }
        return result;
    }

    public List<AnnotationData> copyAnnotationLinks() {
        Folder f = this.asFolder();
        List<FolderAnnotationLink> links = f.copyAnnotationLinks();
        ArrayList<AnnotationData> result = new ArrayList<AnnotationData>(links.size());
        for (FolderAnnotationLink l : links) {
            Annotation anno = l.getChild();
            if (anno instanceof BooleanAnnotation) {
                result.add(new BooleanAnnotationData((BooleanAnnotation)anno));
                continue;
            }
            if (anno instanceof DoubleAnnotation) {
                result.add(new DoubleAnnotationData((DoubleAnnotation)anno));
                continue;
            }
            if (anno instanceof FileAnnotation) {
                result.add(new FileAnnotationData((FileAnnotation)anno));
                continue;
            }
            if (anno instanceof LongAnnotation) {
                result.add(new LongAnnotationData((LongAnnotation)anno));
                continue;
            }
            if (anno instanceof MapAnnotation) {
                result.add(new MapAnnotationData((MapAnnotation)anno));
                continue;
            }
            if (anno instanceof TagAnnotation) {
                result.add(new TagAnnotationData((TagAnnotation)anno));
                continue;
            }
            if (anno instanceof TermAnnotation) {
                result.add(new TermAnnotationData((TermAnnotation)anno));
                continue;
            }
            if (anno instanceof CommentAnnotation) {
                result.add(new TextualAnnotationData((CommentAnnotation)anno));
                continue;
            }
            if (anno instanceof TimestampAnnotation) {
                result.add(new TimeAnnotationData((TimestampAnnotation)anno));
                continue;
            }
            if (!(anno instanceof XmlAnnotation)) continue;
            result.add(new XMLAnnotationData((XmlAnnotation)anno));
        }
        return result;
    }

    public List<ImageData> copyImageLinks() {
        Folder f = this.asFolder();
        List<FolderImageLink> links = f.copyImageLinks();
        ArrayList<ImageData> result = new ArrayList<ImageData>(links.size());
        for (FolderImageLink l : links) {
            result.add(new ImageData(l.getChild()));
        }
        return result;
    }

    public List<ROIData> copyROILinks() {
        Folder f = this.asFolder();
        List<FolderRoiLink> links = f.copyRoiLinks();
        ArrayList<ROIData> result = new ArrayList<ROIData>(links.size());
        for (FolderRoiLink l : links) {
            result.add(new ROIData(l.getChild()));
        }
        return result;
    }

    @Override
    public String toString() {
        return this.getFolderPathString() + " [id=" + this.getId() + "]";
    }

    public String getFolderPathString() {
        return this.getFolderPathString(this.folderPathSeparatorChar);
    }

    public String getFolderPathString(char pathSeparator) {
        if (this.folderPathString == null || this.folderPathSeparatorChar != pathSeparator) {
            StringBuilder sb = new StringBuilder();
            this.generateFolderPath(this, sb, pathSeparator);
            this.folderPathString = sb.toString();
            this.folderPathSeparatorChar = pathSeparator;
        }
        return this.folderPathString;
    }

    private void generateFolderPath(FolderData f, StringBuilder sb, char pathSeparator) {
        sb.insert(0, f.getName());
        FolderData parent = f.getParentFolder();
        if (parent != null && parent.isLoaded()) {
            sb.insert(0, " " + pathSeparator + " ");
            this.generateFolderPath(f.getParentFolder(), sb, pathSeparator);
        }
    }
}

