/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserBICanvas;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;

class ImageCanvasListener
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final Point DEFAULT_POINT = new Point(0, 0);
    private BrowserModel model;
    private BrowserUI view;
    private JComponent canvas;
    private Rectangle area;
    private Point pressedPoint;
    private boolean handleKeyDown;
    private boolean dragged;

    private void pan(Point p, boolean load) {
        if (p == null) {
            return;
        }
        this.view.pan(p.x - this.pressedPoint.x, p.y - this.pressedPoint.y, load);
    }

    ImageCanvasListener(BrowserUI view, BrowserModel model, JComponent canvas) {
        if (model == null) {
            throw new NullPointerException("No Model.");
        }
        if (canvas == null) {
            throw new NullPointerException("No canvas.");
        }
        if (view == null) {
            throw new NullPointerException("No View.");
        }
        this.model = model;
        this.canvas = canvas;
        this.view = view;
        this.area = new Rectangle(0, 0, 0, 0);
        this.installListeners(true);
        this.handleKeyDown = false;
        this.pressedPoint = new Point(0, 0);
    }

    void installListeners(boolean add) {
        if (add) {
            if (!Arrays.asList(this.canvas.getMouseListeners()).contains(this)) {
                this.canvas.addMouseListener(this);
                this.canvas.addMouseMotionListener(this);
                this.canvas.addMouseWheelListener(this);
            }
        } else {
            this.canvas.removeMouseListener(this);
            this.canvas.removeMouseMotionListener(this);
            this.canvas.removeMouseWheelListener(this);
        }
    }

    void setHandleKeyDown(boolean handleKeyDown) {
        this.handleKeyDown = handleKeyDown;
    }

    void setAreaSize(int width, int height) {
        this.area.setBounds(0, 0, width, height);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        this.dragged = true;
        this.pan(p, false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.pressedPoint = e.getPoint();
        this.canvas.setCursor(Cursor.getPredefinedCursor(12));
        if (this.canvas instanceof BrowserBICanvas) {
            ((BrowserBICanvas)this.canvas).setPaintedString(this.model.getDefaultZ(), this.model.getRealSelectedT());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.canvas.setCursor(Cursor.getDefaultCursor());
        Point p = e.getPoint();
        if (this.handleKeyDown && e.isAltDown() || this.model.isBigImage() && this.dragged) {
            this.pan(p, true);
        }
        this.dragged = false;
        this.pressedPoint = DEFAULT_POINT;
        SwingUtilities.convertPointToScreen(this.pressedPoint, this.canvas);
        if (this.canvas instanceof BrowserBICanvas) {
            ((BrowserBICanvas)this.canvas).setPaintedString(-1, -1);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isAltDown() || e.isShiftDown() || e.isControlDown() || this.model.isBigImage()) {
            if (e.getScrollType() == 0) {
                int v = e.getWheelRotation();
                this.model.zoom(v < 0);
            }
            return;
        }
        int maxZ = this.model.getMaxZ();
        int maxT = this.model.getMaxT();
        if (maxZ <= 0 && maxT <= 0) {
            return;
        }
        boolean up = true;
        if (e.getWheelRotation() > 0) {
            up = false;
        }
        if (e.getScrollType() == 0) {
            int v = this.model.getDefaultZ() - e.getWheelRotation();
            if (up) {
                if (v <= maxZ) {
                    this.model.setSelectedXYPlane(v, -1);
                    if (this.canvas instanceof BrowserBICanvas) {
                        ((BrowserBICanvas)this.canvas).setPaintedString(v, this.model.getRealSelectedT());
                    }
                } else if (this.canvas instanceof BrowserBICanvas) {
                    ((BrowserBICanvas)this.canvas).setPaintedString(-1, -1);
                }
            } else if (v >= 0) {
                this.model.setSelectedXYPlane(v, -1);
                if (this.canvas instanceof BrowserBICanvas) {
                    ((BrowserBICanvas)this.canvas).setPaintedString(v, this.model.getDefaultT());
                }
            } else if (this.canvas instanceof BrowserBICanvas) {
                ((BrowserBICanvas)this.canvas).setPaintedString(-1, -1);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

