/*
 * Decompiled with CFR 0.152.
 */
package ome.api;

import java.util.List;
import java.util.Map;
import ome.annotations.Hidden;
import ome.annotations.NotNull;
import ome.annotations.Validate;
import ome.api.ServiceInterface;
import ome.conditions.AuthenticationException;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.model.enums.AdminPrivilege;
import ome.model.internal.Permissions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.system.EventContext;
import ome.system.Roles;

public interface IAdmin
extends ServiceInterface {
    public boolean canUpdate(IObject var1);

    public Experimenter getExperimenter(long var1);

    public Experimenter lookupExperimenter(@NotNull String var1);

    public List<Experimenter> lookupExperimenters();

    public List<Map<String, Object>> lookupLdapAuthExperimenters();

    public String lookupLdapAuthExperimenter(long var1);

    public ExperimenterGroup getGroup(long var1);

    public ExperimenterGroup lookupGroup(@NotNull String var1);

    public List<ExperimenterGroup> lookupGroups();

    public Experimenter[] containedExperimenters(long var1);

    public ExperimenterGroup[] containedGroups(long var1);

    public ExperimenterGroup getDefaultGroup(long var1);

    public List<Long> getLeaderOfGroupIds(Experimenter var1);

    public List<Long> getMemberOfGroupIds(Experimenter var1);

    public void updateSelf(@NotNull Experimenter var1);

    public long uploadMyUserPhoto(String var1, String var2, byte[] var3);

    public List<OriginalFile> getMyUserPhotos();

    public void updateExperimenter(@NotNull Experimenter var1);

    public void updateExperimenterWithPassword(@NotNull Experimenter var1, @Hidden String var2);

    public void updateGroup(@NotNull ExperimenterGroup var1);

    public long createUser(@NotNull Experimenter var1, @NotNull String var2);

    public long createSystemUser(@NotNull Experimenter var1);

    public long createRestrictedSystemUser(@NotNull Experimenter var1, @NotNull @Validate(value={AdminPrivilege.class}) List<AdminPrivilege> var2);

    public long createRestrictedSystemUserWithPassword(@NotNull Experimenter var1, @NotNull @Validate(value={AdminPrivilege.class}) List<AdminPrivilege> var2, @Hidden String var3);

    public long createExperimenter(@NotNull Experimenter var1, @NotNull ExperimenterGroup var2, ExperimenterGroup ... var3);

    public long createExperimenterWithPassword(@NotNull Experimenter var1, @Hidden String var2, @NotNull ExperimenterGroup var3, ExperimenterGroup ... var4);

    public long createGroup(ExperimenterGroup var1);

    public void addGroups(@NotNull Experimenter var1, ExperimenterGroup ... var2);

    public void removeGroups(@NotNull Experimenter var1, ExperimenterGroup ... var2);

    public void setDefaultGroup(@NotNull Experimenter var1, @NotNull ExperimenterGroup var2);

    public void setGroupOwner(@NotNull ExperimenterGroup var1, @NotNull Experimenter var2);

    public void unsetGroupOwner(@NotNull ExperimenterGroup var1, @NotNull Experimenter var2);

    public void addGroupOwners(@NotNull ExperimenterGroup var1, Experimenter ... var2);

    public void removeGroupOwners(@NotNull ExperimenterGroup var1, Experimenter ... var2);

    public void deleteExperimenter(@NotNull Experimenter var1);

    public void deleteGroup(@NotNull ExperimenterGroup var1);

    public void changeOwner(@NotNull IObject var1, @NotNull String var2);

    public void changeGroup(@NotNull IObject var1, @NotNull String var2);

    public void changePermissions(@NotNull IObject var1, @NotNull Permissions var2);

    public void moveToCommonSpace(IObject ... var1);

    @Deprecated
    public void reportForgottenPassword(String var1, String var2) throws AuthenticationException;

    public void changeExpiredCredentials(String var1, String var2, String var3) throws AuthenticationException;

    public void changePassword(@Hidden String var1);

    public void changePasswordWithOldPassword(@Hidden @NotNull String var1, @Hidden String var2);

    public void changeUserPassword(@NotNull String var1, @Hidden String var2);

    public void synchronizeLoginCache();

    public List<Experimenter> getAdminsWithPrivileges(@NotNull @Validate(value={AdminPrivilege.class}) List<AdminPrivilege> var1);

    public List<AdminPrivilege> getCurrentAdminPrivileges();

    public List<AdminPrivilege> getAdminPrivileges(@NotNull Experimenter var1);

    public void setAdminPrivileges(@NotNull Experimenter var1, @NotNull @Validate(value={AdminPrivilege.class}) List<AdminPrivilege> var2);

    public Roles getSecurityRoles();

    public EventContext getEventContext();
}

