/*
 * Decompiled with CFR 0.152.
 */
package ome.util.checksum;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import ome.util.checksum.Adler32ChecksumProviderImpl;
import ome.util.checksum.CRC32ChecksumProviderImpl;
import ome.util.checksum.ChecksumProvider;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.checksum.ChecksumType;
import ome.util.checksum.FileSizeChecksumProviderImpl;
import ome.util.checksum.MD5ChecksumProviderImpl;
import ome.util.checksum.Murmur128ChecksumProviderImpl;
import ome.util.checksum.Murmur32ChecksumProviderImpl;
import ome.util.checksum.SHA1ChecksumProviderImpl;

public class ChecksumProviderFactoryImpl
implements ChecksumProviderFactory {
    private static final ImmutableSet<ChecksumType> availableChecksumTypes = Sets.immutableEnumSet(Arrays.asList(ChecksumType.values()));

    @Override
    public ChecksumProvider getProvider(ChecksumType checksumType) {
        switch (checksumType) {
            case FILE_SIZE: {
                return new FileSizeChecksumProviderImpl();
            }
            case ADLER32: {
                return new Adler32ChecksumProviderImpl();
            }
            case CRC32: {
                return new CRC32ChecksumProviderImpl();
            }
            case MD5: {
                return new MD5ChecksumProviderImpl();
            }
            case MURMUR32: {
                return new Murmur32ChecksumProviderImpl();
            }
            case MURMUR128: {
                return new Murmur128ChecksumProviderImpl();
            }
        }
        return new SHA1ChecksumProviderImpl();
    }

    @Override
    public Set<ChecksumType> getAvailableTypes() {
        return availableChecksumTypes;
    }
}

