/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.exclusions;

import java.io.File;
import java.io.IOException;
import java.util.List;
import ome.formats.importer.ImportContainer;
import ome.formats.importer.exclusions.AbstractFileExclusion;
import ome.services.blitz.repo.path.ClientFilePathTransformer;
import ome.services.blitz.repo.path.FilePathRestrictionInstance;
import ome.services.blitz.repo.path.FilePathRestrictions;
import ome.services.blitz.repo.path.FsFile;
import ome.services.blitz.repo.path.MakePathComponentSafe;
import omero.ServerError;
import omero.api.IQueryPrx;
import omero.api.ServiceFactoryPrx;
import omero.model.IObject;
import omero.model.OriginalFile;
import omero.rtypes;
import omero.sys.ParametersI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPathExclusion
extends AbstractFileExclusion {
    private static final Logger log = LoggerFactory.getLogger(ClientPathExclusion.class);

    @Override
    public Boolean suggestExclusion(ServiceFactoryPrx factory, ImportContainer container) throws ServerError {
        String clientPath;
        IQueryPrx query = factory.getQueryService();
        List<IObject> files = query.findAllByQuery("select o from FilesetEntry fe join fe.originalFile o where fe.clientPath = :clientPath", new ParametersI().add("clientPath", rtypes.rstring(clientPath = this.calculateClientPath(container))).page(0, 100));
        if (files.size() > 0) {
            log.info("ClientPath match for filename: {}", (Object)clientPath);
            for (IObject obj : files) {
                OriginalFile ofile = (OriginalFile)obj;
                log.debug("Found original file: {}", (Object)ofile.getId().getValue());
            }
            return true;
        }
        return false;
    }

    private String calculateClientPath(ImportContainer container) {
        String fullpath = container.getFile().getAbsolutePath();
        FilePathRestrictions portableRequiredRules = FilePathRestrictionInstance.getFilePathRestrictions(FilePathRestrictionInstance.WINDOWS_REQUIRED, FilePathRestrictionInstance.UNIX_REQUIRED);
        ClientFilePathTransformer sanitizer = new ClientFilePathTransformer(new MakePathComponentSafe(portableRequiredRules));
        try {
            FsFile fsPath = sanitizer.getFsFileFromClientFile(new File(fullpath), Integer.MAX_VALUE);
            String clientPath = fsPath.toString();
            return clientPath;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

