/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ome.api.IQuery;
import ome.io.nio.PixelsService;
import ome.io.nio.ThumbnailService;
import ome.model.IObject;
import ome.parameters.Parameters;
import ome.security.ACLVoter;
import ome.security.basic.LightAdminPrivileges;
import ome.services.graphs.GraphPathBean;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphTraversal;
import ome.services.util.ReadOnlyStatus;
import ome.system.Roles;
import omero.api.LongPair;
import omero.cmd.DiskUsage2;
import omero.cmd.DiskUsage2Response;
import omero.cmd.ERR;
import omero.cmd.GraphException;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.graphs.BaseGraphTraversalProcessor;
import omero.cmd.graphs.GraphHelper;
import omero.cmd.graphs.GraphUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskUsage2I
extends DiskUsage2
implements IRequest,
ReadOnlyStatus.IsAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskUsage2I.class);
    private static final ImmutableMap<String, String> ALL_GROUPS_CONTEXT = ImmutableMap.of((Object)"omero.group", (Object)"-1");
    private static final Set<GraphPolicy.Ability> REQUIRED_ABILITIES = ImmutableSet.of();
    private final ACLVoter aclVoter;
    private final GraphPathBean graphPathBean;
    private final Set<Class<? extends IObject>> legalClasses;
    private final GraphPolicy graphPolicy;
    private PixelsService pixelsService;
    private ThumbnailService thumbnailService;
    private Helper helper;
    private GraphHelper graphHelper;
    private GraphTraversal graphTraversal;
    private SetMultimap<String, Long> targetMultimap = null;
    private GraphTraversal.PlanExecutor processor;
    private final Usage usage = new Usage();
    final SetMultimap<Long, String> typesWithFiles = HashMultimap.create();
    final Map<Long, OwnershipAndSize> fileSizes = new HashMap<Long, OwnershipAndSize>();

    public DiskUsage2I(ACLVoter aclVoter, Roles securityRoles, GraphPathBean graphPathBean, LightAdminPrivileges adminPrivileges, Set<Class<? extends IObject>> targetClasses, GraphPolicy graphPolicy) {
        this.aclVoter = aclVoter;
        this.graphPathBean = graphPathBean;
        this.legalClasses = targetClasses;
        this.graphPolicy = graphPolicy;
    }

    public void setPixelsService(PixelsService pixelsService) {
        this.pixelsService = pixelsService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    @Override
    public Map<String, String> getCallContext() {
        return new HashMap<String, String>((Map<String, String>)ALL_GROUPS_CONTEXT);
    }

    @Override
    public void init(Helper helper) {
        if (LOGGER.isDebugEnabled()) {
            GraphUtil.ParameterReporter arguments = new GraphUtil.ParameterReporter();
            arguments.addParameter("targetClasses", (Object)this.targetClasses);
            arguments.addParameter("targetObjects", this.targetObjects);
            LOGGER.debug("request: " + arguments);
        }
        this.helper = helper;
        helper.setSteps(5);
        this.graphHelper = new GraphHelper(helper, this.graphPathBean);
        this.graphTraversal = new GraphTraversal(helper.getSession(), helper.getEventContext(), this.aclVoter, this.graphPathBean, null, this.graphPolicy, new InternalProcessor());
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        try {
            switch (step) {
                case 0: {
                    this.targetMultimap = this.targetObjects != null ? this.graphHelper.getTargetMultimap(this.legalClasses, this.targetObjects) : HashMultimap.create();
                    if (this.targetClasses != null) {
                        IQuery queryService = this.helper.getServiceFactory().getQueryService();
                        for (String className : this.graphHelper.getTargetSet(this.legalClasses, this.targetClasses)) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("fetching IDs for class " + className);
                            }
                            String hql = "SELECT id FROM " + className;
                            for (Object[] resultRow : queryService.projection(hql, null)) {
                                if (resultRow == null) continue;
                                Long objectId = (Long)resultRow[0];
                                this.targetMultimap.put((Object)className, (Object)objectId);
                            }
                        }
                    }
                    return null;
                }
                case 1: {
                    Map.Entry<SetMultimap<String, Long>, SetMultimap<String, Long>> plan = this.graphTraversal.planOperation(this.targetMultimap, true, true);
                    this.targetMultimap.clear();
                    if (plan.getValue().isEmpty()) {
                        this.graphTraversal.assertNoUnlinking();
                    } else {
                        IllegalStateException e = new IllegalStateException("querying the model graph does not delete any objects");
                        this.helper.cancel(new ERR(), (Throwable)e, "graph-fail", new String[0]);
                    }
                    return null;
                }
                case 2: {
                    this.processor = this.graphTraversal.processTargets();
                    return null;
                }
                case 3: {
                    this.processor.execute();
                    return null;
                }
                case 4: {
                    for (Map.Entry<Long, OwnershipAndSize> fileIdSize : this.fileSizes.entrySet()) {
                        Long fileId = fileIdSize.getKey();
                        OwnershipAndSize fileSize = fileIdSize.getValue();
                        Set types = this.typesWithFiles.get((Object)fileId);
                        if (types.isEmpty()) {
                            types = ImmutableSet.of((Object)"OriginalFile");
                        }
                        this.usage.bumpTotals();
                        for (String type : types) {
                            this.usage.add(fileSize.owner, fileSize.group, type, fileSize.size);
                        }
                    }
                    return null;
                }
            }
            IllegalArgumentException e = new IllegalArgumentException("model object graph operation has no step " + step);
            throw this.helper.cancel(new ERR(), (Throwable)e, "bad-step", new String[0]);
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (ome.services.graphs.GraphException ge) {
            GraphException graphERR = new GraphException();
            graphERR.message = ge.message;
            throw this.helper.cancel((ERR)graphERR, (Throwable)ge, "graph-fail", new String[0]);
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "graph-fail", new String[0]);
        }
    }

    @Override
    public void finish() {
        this.helper.setResponseIfNull(this.usage.getDiskUsageResponse());
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    private static long getFileSize(String path) {
        File file = new File(path);
        return file.exists() ? file.length() : 0L;
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return true;
    }

    private final class InternalProcessor
    extends BaseGraphTraversalProcessor {
        private final Map<String, String> fileProperties;
        private final Map<String, String> attributions;
        private final IQuery queryService;

        public InternalProcessor() {
            super(DiskUsage2I.this.helper.getSession());
            this.fileProperties = ImmutableMap.of((Object)"FileAnnotation", (Object)"file", (Object)"FilesetEntry", (Object)"originalFile", (Object)"JobOriginalFileLink", (Object)"child", (Object)"PixelsOriginalFileMap", (Object)"parent", (Object)"Roi", (Object)"source");
            this.attributions = ImmutableMap.of((Object)"JobOriginalFileLink", (Object)"Job", (Object)"PixelsOriginalFileMap", (Object)"Pixels");
            this.queryService = DiskUsage2I.this.helper.getServiceFactory().getQueryService();
        }

        @Override
        public void processInstances(String className, Collection<Long> ids) throws ome.services.graphs.GraphException {
            block6: {
                Parameters parameters;
                block8: {
                    block7: {
                        block5: {
                            className = className.substring(className.lastIndexOf(46) + 1);
                            parameters = new Parameters().addIds(ids);
                            if (!"Pixels".equals(className)) break block5;
                            String hql = "SELECT id, details.owner.id, details.group.id FROM Pixels WHERE id IN (:ids)";
                            for (Object[] resultRow : this.queryService.projection("SELECT id, details.owner.id, details.group.id FROM Pixels WHERE id IN (:ids)", parameters)) {
                                if (resultRow == null) continue;
                                Long pixelsId = (Long)resultRow[0];
                                Long ownerId = (Long)resultRow[1];
                                Long groupId = (Long)resultRow[2];
                                String pixelsPath = DiskUsage2I.this.pixelsService.getPixelsPath(pixelsId);
                                DiskUsage2I.this.usage.bumpTotals().add(ownerId, groupId, className, DiskUsage2I.getFileSize(pixelsPath));
                                DiskUsage2I.this.usage.bumpTotals().add(ownerId, groupId, className, DiskUsage2I.getFileSize(pixelsPath + "_pyramid"));
                                DiskUsage2I.this.usage.bumpTotals().add(ownerId, groupId, className, DiskUsage2I.getFileSize(pixelsPath + "_pyramid" + ".pyr_lock"));
                            }
                            break block6;
                        }
                        if (!"Thumbnail".equals(className)) break block7;
                        String hql = "SELECT id, details.owner.id, details.group.id FROM Thumbnail WHERE id IN (:ids)";
                        for (Object[] resultRow : this.queryService.projection("SELECT id, details.owner.id, details.group.id FROM Thumbnail WHERE id IN (:ids)", parameters)) {
                            if (resultRow == null) continue;
                            Long thumbnailId = (Long)resultRow[0];
                            Long ownerId = (Long)resultRow[1];
                            Long groupId = (Long)resultRow[2];
                            String thumbnailPath = DiskUsage2I.this.thumbnailService.getThumbnailPath(thumbnailId);
                            DiskUsage2I.this.usage.bumpTotals().add(ownerId, groupId, className, DiskUsage2I.getFileSize(thumbnailPath));
                        }
                        break block6;
                    }
                    if (!"OriginalFile".equals(className)) break block8;
                    String hql = "SELECT id, details.owner.id, details.group.id, size FROM OriginalFile WHERE id IN (:ids)";
                    for (Object[] resultRow : this.queryService.projection("SELECT id, details.owner.id, details.group.id, size FROM OriginalFile WHERE id IN (:ids)", parameters)) {
                        if (resultRow == null || !(resultRow[3] instanceof Long)) continue;
                        Long fileId = (Long)resultRow[0];
                        Long ownerId = (Long)resultRow[1];
                        Long groupId = (Long)resultRow[2];
                        Long fileSize = (Long)resultRow[3];
                        DiskUsage2I.this.fileSizes.put(fileId, new OwnershipAndSize(ownerId, groupId, fileSize));
                    }
                    break block6;
                }
                String property = this.fileProperties.get(className);
                if (property == null) break block6;
                String attribution = this.attributions.get(className);
                if (attribution == null) {
                    attribution = className;
                }
                String hql = "SELECT " + property + ".id FROM " + className + " WHERE id IN (:ids)";
                for (Object[] resultRow : this.queryService.projection(hql, parameters)) {
                    if (resultRow == null || !(resultRow[0] instanceof Long)) continue;
                    Long fileId = (Long)resultRow[0];
                    DiskUsage2I.this.typesWithFiles.put((Object)fileId, (Object)attribution);
                }
            }
        }

        @Override
        public Set<GraphPolicy.Ability> getRequiredPermissions() {
            return REQUIRED_ABILITIES;
        }
    }

    private static class OwnershipAndSize {
        public final long owner;
        public final long group;
        public final long size;

        OwnershipAndSize(long owner, long group, long size) {
            this.owner = owner;
            this.group = group;
            this.size = size;
        }
    }

    private static class Usage {
        private final Map<LongPair, Map<String, Integer>> countByTypeByWho = new HashMap<LongPair, Map<String, Integer>>();
        private final Map<LongPair, Map<String, Long>> sizeByTypeByWho = new HashMap<LongPair, Map<String, Long>>();
        private final Map<LongPair, Integer> totalCountByWho = new HashMap<LongPair, Integer>();
        private final Map<LongPair, Long> totalSizeByWho = new HashMap<LongPair, Long>();
        private boolean bumpTotals = false;

        private Usage() {
        }

        Usage bumpTotals() {
            this.bumpTotals = true;
            return this;
        }

        void add(long owner, long group, String type, Long size) {
            Map<Object, Object> sizeByType;
            Map<Object, Object> countByType;
            if (size <= 0L) {
                this.bumpTotals = false;
                return;
            }
            LongPair ownership = new LongPair(owner, group);
            if (this.countByTypeByWho.containsKey(ownership)) {
                countByType = this.countByTypeByWho.get(ownership);
                sizeByType = this.sizeByTypeByWho.get(ownership);
            } else {
                countByType = new HashMap();
                sizeByType = new HashMap();
                this.countByTypeByWho.put(ownership, countByType);
                this.sizeByTypeByWho.put(ownership, sizeByType);
            }
            Long sizeThisType = (Long)sizeByType.get(type);
            if (sizeThisType == null) {
                countByType.put(type, 1);
                sizeByType.put(type, size);
            } else {
                countByType.put(type, (Integer)countByType.get(type) + 1);
                sizeByType.put(type, sizeThisType + size);
            }
            if (this.bumpTotals) {
                Integer totalCount = this.totalCountByWho.get(ownership);
                Long totalSize = this.totalSizeByWho.get(ownership);
                if (totalCount == null) {
                    totalCount = 0;
                }
                if (totalSize == null) {
                    totalSize = 0L;
                }
                Integer n = totalCount;
                Integer n2 = totalCount = Integer.valueOf(totalCount + 1);
                totalSize = totalSize + size;
                this.totalCountByWho.put(ownership, totalCount);
                this.totalSizeByWho.put(ownership, totalSize);
                this.bumpTotals = false;
            }
        }

        public DiskUsage2Response getDiskUsageResponse() {
            return new DiskUsage2Response(this.countByTypeByWho, this.sizeByTypeByWho, this.totalCountByWho, this.totalSizeByWho);
        }

        private String toString(Map<LongPair, ?> byWho) {
            ArrayList<String> asStrings = new ArrayList<String>(byWho.size());
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<LongPair, ?> entry : byWho.entrySet()) {
                sb.setLength(0);
                sb.append(entry.getKey().first);
                sb.append('/');
                sb.append(entry.getKey().second);
                sb.append('=');
                sb.append(entry.getValue());
                asStrings.add(sb.toString());
            }
            return Joiner.on((String)", ").join(asStrings);
        }

        public String toString() {
            return "files = [" + this.toString(this.totalCountByWho) + "], bytes = [" + this.toString(this.totalSizeByWho) + "]";
        }
    }
}

