/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.FormatType;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import IceInternal.BasicStream;
import IceInternal.Ex;
import IceInternal.Incoming;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import omero.RBool;
import omero.RBoolHolder;
import omero.RInt;
import omero.RIntHolder;
import omero.RLong;
import omero.RString;
import omero.model.Details;
import omero.model.Frequency;
import omero.model.FrequencyHolder;
import omero.model.IObject;
import omero.model.Instrument;
import omero.model.LaserMedium;
import omero.model.LaserMediumHolder;
import omero.model.LaserType;
import omero.model.LaserTypeHolder;
import omero.model.Length;
import omero.model.LengthHolder;
import omero.model.LightSource;
import omero.model.LightSourceAnnotationLink;
import omero.model.LightSourceHolder;
import omero.model.Power;
import omero.model.Pulse;
import omero.model.PulseHolder;
import omero.model._LaserOperations;
import omero.model._LaserOperationsNC;

public abstract class Laser
extends LightSource
implements _LaserOperations,
_LaserOperationsNC {
    public static final String[] __ids = new String[]{"::Ice::Object", "::omero::model::IObject", "::omero::model::Laser", "::omero::model::LightSource"};
    private static final String[] __all = new String[]{"addAllLightSourceAnnotationLinkSet", "addLightSourceAnnotationLink", "addLightSourceAnnotationLinkToBoth", "clearAnnotationLinks", "copyAnnotationLinks", "findLightSourceAnnotationLink", "getAnnotationLinksCountPerOwner", "getDetails", "getFrequencyMultiplication", "getId", "getInstrument", "getLaserMedium", "getLotNumber", "getManufacturer", "getModel", "getPockelCell", "getPower", "getPulse", "getPump", "getRepetitionRate", "getSerialNumber", "getTuneable", "getType", "getVersion", "getWavelength", "ice_id", "ice_ids", "ice_isA", "ice_ping", "isAnnotated", "isGlobal", "isLink", "isLoaded", "isMutable", "linkAnnotation", "linkedAnnotationList", "proxy", "reloadAnnotationLinks", "removeAllLightSourceAnnotationLinkSet", "removeLightSourceAnnotationLink", "removeLightSourceAnnotationLinkFromBoth", "setFrequencyMultiplication", "setId", "setInstrument", "setLaserMedium", "setLotNumber", "setManufacturer", "setModel", "setPockelCell", "setPower", "setPulse", "setPump", "setRepetitionRate", "setSerialNumber", "setTuneable", "setType", "setVersion", "setWavelength", "shallowCopy", "sizeOfAnnotationLinks", "unlinkAnnotation", "unload", "unloadAnnotationLinks", "unloadCollections", "unloadDetails"};
    protected LaserType type;
    protected LaserMedium laserMedium;
    protected RInt frequencyMultiplication;
    protected RBool tuneable;
    protected Pulse pulse;
    protected Length wavelength;
    protected RBool pockelCell;
    protected LightSource pump;
    protected Frequency repetitionRate;
    public static final long serialVersionUID = 4872774753104965425L;

    public Laser() {
    }

    public Laser(RLong id, Details details, boolean loaded, RInt version, RString manufacturer, RString model, Power power, RString lotNumber, RString serialNumber, Instrument instrument, List<LightSourceAnnotationLink> annotationLinksSeq, boolean annotationLinksLoaded, Map<Long, Long> annotationLinksCountPerOwner, LaserType type, LaserMedium laserMedium, RInt frequencyMultiplication, RBool tuneable, Pulse pulse, Length wavelength, RBool pockelCell, LightSource pump, Frequency repetitionRate) {
        super(id, details, loaded, version, manufacturer, model, power, lotNumber, serialNumber, instrument, annotationLinksSeq, annotationLinksLoaded, annotationLinksCountPerOwner);
        this.type = type;
        this.laserMedium = laserMedium;
        this.frequencyMultiplication = frequencyMultiplication;
        this.tuneable = tuneable;
        this.pulse = pulse;
        this.wavelength = wavelength;
        this.pockelCell = pockelCell;
        this.pump = pump;
        this.repetitionRate = repetitionRate;
    }

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current __current) {
        return Arrays.binarySearch(__ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return __ids;
    }

    @Override
    public String[] ice_ids(Current __current) {
        return __ids;
    }

    @Override
    public String ice_id() {
        return __ids[2];
    }

    @Override
    public String ice_id(Current __current) {
        return __ids[2];
    }

    public static String ice_staticId() {
        return __ids[2];
    }

    @Override
    public final RInt getFrequencyMultiplication() {
        return this.getFrequencyMultiplication(null);
    }

    @Override
    public final LaserMedium getLaserMedium() {
        return this.getLaserMedium(null);
    }

    @Override
    public final RBool getPockelCell() {
        return this.getPockelCell(null);
    }

    @Override
    public final Pulse getPulse() {
        return this.getPulse(null);
    }

    @Override
    public final LightSource getPump() {
        return this.getPump(null);
    }

    @Override
    public final Frequency getRepetitionRate() {
        return this.getRepetitionRate(null);
    }

    @Override
    public final RBool getTuneable() {
        return this.getTuneable(null);
    }

    @Override
    public final LaserType getType() {
        return this.getType(null);
    }

    @Override
    public final Length getWavelength() {
        return this.getWavelength(null);
    }

    @Override
    public final void setFrequencyMultiplication(RInt theFrequencyMultiplication) {
        this.setFrequencyMultiplication(theFrequencyMultiplication, null);
    }

    @Override
    public final void setLaserMedium(LaserMedium theLaserMedium) {
        this.setLaserMedium(theLaserMedium, null);
    }

    @Override
    public final void setPockelCell(RBool thePockelCell) {
        this.setPockelCell(thePockelCell, null);
    }

    @Override
    public final void setPulse(Pulse thePulse) {
        this.setPulse(thePulse, null);
    }

    @Override
    public final void setPump(LightSource thePump) {
        this.setPump(thePump, null);
    }

    @Override
    public final void setRepetitionRate(Frequency theRepetitionRate) {
        this.setRepetitionRate(theRepetitionRate, null);
    }

    @Override
    public final void setTuneable(RBool theTuneable) {
        this.setTuneable(theTuneable, null);
    }

    @Override
    public final void setType(LaserType theType) {
        this.setType(theType, null);
    }

    @Override
    public final void setWavelength(Length theWavelength) {
        this.setWavelength(theWavelength, null);
    }

    public static DispatchStatus ___getType(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        LaserType __ret = __obj.getType(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setType(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        LaserTypeHolder theType = new LaserTypeHolder();
        __is.readObject((IceInternal.Patcher)theType);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setType((LaserType)theType.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getLaserMedium(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        LaserMedium __ret = __obj.getLaserMedium(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setLaserMedium(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        LaserMediumHolder theLaserMedium = new LaserMediumHolder();
        __is.readObject((IceInternal.Patcher)theLaserMedium);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setLaserMedium((LaserMedium)theLaserMedium.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getFrequencyMultiplication(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RInt __ret = __obj.getFrequencyMultiplication(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setFrequencyMultiplication(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RIntHolder theFrequencyMultiplication = new RIntHolder();
        __is.readObject((IceInternal.Patcher)theFrequencyMultiplication);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setFrequencyMultiplication((RInt)theFrequencyMultiplication.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getTuneable(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RBool __ret = __obj.getTuneable(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setTuneable(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RBoolHolder theTuneable = new RBoolHolder();
        __is.readObject((IceInternal.Patcher)theTuneable);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setTuneable((RBool)theTuneable.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getPulse(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Pulse __ret = __obj.getPulse(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setPulse(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        PulseHolder thePulse = new PulseHolder();
        __is.readObject((IceInternal.Patcher)thePulse);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setPulse((Pulse)thePulse.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getWavelength(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Length __ret = __obj.getWavelength(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setWavelength(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        LengthHolder theWavelength = new LengthHolder();
        __is.readObject((IceInternal.Patcher)theWavelength);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setWavelength((Length)theWavelength.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getPockelCell(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        RBool __ret = __obj.getPockelCell(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setPockelCell(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        RBoolHolder thePockelCell = new RBoolHolder();
        __is.readObject((IceInternal.Patcher)thePockelCell);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setPockelCell((RBool)thePockelCell.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getPump(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        LightSource __ret = __obj.getPump(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setPump(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        LightSourceHolder thePump = new LightSourceHolder();
        __is.readObject((IceInternal.Patcher)thePump);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setPump((LightSource)thePump.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getRepetitionRate(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        __inS.readEmptyParams();
        Frequency __ret = __obj.getRepetitionRate(__current);
        BasicStream __os = __inS.__startWriteParams(FormatType.DefaultFormat);
        __os.writeObject((Ice.Object)__ret);
        __os.writePendingObjects();
        __inS.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___setRepetitionRate(Laser __obj, Incoming __inS, Current __current) {
        Laser.__checkMode((OperationMode)OperationMode.Normal, (OperationMode)__current.mode);
        BasicStream __is = __inS.startReadParams();
        FrequencyHolder theRepetitionRate = new FrequencyHolder();
        __is.readObject((IceInternal.Patcher)theRepetitionRate);
        __is.readPendingObjects();
        __inS.endReadParams();
        __obj.setRepetitionRate((Frequency)theRepetitionRate.value, __current);
        __inS.__writeEmptyParams();
        return DispatchStatus.DispatchOK;
    }

    @Override
    public DispatchStatus __dispatch(Incoming in, Current __current) {
        int pos = Arrays.binarySearch(__all, __current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
        }
        switch (pos) {
            case 0: {
                return LightSource.___addAllLightSourceAnnotationLinkSet(this, in, __current);
            }
            case 1: {
                return LightSource.___addLightSourceAnnotationLink(this, in, __current);
            }
            case 2: {
                return LightSource.___addLightSourceAnnotationLinkToBoth(this, in, __current);
            }
            case 3: {
                return LightSource.___clearAnnotationLinks(this, in, __current);
            }
            case 4: {
                return LightSource.___copyAnnotationLinks(this, in, __current);
            }
            case 5: {
                return LightSource.___findLightSourceAnnotationLink(this, in, __current);
            }
            case 6: {
                return LightSource.___getAnnotationLinksCountPerOwner(this, in, __current);
            }
            case 7: {
                return IObject.___getDetails(this, in, __current);
            }
            case 8: {
                return Laser.___getFrequencyMultiplication(this, in, __current);
            }
            case 9: {
                return IObject.___getId(this, in, __current);
            }
            case 10: {
                return LightSource.___getInstrument(this, in, __current);
            }
            case 11: {
                return Laser.___getLaserMedium(this, in, __current);
            }
            case 12: {
                return LightSource.___getLotNumber(this, in, __current);
            }
            case 13: {
                return LightSource.___getManufacturer(this, in, __current);
            }
            case 14: {
                return LightSource.___getModel(this, in, __current);
            }
            case 15: {
                return Laser.___getPockelCell(this, in, __current);
            }
            case 16: {
                return LightSource.___getPower(this, in, __current);
            }
            case 17: {
                return Laser.___getPulse(this, in, __current);
            }
            case 18: {
                return Laser.___getPump(this, in, __current);
            }
            case 19: {
                return Laser.___getRepetitionRate(this, in, __current);
            }
            case 20: {
                return LightSource.___getSerialNumber(this, in, __current);
            }
            case 21: {
                return Laser.___getTuneable(this, in, __current);
            }
            case 22: {
                return Laser.___getType(this, in, __current);
            }
            case 23: {
                return LightSource.___getVersion(this, in, __current);
            }
            case 24: {
                return Laser.___getWavelength(this, in, __current);
            }
            case 25: {
                return Laser.___ice_id((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 26: {
                return Laser.___ice_ids((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 27: {
                return Laser.___ice_isA((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 28: {
                return Laser.___ice_ping((Ice.Object)this, (Incoming)in, (Current)__current);
            }
            case 29: {
                return IObject.___isAnnotated(this, in, __current);
            }
            case 30: {
                return IObject.___isGlobal(this, in, __current);
            }
            case 31: {
                return IObject.___isLink(this, in, __current);
            }
            case 32: {
                return IObject.___isLoaded(this, in, __current);
            }
            case 33: {
                return IObject.___isMutable(this, in, __current);
            }
            case 34: {
                return LightSource.___linkAnnotation(this, in, __current);
            }
            case 35: {
                return LightSource.___linkedAnnotationList(this, in, __current);
            }
            case 36: {
                return IObject.___proxy(this, in, __current);
            }
            case 37: {
                return LightSource.___reloadAnnotationLinks(this, in, __current);
            }
            case 38: {
                return LightSource.___removeAllLightSourceAnnotationLinkSet(this, in, __current);
            }
            case 39: {
                return LightSource.___removeLightSourceAnnotationLink(this, in, __current);
            }
            case 40: {
                return LightSource.___removeLightSourceAnnotationLinkFromBoth(this, in, __current);
            }
            case 41: {
                return Laser.___setFrequencyMultiplication(this, in, __current);
            }
            case 42: {
                return IObject.___setId(this, in, __current);
            }
            case 43: {
                return LightSource.___setInstrument(this, in, __current);
            }
            case 44: {
                return Laser.___setLaserMedium(this, in, __current);
            }
            case 45: {
                return LightSource.___setLotNumber(this, in, __current);
            }
            case 46: {
                return LightSource.___setManufacturer(this, in, __current);
            }
            case 47: {
                return LightSource.___setModel(this, in, __current);
            }
            case 48: {
                return Laser.___setPockelCell(this, in, __current);
            }
            case 49: {
                return LightSource.___setPower(this, in, __current);
            }
            case 50: {
                return Laser.___setPulse(this, in, __current);
            }
            case 51: {
                return Laser.___setPump(this, in, __current);
            }
            case 52: {
                return Laser.___setRepetitionRate(this, in, __current);
            }
            case 53: {
                return LightSource.___setSerialNumber(this, in, __current);
            }
            case 54: {
                return Laser.___setTuneable(this, in, __current);
            }
            case 55: {
                return Laser.___setType(this, in, __current);
            }
            case 56: {
                return LightSource.___setVersion(this, in, __current);
            }
            case 57: {
                return Laser.___setWavelength(this, in, __current);
            }
            case 58: {
                return IObject.___shallowCopy(this, in, __current);
            }
            case 59: {
                return LightSource.___sizeOfAnnotationLinks(this, in, __current);
            }
            case 60: {
                return LightSource.___unlinkAnnotation(this, in, __current);
            }
            case 61: {
                return IObject.___unload(this, in, __current);
            }
            case 62: {
                return LightSource.___unloadAnnotationLinks(this, in, __current);
            }
            case 63: {
                return IObject.___unloadCollections(this, in, __current);
            }
            case 64: {
                return IObject.___unloadDetails(this, in, __current);
            }
        }
        assert (false);
        throw new OperationNotExistException(__current.id, __current.facet, __current.operation);
    }

    @Override
    protected void __writeImpl(BasicStream __os) {
        __os.startWriteSlice(Laser.ice_staticId(), -1, false);
        __os.writeObject((Ice.Object)this.type);
        __os.writeObject((Ice.Object)this.laserMedium);
        __os.writeObject((Ice.Object)this.frequencyMultiplication);
        __os.writeObject((Ice.Object)this.tuneable);
        __os.writeObject((Ice.Object)this.pulse);
        __os.writeObject((Ice.Object)this.wavelength);
        __os.writeObject((Ice.Object)this.pockelCell);
        __os.writeObject((Ice.Object)this.pump);
        __os.writeObject((Ice.Object)this.repetitionRate);
        __os.endWriteSlice();
        super.__writeImpl(__os);
    }

    @Override
    protected void __readImpl(BasicStream __is) {
        __is.startReadSlice();
        __is.readObject((IceInternal.Patcher)new Patcher(0));
        __is.readObject((IceInternal.Patcher)new Patcher(1));
        __is.readObject((IceInternal.Patcher)new Patcher(2));
        __is.readObject((IceInternal.Patcher)new Patcher(3));
        __is.readObject((IceInternal.Patcher)new Patcher(4));
        __is.readObject((IceInternal.Patcher)new Patcher(5));
        __is.readObject((IceInternal.Patcher)new Patcher(6));
        __is.readObject((IceInternal.Patcher)new Patcher(7));
        __is.readObject((IceInternal.Patcher)new Patcher(8));
        __is.endReadSlice();
        super.__readImpl(__is);
    }

    @Override
    public Laser clone() {
        return (Laser)super.clone();
    }

    private class Patcher
    implements IceInternal.Patcher {
        private int __member;
        private String __typeId;

        Patcher(int member) {
            this.__member = member;
        }

        public void patch(Ice.Object v) {
            switch (this.__member) {
                case 0: {
                    this.__typeId = "::omero::model::LaserType";
                    if (v == null || v instanceof LaserType) {
                        Laser.this.type = (LaserType)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 1: {
                    this.__typeId = "::omero::model::LaserMedium";
                    if (v == null || v instanceof LaserMedium) {
                        Laser.this.laserMedium = (LaserMedium)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 2: {
                    this.__typeId = "::omero::RInt";
                    if (v == null || v instanceof RInt) {
                        Laser.this.frequencyMultiplication = (RInt)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 3: {
                    this.__typeId = "::omero::RBool";
                    if (v == null || v instanceof RBool) {
                        Laser.this.tuneable = (RBool)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 4: {
                    this.__typeId = "::omero::model::Pulse";
                    if (v == null || v instanceof Pulse) {
                        Laser.this.pulse = (Pulse)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 5: {
                    this.__typeId = "::omero::model::Length";
                    if (v == null || v instanceof Length) {
                        Laser.this.wavelength = (Length)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 6: {
                    this.__typeId = "::omero::RBool";
                    if (v == null || v instanceof RBool) {
                        Laser.this.pockelCell = (RBool)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 7: {
                    this.__typeId = "::omero::model::LightSource";
                    if (v == null || v instanceof LightSource) {
                        Laser.this.pump = (LightSource)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                    break;
                }
                case 8: {
                    this.__typeId = "::omero::model::Frequency";
                    if (v == null || v instanceof Frequency) {
                        Laser.this.repetitionRate = (Frequency)v;
                        break;
                    }
                    Ex.throwUOE((String)this.type(), (Ice.Object)v);
                }
            }
        }

        public String type() {
            return this.__typeId;
        }
    }
}

