/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ome.conditions.ValidationException;
import ome.security.auth.AttributeSet;
import ome.security.auth.GroupAttributeMapper;
import ome.security.auth.LdapConfig;
import ome.security.auth.NewUserGroupBean;
import ome.security.auth.RoleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapOperations;

public class AttributeNewUserGroupBean
implements NewUserGroupBean {
    private static final Logger log = LoggerFactory.getLogger(AttributeNewUserGroupBean.class);
    private final String grpAttribute;
    private final boolean filtered;
    private final boolean dn;

    public AttributeNewUserGroupBean(String grpAttribute, boolean filtered, boolean dn) {
        this.grpAttribute = grpAttribute;
        this.filtered = filtered;
        this.dn = dn;
    }

    @Override
    public List<Long> groups(String username, LdapConfig config, LdapOperations ldap, RoleProvider provider, AttributeSet attrSet) {
        Set<String> groupNames = attrSet.getAll(this.grpAttribute);
        if (groupNames == null) {
            throw new ValidationException(username + " has no attributes " + this.grpAttribute);
        }
        GroupAttributeMapper mapper = new GroupAttributeMapper(config);
        List filteredNames = null;
        if (this.filtered) {
            String filter = config.getGroupFilter().encode();
            filteredNames = ldap.search("", filter, (AttributesMapper)mapper);
        }
        ArrayList<Long> groups = new ArrayList<Long>();
        for (String grpName : groupNames) {
            if (this.dn) {
                DistinguishedName relative = config.relativeDN(grpName);
                String nameAttr = config.getGroupAttribute("name");
                grpName = relative.getValue(nameAttr);
            }
            if (this.filtered && !filteredNames.contains(grpName)) {
                log.debug("Group not found by filter: " + grpName);
                continue;
            }
            groups.add(provider.createGroup(grpName, null, false, true));
        }
        return groups;
    }
}

