/*
 * Decompiled with CFR 0.152.
 */
package ome.services;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import ome.annotations.RolesAllowed;
import ome.api.IPixels;
import ome.api.IRenderingSettings;
import ome.api.IRepositoryInfo;
import ome.api.IScale;
import ome.api.ServiceInterface;
import ome.api.ThumbnailStore;
import ome.api.local.LocalCompress;
import ome.conditions.ApiUsageException;
import ome.conditions.ConcurrencyException;
import ome.conditions.InternalException;
import ome.conditions.ReadOnlyGroupSecurityViolation;
import ome.conditions.ResourceError;
import ome.conditions.ValidationException;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import ome.io.nio.ThumbnailService;
import ome.logic.AbstractLevel2Service;
import ome.model.IObject;
import ome.model.core.Pixels;
import ome.model.display.RenderingDef;
import ome.model.display.Thumbnail;
import ome.model.enums.Family;
import ome.model.enums.RenderingModel;
import ome.parameters.Parameters;
import ome.services.PerGroupActor;
import ome.services.SVGRasterizer;
import ome.services.ThumbnailCtx;
import ome.services.messages.ContextMessage;
import ome.system.EventContext;
import ome.system.OmeroContext;
import ome.system.SimpleEventContext;
import ome.util.ImageUtil;
import ome.util.messages.InternalMessage;
import omeis.providers.re.Renderer;
import omeis.providers.re.data.PlaneDef;
import omeis.providers.re.lut.LutProvider;
import omeis.providers.re.quantum.QuantizationException;
import omeis.providers.re.quantum.QuantumFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ThumbnailBean
extends AbstractLevel2Service
implements ApplicationContextAware,
ThumbnailStore,
Serializable {
    private static final long serialVersionUID = 3047482880497900069L;
    private static final Integer PROGRESS_VERSION = -1;
    private static transient Logger log = LoggerFactory.getLogger(ThumbnailBean.class);
    private transient Renderer renderer;
    private transient IScale iScale;
    private transient IPixels iPixels;
    private transient PixelsService pixelDataService;
    private transient ThumbnailService ioService;
    private transient IRepositoryInfo iRepositoryInfo;
    private transient LocalCompress compressionService;
    private transient IRenderingSettings settingsService;
    private transient List<Family> families;
    private transient List<RenderingModel> renderingModels;
    private transient boolean diskSpaceChecking;
    private Boolean dirty = true;
    private Boolean dirtyMetadata = false;
    private Pixels pixels;
    private Long pixelsId;
    private boolean inProgress;
    private RenderingDef settings;
    private Thumbnail thumbnailMetadata;
    private ThumbnailCtx ctx;
    private Resource inProgressImageResource;
    public static final int DEFAULT_X_WIDTH = 48;
    public static final int DEFAULT_Y_WIDTH = 48;
    public static final float DEFAULT_COMPRESSION_QUALITY = 0.85f;
    public static final String DEFAULT_MIME_TYPE = "image/jpeg";
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private transient boolean wasPassivated = false;
    private LutProvider lutProvider;
    private OmeroContext applicationContext = null;

    public ThumbnailBean(boolean checking) {
        this.diskSpaceChecking = checking;
    }

    public Class<? extends ServiceInterface> getServiceInterface() {
        return ThumbnailStore.class;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = (OmeroContext)applicationContext;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public void passivate() {
        log.debug("***** Passivating... ******");
        this.rwl.writeLock().lock();
        try {
            if (this.renderer != null) {
                this.renderer.close();
            }
            this.renderer = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=true)
    public void activate() {
        log.debug("***** Returning from passivation... ******");
        this.rwl.writeLock().lock();
        try {
            this.wasPassivated = true;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public void close() {
        this.rwl.writeLock().lock();
        log.debug("Closing thumbnail bean");
        try {
            if (this.renderer != null) {
                this.renderer.close();
            }
            this.ctx = null;
            this.settings = null;
            this.pixels = null;
            this.thumbnailMetadata = null;
            this.renderer = null;
            this.iScale = null;
            this.ioService = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @RolesAllowed(value={"user"})
    public long getRenderingDefId() {
        if (this.settings == null || this.settings.getId() == null) {
            throw new ApiUsageException("No rendering def");
        }
        return this.settings.getId();
    }

    public EventContext getCurrentEventContext() {
        return new SimpleEventContext(this.getSecuritySystem().getEventContext());
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public boolean setPixelsId(long id) {
        if (this.pixels != null && this.pixels.getId() != id || this.pixels == null) {
            this.newContext();
        }
        HashSet<Long> pixelsIds = new HashSet<Long>();
        pixelsIds.add(id);
        this.ctx.loadAndPrepareRenderingSettings(pixelsIds);
        this.pixels = this.ctx.getPixels(id);
        this.pixelsId = this.pixels.getId();
        this.settings = this.ctx.getSettings(id);
        return this.ctx.hasSettings(id);
    }

    @RolesAllowed(value={"user"})
    public boolean isInProgress() {
        return this.inProgress;
    }

    private List<Family> getFamilies() {
        if (this.families == null) {
            this.families = this.iPixels.getAllEnumerations(Family.class);
        }
        return this.families;
    }

    private List<RenderingModel> getRenderingModels() {
        if (this.renderingModels == null) {
            this.renderingModels = this.iPixels.getAllEnumerations(RenderingModel.class);
        }
        return this.renderingModels;
    }

    private void load() {
        if (this.renderer != null) {
            this.renderer.close();
        }
        this.pixels = this.iPixels.retrievePixDescription(this.pixels.getId().longValue());
        this.settings = this.iPixels.loadRndSettings(this.settings.getId().longValue());
        List<Family> families = this.getFamilies();
        List<RenderingModel> renderingModels = this.getRenderingModels();
        QuantumFactory quantumFactory = new QuantumFactory(families);
        PixelBuffer buffer = this.pixelDataService.getPixelBuffer(this.pixels, false);
        this.renderer = new Renderer(quantumFactory, renderingModels, this.pixels, this.settings, buffer, this.lutProvider);
        this.dirty = false;
    }

    @RolesAllowed(value={"user"})
    public void setRenderingDefId(long id) {
        this.errorIfNullPixels();
        this.ctx.loadAndPrepareRenderingSettings(this.pixelsId, id);
        this.settings = this.ctx.getSettings(this.pixelsId);
        this.ctx.setUserId(this.settings.getDetails().getOwner().getId());
    }

    public void setLutProvider(LutProvider lutProvider) {
        this.getBeanHelper().throwIfAlreadySet(this.lutProvider, lutProvider);
        this.lutProvider = lutProvider;
    }

    public void setInProgressImageResource(Resource inProgressImageResource) {
        this.getBeanHelper().throwIfAlreadySet(this.inProgressImageResource, inProgressImageResource);
        this.inProgressImageResource = inProgressImageResource;
    }

    public void setPixelDataService(PixelsService pixelDataService) {
        this.getBeanHelper().throwIfAlreadySet(this.pixelDataService, pixelDataService);
        this.pixelDataService = pixelDataService;
    }

    public void setIPixels(IPixels iPixels) {
        this.getBeanHelper().throwIfAlreadySet(this.iPixels, iPixels);
        this.iPixels = iPixels;
    }

    public void setScaleService(IScale iScale) {
        this.getBeanHelper().throwIfAlreadySet(this.iScale, iScale);
        this.iScale = iScale;
    }

    public void setIoService(ThumbnailService ioService) {
        this.getBeanHelper().throwIfAlreadySet(this.ioService, ioService);
        this.ioService = ioService;
    }

    public final void setIRepositoryInfo(IRepositoryInfo iRepositoryInfo) {
        this.getBeanHelper().throwIfAlreadySet(this.iRepositoryInfo, iRepositoryInfo);
        this.iRepositoryInfo = iRepositoryInfo;
    }

    public void setCompressionService(LocalCompress compressionService) {
        this.getBeanHelper().throwIfAlreadySet(this.compressionService, compressionService);
        this.compressionService = compressionService;
    }

    public void setSettingsService(IRenderingSettings settingsService) {
        this.getBeanHelper().throwIfAlreadySet(this.settingsService, settingsService);
        this.settingsService = settingsService;
    }

    private void compressThumbnailToDisk(Thumbnail metadata, BufferedImage image, boolean inProgress) throws IOException, ResourceError {
        if (this.diskSpaceChecking) {
            this.iRepositoryInfo.sanityCheckRepository();
        }
        try (FileOutputStream stream = this.ioService.getThumbnailOutputStream(metadata);){
            if (inProgress) {
                this.compressInProgressImageToStream(metadata.getSizeX(), metadata.getSizeY(), stream, this.inProgressImageResource);
            } else {
                this.compressionService.compressToStream(image, stream);
            }
        }
    }

    private byte[] convertThumbnailToBytes(BufferedImage image, boolean inProgress) throws IOException {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            if (inProgress) {
                this.compressInProgressImageToStream(image.getWidth(), image.getHeight(), byteStream, this.inProgressImageResource);
            } else {
                this.compressionService.compressToStream(image, byteStream);
            }
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
    }

    private void compressInProgressImageToStream(int width, int height, OutputStream outputStream, Resource inProgressImageResource) throws ResourceError {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero.transcodeSVG");
        try {
            SVGRasterizer rasterizer = new SVGRasterizer(inProgressImageResource.getInputStream());
            if (width > height) {
                rasterizer.setImageWidth(width);
            } else {
                rasterizer.setImageHeight(height);
            }
            rasterizer.setQuality(this.compressionService.getCompressionLevel());
            rasterizer.createJPEG(outputStream);
            s1.stop();
        }
        catch (IOException e1) {
            String s = "Error loading in-progress image from Spring resource.";
            log.error(s, (Throwable)e1);
            throw new ResourceError(s);
        }
        catch (TranscoderException e2) {
            String s = "Error transcoding in progress SVG.";
            log.error(s, (Throwable)e2);
            throw new ResourceError(s);
        }
    }

    private Dimension sanityCheckThumbnailSizes(Integer sizeX, Integer sizeY) {
        if (sizeX == null) {
            sizeX = 48;
        }
        if (sizeX < 0) {
            throw new ApiUsageException("sizeX is negative");
        }
        if (sizeY == null) {
            sizeY = 48;
        }
        if (sizeY < 0) {
            throw new ApiUsageException("sizeY is negative");
        }
        return new Dimension(sizeX, sizeY);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BufferedImage createScaledImage(Integer theZ, Integer theT) {
        BufferedImage bufferedImage;
        this.errorIfInvalidState();
        if (this.inProgress) {
            return null;
        }
        if (theZ == null) {
            theZ = this.settings.getDefaultZ();
        }
        if (theT == null) {
            theT = this.settings.getDefaultT();
        }
        PlaneDef pd = new PlaneDef(0, theT.intValue());
        pd.setZ(theZ.intValue());
        PixelBuffer pixelBuffer = this.renderer.getPixels();
        int originalSizeX = this.pixels.getSizeX();
        int originalSizeY = this.pixels.getSizeY();
        int pixelBufferSizeX = pixelBuffer.getSizeX();
        int pixelBufferSizeY = pixelBuffer.getSizeY();
        if (pixelBuffer.getResolutionLevels() > 1) {
            int resolutionLevel = pixelBuffer.getResolutionLevels();
            while (resolutionLevel > 0) {
                this.renderer.setResolutionLevel(--resolutionLevel);
                pixelBufferSizeX = pixelBuffer.getSizeX();
                pixelBufferSizeY = pixelBuffer.getSizeY();
                if (pixelBufferSizeX > this.thumbnailMetadata.getSizeX() && pixelBufferSizeY > this.thumbnailMetadata.getSizeY()) continue;
            }
            log.debug(String.format("Using resolution level %d -- %dx%d", resolutionLevel, pixelBufferSizeX, pixelBufferSizeY));
            this.renderer.setResolutionLevel(resolutionLevel);
        }
        Pixels rendererPixels = this.renderer.getMetadata();
        try {
            log.debug(String.format("Setting renderer Pixel sizeX:%d sizeY:%d", pixelBufferSizeX, pixelBufferSizeY));
            rendererPixels.setSizeX(Integer.valueOf(pixelBufferSizeX));
            rendererPixels.setSizeY(Integer.valueOf(pixelBufferSizeY));
            int[] buf = this.renderer.renderAsPackedInt(pd, null);
            BufferedImage image = ImageUtil.createBufferedImage((int[])buf, (int)pixelBufferSizeX, (int)pixelBufferSizeY);
            float xScale = (float)this.thumbnailMetadata.getSizeX().intValue() / (float)pixelBufferSizeX;
            float yScale = (float)this.thumbnailMetadata.getSizeY().intValue() / (float)pixelBufferSizeY;
            log.debug(String.format("Using scaling factors x:%f y:%f", Float.valueOf(xScale), Float.valueOf(yScale)));
            bufferedImage = this.iScale.scaleBufferedImage(image, xScale, yScale);
        }
        catch (IOException e) {
            try {
                ResourceError re = new ResourceError("IO error while rendering: " + e.getMessage());
                re.initCause((Throwable)e);
                throw re;
                catch (QuantizationException e2) {
                    InternalException ie = new InternalException("QuantizationException while rendering: " + e2.getMessage());
                    ie.initCause((Throwable)e2);
                    throw ie;
                }
            }
            catch (Throwable throwable) {
                log.debug(String.format("Setting original renderer Pixel sizeX:%d sizeY:%d", originalSizeX, originalSizeY));
                rendererPixels.setSizeX(Integer.valueOf(originalSizeX));
                rendererPixels.setSizeY(Integer.valueOf(originalSizeY));
                throw throwable;
            }
        }
        log.debug(String.format("Setting original renderer Pixel sizeX:%d sizeY:%d", originalSizeX, originalSizeY));
        rendererPixels.setSizeX(Integer.valueOf(originalSizeX));
        rendererPixels.setSizeY(Integer.valueOf(originalSizeY));
        return bufferedImage;
    }

    private void newContext() {
        this.resetMetadata();
        this.ctx = new ThumbnailCtx(this.iQuery, this.iUpdate, this.iPixels, this.settingsService, this.ioService, this.applicationContext, this.sec, this.sec.getEffectiveUID());
    }

    private void resetMetadata() {
        this.inProgress = false;
        this.pixels = null;
        this.pixelsId = null;
        this.settings = null;
        this.dirty = true;
        this.dirtyMetadata = false;
        this.thumbnailMetadata = null;
        if (this.renderer != null) {
            this.renderer.close();
        }
        this.renderer = null;
    }

    protected void errorIfInvalidState() {
        this.errorIfNullPixelsAndRenderingDef();
        if (this.inProgress) {
            return;
        }
        if (this.renderer == null && this.wasPassivated || this.dirty.booleanValue()) {
            try {
                this.load();
            }
            catch (ConcurrencyException e) {
                this.inProgress = true;
                log.info("ConcurrencyException on load()");
            }
        } else if (this.renderer == null) {
            throw new InternalException("Thumbnail service state corruption: Renderer missing.");
        }
    }

    protected void errorIfNullPixelsAndRenderingDef() {
        this.errorIfNullPixels();
        this.errorIfNullRenderingDef();
    }

    protected void errorIfNullPixels() {
        if (this.pixels == null) {
            throw new ApiUsageException("Thumbnail service not ready: Pixels not set.");
        }
    }

    protected void errorIfNullRenderingDef() {
        this.errorIfNullPixels();
        if (!this.inProgress) {
            if (this.settings == null && this.ctx.isExtendedGraphCritical(Collections.singleton(this.pixelsId))) {
                long ownerId = this.pixels.getDetails().getOwner().getId();
                throw new ResourceError(String.format("The owner id:%d has not viewed the Pixels set id:%d, rendering settings are missing.", ownerId, this.pixelsId));
            }
            if (this.settings == null) {
                throw new InternalException("Fatal error retrieving rendering settings or settings not loaded for Pixels set id:" + this.pixelsId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void createThumbnail(Integer sizeX, Integer sizeY) {
        if (this.inProgress) {
            return;
        }
        try {
            if (sizeX == null) {
                sizeX = 48;
            }
            if (sizeY == null) {
                sizeY = 48;
            }
            Dimension dimensions = this.sanityCheckThumbnailSizes(sizeX, sizeY);
            HashSet<Long> pixelsIds = new HashSet<Long>();
            pixelsIds.add(this.pixelsId);
            this.ctx.loadAndPrepareMetadata(pixelsIds, dimensions);
            try {
                this.thumbnailMetadata = this.ctx.getMetadata(this.pixels.getId());
            }
            catch (ThumbnailCtx.NoThumbnail e) {
                throw new ValidationException(e.getMessage());
            }
            this.thumbnailMetadata = this._createThumbnail();
            if (this.dirtyMetadata.booleanValue()) {
                this.thumbnailMetadata = (Thumbnail)this.iUpdate.saveAndReturnObject((IObject)this.thumbnailMetadata);
            }
            this.iQuery.clear();
        }
        finally {
            this.dirtyMetadata = false;
        }
    }

    private Thumbnail _createThumbnail() throws ResourceError {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero._createThumbnail");
        this.thumbnailMetadata = this._createThumbnail(this.thumbnailMetadata);
        BufferedImage image = this.createScaledImage(null, null);
        try {
            this.compressThumbnailToDisk(this.thumbnailMetadata, image, this.inProgress);
            Thumbnail thumbnail = this.thumbnailMetadata;
            return thumbnail;
        }
        catch (IOException e) {
            log.error("Thumbnail could not be compressed.", (Throwable)e);
            throw new ResourceError(e.getMessage());
        }
        finally {
            s1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thumbnail _createThumbnail(Thumbnail thumbMetaData) {
        Slf4JStopWatch s1 = new Slf4JStopWatch("omero._createThumbnail(thumbMetaData)");
        try {
            if (thumbMetaData == null) {
                throw new ValidationException("Missing thumbnail metadata.");
            }
            if (this.ctx.dirtyMetadata(this.pixels.getId()) && thumbMetaData.getDetails().getOwner() != null) {
                Long ownerId = thumbMetaData.getDetails().getOwner().getId();
                Long rndOwnerId = this.settings.getDetails().getOwner().getId();
                Long rndGroupId = this.settings.getDetails().getGroup().getId();
                HashMap<String, String> groupContext = new HashMap<String, String>();
                groupContext.put("omero.group", Long.toString(rndGroupId));
                try {
                    try {
                        this.applicationContext.publishMessage((InternalMessage)new ContextMessage.Push(this, groupContext));
                    }
                    catch (Throwable t) {
                        String errorMessage = "could not publish context change push";
                        log.error("could not publish context change push", t);
                        throw new InternalException("could not publish context change push: " + t);
                    }
                    if (rndOwnerId.equals(ownerId)) {
                        Pixels unloadedPixels = new Pixels(this.pixels.getId(), false);
                        thumbMetaData.setPixels(unloadedPixels);
                        ThumbnailBean._setMetadataVersion(thumbMetaData, this.inProgress);
                        this.dirtyMetadata = true;
                    } else {
                        Dimension d = new Dimension(thumbMetaData.getSizeX(), thumbMetaData.getSizeY());
                        thumbMetaData = this.ctx.createThumbnailMetadata(this.pixels, d);
                        ThumbnailBean._setMetadataVersion(thumbMetaData, this.inProgress);
                        thumbMetaData = (Thumbnail)this.iUpdate.saveAndReturnObject((IObject)thumbMetaData);
                        this.dirtyMetadata = false;
                    }
                }
                finally {
                    try {
                        this.applicationContext.publishMessage((InternalMessage)new ContextMessage.Pop(this, groupContext));
                    }
                    catch (Throwable t) {
                        String errorMessage = "could not publish context change pop";
                        log.error("could not publish context change pop", t);
                        throw new InternalException("could not publish context change pop: " + t);
                    }
                }
            }
            Thumbnail thumbnail = thumbMetaData;
            return thumbnail;
        }
        finally {
            s1.stop();
        }
    }

    private static void _setMetadataVersion(Thumbnail tb, boolean inProgress) {
        Integer version = tb.getVersion();
        if (version == null) {
            version = inProgress ? PROGRESS_VERSION : 0;
        } else {
            Integer n = version;
            Integer n2 = version = Integer.valueOf(version + 1);
        }
        tb.setVersion(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void createThumbnails() {
        try {
            List<Thumbnail> thumbnails = this.ctx.loadAllMetadata(this.pixelsId);
            Iterator<Thumbnail> iterator = thumbnails.iterator();
            while (iterator.hasNext()) {
                Thumbnail thumbnail;
                this.thumbnailMetadata = thumbnail = iterator.next();
                this._createThumbnail();
            }
            this.iUpdate.saveArray((IObject[])thumbnails.toArray(new Thumbnail[thumbnails.size()]));
            this.iQuery.clear();
        }
        finally {
            this.dirtyMetadata = false;
        }
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void createThumbnailsByLongestSideSet(Integer size, Set<Long> pixelsIds) {
        this.getThumbnailByLongestSideSet(size, pixelsIds);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public Map<Long, byte[]> getThumbnailSet(Integer sizeX, Integer sizeY, Set<Long> pixelsIds) {
        Dimension checkedDimensions = this.sanityCheckThumbnailSizes(sizeX, sizeY);
        this.newContext();
        this.ctx.loadAndPrepareRenderingSettings(pixelsIds);
        this.ctx.createAndPrepareMissingRenderingSettings(pixelsIds);
        this.ctx.loadAndPrepareMetadata(pixelsIds, checkedDimensions);
        Map<Long, byte[]> values = this.retrieveThumbnailSet(pixelsIds);
        this.iQuery.clear();
        return values;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public Map<Long, byte[]> getThumbnailByLongestSideSet(Integer size, Set<Long> pixelsIds) {
        Dimension checkedDimensions = this.sanityCheckThumbnailSizes(size, size);
        size = (int)checkedDimensions.getWidth();
        this.newContext();
        this.ctx.loadAndPrepareRenderingSettings(pixelsIds);
        this.ctx.createAndPrepareMissingRenderingSettings(pixelsIds);
        this.ctx.loadAndPrepareMetadata(pixelsIds, size);
        Map<Long, byte[]> values = this.retrieveThumbnailSet(pixelsIds);
        this.iQuery.clear();
        return values;
    }

    private Map<Long, byte[]> retrieveThumbnailSet(Set<Long> pixelsIds) {
        final HashMap<Long, byte[]> toReturn = new HashMap<Long, byte[]>();
        new PerGroupActor(this.applicationContext, this.iQuery, null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void actOnOneGroup(Set<Long> pixelsIds) {
                ArrayList<Thumbnail> toSave = new ArrayList<Thumbnail>();
                for (Long pixelsId : pixelsIds) {
                    ThumbnailBean.this.resetMetadata();
                    try {
                        if (!ThumbnailBean.this.ctx.hasSettings(pixelsId)) {
                            try {
                                ThumbnailBean.this.pixelDataService.getPixelBuffer(ThumbnailBean.this.ctx.getPixels(pixelsId), false);
                                continue;
                            }
                            catch (ConcurrencyException e) {
                                log.debug("ConcurrencyException on retrieveThumbnailSet.ctx.hasSettings: pyramid in progress");
                                ThumbnailBean.this.inProgress = true;
                            }
                        }
                        ThumbnailBean.this.pixels = ThumbnailBean.this.ctx.getPixels(pixelsId);
                        ThumbnailBean.this.settings = ThumbnailBean.this.ctx.getSettings(pixelsId);
                        ThumbnailBean.this.thumbnailMetadata = ThumbnailBean.this.ctx.getMetadata(pixelsId);
                        if (ThumbnailBean.this.inProgress && !PROGRESS_VERSION.equals(ThumbnailBean.this.thumbnailMetadata.getVersion())) {
                            ThumbnailBean.this.thumbnailMetadata.setVersion(PROGRESS_VERSION);
                            ThumbnailBean.this.dirtyMetadata = true;
                        }
                        try {
                            byte[] thumbnail = ThumbnailBean.this.retrieveThumbnailAndUpdateMetadata(false);
                            toReturn.put(pixelsId, thumbnail);
                            if (!ThumbnailBean.this.dirtyMetadata.booleanValue()) continue;
                            toSave.add(ThumbnailBean.this.thumbnailMetadata);
                        }
                        finally {
                            ThumbnailBean.this.dirtyMetadata = false;
                        }
                    }
                    catch (Throwable t) {
                        log.warn("Retrieving thumbnail in set for Pixels ID " + pixelsId + " failed.", t);
                        toReturn.put(pixelsId, null);
                    }
                }
                ThumbnailBean.this.iUpdate.saveArray((IObject[])toSave.toArray(new Thumbnail[toSave.size()]));
                ThumbnailBean.this.iQuery.clear();
                ThumbnailBean.this.iUpdate.flush();
            }
        }.actOnByGroup(pixelsIds);
        return toReturn;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public byte[] getThumbnail(Integer sizeX, Integer sizeY) {
        this.errorIfNullPixelsAndRenderingDef();
        Dimension dimensions = this.sanityCheckThumbnailSizes(sizeX, sizeY);
        HashSet<Long> pixelsIds = new HashSet<Long>();
        pixelsIds.add(this.pixelsId);
        byte[] value = null;
        try {
            this.ctx.loadAndPrepareMetadata(pixelsIds, dimensions);
            this.thumbnailMetadata = this.ctx.getMetadata(this.pixelsId);
            value = this.retrieveThumbnailAndUpdateMetadata(false);
        }
        catch (Throwable t) {
            value = this.handleNoThumbnail(t, dimensions);
        }
        this.iQuery.clear();
        return value;
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public byte[] getThumbnailWithoutDefault(Integer sizeX, Integer sizeY) {
        this.errorIfNullPixelsAndRenderingDef();
        Dimension dimensions = this.sanityCheckThumbnailSizes(sizeX, sizeY);
        Set<Long> pixelsIds = Collections.singleton(this.pixelsId);
        this.ctx.loadAndPrepareMetadata(pixelsIds, dimensions);
        this.thumbnailMetadata = this.ctx.getMetadataSimple(this.pixelsId);
        if (this.thumbnailMetadata == null) {
            this.thumbnailMetadata = this.ctx.createThumbnailMetadata(this.pixels, dimensions);
        }
        byte[] value = this.retrieveThumbnail(this.thumbnailMetadata);
        this.iQuery.clear();
        return value;
    }

    private byte[] retrieveThumbnailAndUpdateMetadata(boolean rewriteMetadata) {
        byte[] thumbnail = this.retrieveThumbnail(rewriteMetadata);
        if (this.inProgress && !PROGRESS_VERSION.equals(this.thumbnailMetadata.getVersion())) {
            this.thumbnailMetadata.setVersion(PROGRESS_VERSION);
            this.dirtyMetadata = true;
        }
        if (this.dirtyMetadata.booleanValue()) {
            try {
                this.iUpdate.saveObject((IObject)this.thumbnailMetadata);
            }
            finally {
                this.dirtyMetadata = false;
            }
        }
        return thumbnail;
    }

    private byte[] retrieveThumbnail(boolean rewriteMetadata) {
        if (this.inProgress) {
            return this.retrieveThumbnailDirect(this.thumbnailMetadata.getSizeX(), this.thumbnailMetadata.getSizeY(), 0, 0, rewriteMetadata);
        }
        try {
            boolean cached = this.ctx.isThumbnailCached(this.pixels.getId());
            if (cached) {
                if (log.isDebugEnabled()) {
                    log.debug("Cache hit.");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Cache miss, thumbnail missing or out of date.");
                }
                this._createThumbnail();
            }
            byte[] thumbnail = this.ioService.getThumbnail(this.thumbnailMetadata);
            if (this.inProgress) {
                this.ioService.removeThumbnails(Arrays.asList(this.thumbnailMetadata.getId()));
            }
            return thumbnail;
        }
        catch (IOException e) {
            log.error("Could not obtain thumbnail", (Throwable)e);
            throw new ResourceError(e.getMessage());
        }
    }

    private byte[] retrieveThumbnail(Thumbnail thumbMetaData) throws ResourceError {
        long pixelsId = thumbMetaData.getPixels().getId();
        try {
            if (this.ctx.isThumbnailCached(pixelsId)) {
                try {
                    return this.ioService.getThumbnail(thumbMetaData);
                }
                catch (IOException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Cache miss, thumbnail missing or out of date.");
                    }
                }
            }
        }
        catch (ResourceError e) {
            try {
                BufferedImage image = this.createScaledImage(null, null);
                if (image == null) {
                    return new byte[0];
                }
                return this.convertThumbnailToBytes(image, false);
            }
            catch (IOException e1) {
                throw new ResourceError(e1.getMessage());
            }
        }
        this.thumbnailMetadata = this._createThumbnail(thumbMetaData);
        BufferedImage image = this.createScaledImage(null, null);
        if (image == null) {
            return new byte[0];
        }
        if (this.thumbnailMetadata.getId() == null) {
            try {
                return this.convertThumbnailToBytes(image, false);
            }
            catch (IOException e) {
                throw new ResourceError(e.getMessage());
            }
        }
        try {
            this.compressThumbnailToDisk(this.thumbnailMetadata, image, false);
            if (this.thumbnailMetadata.getDetails().getOwner().getId().equals(this.settings.getDetails().getOwner().getId())) {
                this.iUpdate.saveObject((IObject)this.thumbnailMetadata);
            }
        }
        catch (IOException | ReadOnlyGroupSecurityViolation e) {
            String msg = "Thumbnail could not be written to disk. Returning without caching";
            log.warn(msg, e);
            try {
                return this.convertThumbnailToBytes(image, false);
            }
            catch (IOException e1) {
                throw new ResourceError(e1.getMessage());
            }
        }
        try {
            return this.ioService.getThumbnail(this.thumbnailMetadata);
        }
        catch (IOException e) {
            log.error("Could not obtain thumbnail", (Throwable)e);
            throw new ResourceError(e.getMessage());
        }
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public byte[] getThumbnailByLongestSide(Integer size) {
        this.errorIfNullPixelsAndRenderingDef();
        Dimension dimensions = this.sanityCheckThumbnailSizes(size, size);
        size = (int)dimensions.getWidth();
        HashSet<Long> pixelsIds = new HashSet<Long>();
        pixelsIds.add(this.pixelsId);
        byte[] value = null;
        try {
            this.ctx.loadAndPrepareMetadata(pixelsIds, size);
            this.thumbnailMetadata = this.ctx.getMetadata(this.pixelsId);
            value = this.retrieveThumbnailAndUpdateMetadata(false);
        }
        catch (Throwable t) {
            value = this.handleNoThumbnail(t, dimensions);
        }
        this.iQuery.clear();
        return value;
    }

    @RolesAllowed(value={"user"})
    public byte[] getThumbnailDirect(Integer sizeX, Integer sizeY) {
        byte[] value = this.retrieveThumbnailDirect(sizeX, sizeY, null, null, true);
        this.iQuery.clear();
        return value;
    }

    private byte[] retrieveThumbnailDirect(Integer sizeX, Integer sizeY, Integer theZ, Integer theT, boolean rewriteMetadata) {
        BufferedImage image;
        this.errorIfNullPixelsAndRenderingDef();
        Dimension dimensions = this.sanityCheckThumbnailSizes(sizeX, sizeY);
        Thumbnail local = this.ctx.createThumbnailMetadata(this.pixels, dimensions);
        if (rewriteMetadata) {
            this.thumbnailMetadata = local;
        }
        if ((image = this.createScaledImage(theZ, theT)) == null) {
            image = new BufferedImage(local.getSizeX(), local.getSizeY(), 1);
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            byte[] byArray = this.convertThumbnailToBytes(image, this.inProgress);
            return byArray;
        }
        catch (IOException e) {
            log.error("Could not obtain thumbnail direct.", (Throwable)e);
            throw new ResourceError(e.getMessage());
        }
        finally {
            try {
                byteStream.close();
            }
            catch (IOException e) {
                log.error("Could not close byte stream.", (Throwable)e);
                throw new ResourceError(e.getMessage());
            }
        }
    }

    @RolesAllowed(value={"user"})
    public byte[] getThumbnailForSectionDirect(int theZ, int theT, Integer sizeX, Integer sizeY) {
        byte[] value = this.retrieveThumbnailDirect(sizeX, sizeY, theZ, theT, true);
        this.iQuery.clear();
        return value;
    }

    private byte[] _getThumbnailByLongestSideDirect(Integer size, Integer theZ, Integer theT, boolean rewriteMetadata) {
        Dimension dimensions = this.sanityCheckThumbnailSizes(size, size);
        dimensions = this.ctx.calculateXYWidths(this.pixels, (int)dimensions.getWidth());
        byte[] value = this.retrieveThumbnailDirect((int)dimensions.getWidth(), (int)dimensions.getHeight(), theZ, theT, rewriteMetadata);
        this.iQuery.clear();
        return value;
    }

    @RolesAllowed(value={"user"})
    public byte[] getThumbnailByLongestSideDirect(Integer size) {
        this.errorIfNullPixelsAndRenderingDef();
        byte[] value = this._getThumbnailByLongestSideDirect(size, null, null, true);
        this.iQuery.clear();
        return value;
    }

    @RolesAllowed(value={"user"})
    public byte[] getThumbnailForSectionByLongestSideDirect(int theZ, int theT, Integer size) {
        this.errorIfNullPixelsAndRenderingDef();
        this.iQuery.clear();
        byte[] value = this._getThumbnailByLongestSideDirect(size, theZ, theT, true);
        this.iQuery.clear();
        return value;
    }

    @RolesAllowed(value={"user"})
    public boolean thumbnailExists(Integer sizeX, Integer sizeY) {
        this.errorIfNullPixelsAndRenderingDef();
        if (this.inProgress) {
            return false;
        }
        Dimension dimensions = this.sanityCheckThumbnailSizes(sizeX, sizeY);
        HashSet<Long> pixelsIds = new HashSet<Long>();
        pixelsIds.add(this.pixelsId);
        this.ctx.loadAndPrepareMetadata(pixelsIds, dimensions, false);
        this.iQuery.clear();
        return this.ctx.isThumbnailCached(this.pixelsId);
    }

    @RolesAllowed(value={"user"})
    @Transactional(readOnly=false)
    public void resetDefaults() {
        if (this.settings == null && this.ctx.isExtendedGraphCritical(Collections.singleton(this.pixelsId))) {
            throw new ApiUsageException("Unable to reset rendering settings in a read-only group for Pixels set id:" + this.pixelsId);
        }
        this._resetDefaults();
        this.iUpdate.flush();
    }

    private void _resetDefaults() {
        this.errorIfNullPixels();
        Parameters params = new Parameters();
        params.addId(this.pixels.getId());
        params.addLong("o_id", this.sec.getEffectiveUID());
        if (this.settings != null || this.iQuery.findByQuery("from RenderingDef as r where r.pixels.id = :id and r.details.owner.id = :o_id", params) != null) {
            throw new ApiUsageException("The thumbnail service only resets **empty** rendering settings. Resetting of existing settings should either be performed using the RenderingEngine or IRenderingSettings.");
        }
        RenderingDef def = this.settingsService.createNewRenderingDef(this.pixels);
        try {
            this.settingsService.resetDefaults(def, this.pixels);
        }
        catch (ConcurrencyException mpe) {
            this.inProgress = true;
            log.info("ConcurrencyException on settingsService.resetDefaults");
        }
    }

    public boolean isDiskSpaceChecking() {
        return this.diskSpaceChecking;
    }

    public void setDiskSpaceChecking(boolean diskSpaceChecking) {
        this.diskSpaceChecking = diskSpaceChecking;
    }

    private byte[] handleNoThumbnail(Throwable t, Dimension dimensions) {
        if (t instanceof ThumbnailCtx.NoThumbnail || t instanceof ReadOnlyGroupSecurityViolation) {
            log.debug("Calling retrieveThumbnailDirect on missing thumbnail");
            return this.retrieveThumbnailDirect((int)dimensions.getWidth(), (int)dimensions.getHeight(), null, null, true);
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        InternalException ie = new InternalException("No thumbnail available!");
        ie.initCause(t);
        throw ie;
    }
}

