/*
 * Decompiled with CFR 0.152.
 */
package ome.services.fulltext;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import ome.conditions.ApiUsageException;
import ome.io.nio.OriginalFilesService;
import ome.model.IEnum;
import ome.model.IObject;
import ome.model.core.OriginalFile;
import ome.services.fulltext.FileParser;
import ome.services.messages.ReindexMessage;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

@Deprecated
public abstract class BridgeHelper
implements FieldBridge,
ApplicationEventPublisherAware {
    public static final String COMBINED = "combined_fields";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ApplicationEventPublisher publisher;

    public static <T> T getProxiedObject(T proxy) {
        if (proxy instanceof HibernateProxy) {
            return (T)((HibernateProxy)proxy).getHibernateLazyInitializer().getImplementation();
        }
        return proxy;
    }

    public final Logger logger() {
        return this.log;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public abstract void set(String var1, Object var2, Document var3, LuceneOptions var4);

    protected void addIfNotNull(Document d, String field, String value, LuceneOptions opts) {
        if (value != null) {
            this.add(d, field, value, opts);
        }
    }

    protected void addEnumIfNotNull(Document d, String field, IEnum value, LuceneOptions opts) {
        if (value != null) {
            this.add(d, field, value.getValue(), opts);
        }
    }

    protected void add(Document d, String field, String value, LuceneOptions opts) {
        if (value == null) {
            throw new RuntimeException("Value for indexing cannot be null. Use a null token instead.");
        }
        Float boost = opts.getBoost();
        Field.Store store = opts.getStore();
        Field.Index index = opts.getIndex();
        if (field != null) {
            Field named_field = new Field(field, value, store, index);
            if (boost != null) {
                named_field.setBoost(boost.floatValue());
            }
            d.add((Fieldable)named_field);
            Field named_parsed_field = new Field(field, (Reader)new StringReader(value));
            d.add((Fieldable)named_parsed_field);
        }
        Field combined_field = new Field(COMBINED, value, Field.Store.NO, index);
        if (boost != null) {
            combined_field.setBoost(boost.floatValue());
        }
        d.add((Fieldable)combined_field);
        Field combined_parsed_field = new Field(COMBINED, (Reader)new StringReader(value));
        d.add((Fieldable)combined_parsed_field);
    }

    protected void addContents(Document d, String name, OriginalFile file, OriginalFilesService files, Map<String, FileParser> parsers, LuceneOptions opts) {
        Field f;
        if (file == null) {
            throw new RuntimeException("File cannot be null. Either do not attempt to add anything for this field, or use a null token like \"null\" instead.");
        }
        Float boost = opts.getBoost();
        if (name != null) {
            for (Reader parsed : this.parse(file, files, parsers)) {
                f = new Field(name, parsed);
                if (boost != null) {
                    f.setBoost(boost.floatValue());
                }
                d.add((Fieldable)f);
            }
        }
        for (Reader parsed : this.parse(file, files, parsers)) {
            f = new Field(COMBINED, parsed);
            if (boost != null) {
                f.setBoost(boost.floatValue());
            }
            d.add((Fieldable)f);
        }
    }

    protected <T extends IObject> void reindex(T object) {
        this.reindexAll(Collections.singletonList(object));
    }

    protected <T extends IObject> void reindexAll(List<T> list) {
        if (this.publisher == null) {
            throw new ApiUsageException("Bridge is not configured for sending messages.");
        }
        for (IObject object : list) {
            if (object != null && object.getId() != null) continue;
            throw new ApiUsageException("Object cannot be null");
        }
        ReindexMessage<T> rm = new ReindexMessage<T>(this, list);
        this.publisher.publishEvent(rm);
    }

    protected Iterable<Reader> parse(OriginalFile file, OriginalFilesService files, Map<String, FileParser> parsers) {
        if (files != null && parsers != null && file != null && file.getMimetype() != null) {
            String path = files.getFilesPath(file.getId());
            String format = file.getMimetype();
            FileParser parser = parsers.get(format);
            if (parser != null) {
                return parser.parse(new File(path));
            }
            parser = parsers.get("*");
            if (parser != null) {
                return parser.parse(new File(path));
            }
        }
        return FileParser.EMPTY;
    }
}

