/*
 * Decompiled with CFR 0.152.
 */
package ome.services.query;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import ome.parameters.Parameters;
import ome.parameters.QueryParameter;
import ome.services.query.Definitions;
import ome.services.query.QueryParameterDef;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class Query<T>
implements HibernateCallback {
    private static Logger log = LoggerFactory.getLogger(Query.class);
    protected static final FetchMode FETCH = FetchMode.JOIN;
    protected static final int LEFT_JOIN = 1;
    protected static final int INNER_JOIN = 0;
    protected final Definitions defs;
    protected final Parameters params;
    private org.hibernate.Query _query;
    private Boolean isCacheable = null;
    private Integer timeout = null;
    private Criteria _criteria;
    protected Set<String> newlyEnabledFilters = new HashSet<String>();

    private Query() {
        this.defs = null;
        this.params = null;
        this.checkParameters();
    }

    public Query(Definitions definitions, Parameters parameters) {
        this.defs = definitions;
        this.params = parameters;
        this.checkParameters();
    }

    protected void checkParameters() {
        if (this.defs == null) {
            throw new IllegalStateException("Query parameter definitions not set.");
        }
        if (this.params == null) {
            throw new IllegalArgumentException("Null arrays are not valid for definitions.");
        }
        HashSet<String> missing = new HashSet<String>();
        for (String name : this.defs.keySet()) {
            if (this.defs.get((Object)name).optional || this.params.keySet().contains(name)) continue;
            missing.add(name);
        }
        if (missing.size() > 0) {
            throw new IllegalArgumentException("Required parameters missing from query: " + missing);
        }
        for (String name : this.defs.keySet()) {
            QueryParameter parameter = this.params.get(name);
            QueryParameterDef def = this.defs.get(name);
            def.errorIfInvalid(parameter);
        }
    }

    public boolean check(String name) {
        return this.defs.containsKey(name);
    }

    public QueryParameter get(String name) {
        return this.params.get(name);
    }

    public Object value(String name) {
        QueryParameter p = this.params.get(name);
        return p == null ? null : p.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doInHibernate(Session session) throws HibernateException, SQLException {
        try {
            this.enableFilters(session);
            this.buildQuery(session);
            if (this._query == null && this._criteria == null) {
                throw new IllegalStateException("buildQuery did not properly define a Query or Criteria\n by calling setQuery() or setCriteria().");
            }
            boolean unique = this.params.isUnique();
            int offset = 0;
            int limit = Integer.MAX_VALUE;
            if (this.params.getOffset() != null) {
                offset = this.params.getOffset();
            }
            if (this.params.getLimit() != null) {
                limit = this.params.getLimit();
            }
            if (this._query != null) {
                if (this.timeout != null) {
                    this._query.setTimeout(this.timeout.intValue());
                }
                this._query.setFirstResult(offset);
                this._query.setMaxResults(limit);
                if (this.isCacheable != null) {
                    this._query.setCacheable(this.isCacheable.booleanValue());
                }
                Object object = unique ? this._query.uniqueResult() : this._query.list();
                return object;
            }
            if (this.timeout != null) {
                this._criteria.setTimeout(this.timeout.intValue());
            }
            this._criteria.setFirstResult(offset);
            this._criteria.setMaxResults(limit);
            if (this.isCacheable != null) {
                this._criteria.setCacheable(this.isCacheable.booleanValue());
            }
            Object object = unique ? this._criteria.uniqueResult() : this._criteria.list();
            return object;
        }
        finally {
            this.disableFilters(session);
        }
    }

    protected abstract void buildQuery(Session var1) throws HibernateException, SQLException;

    protected void setQuery(org.hibernate.Query query) {
        if (this._criteria != null) {
            throw new IllegalStateException("This Query already has a Criteria set:" + this._criteria);
        }
        this._query = query;
    }

    protected void setCriteria(Criteria criteria) {
        if (this._query != null) {
            throw new IllegalStateException("This Query already has a Query set:" + this._query);
        }
        this._criteria = criteria;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    protected void enableFilters(Session session) {
    }

    protected void ownerOrGroupFilters(Session session, String[] ownerFilters, String[] groupFilters) {
        block5: {
            block4: {
                if (!this.params.isGroup()) break block4;
                for (String filter : groupFilters) {
                    if (session.getEnabledFilter(filter) != null) {
                        this.newlyEnabledFilters.add(filter);
                    }
                    session.enableFilter(filter).setParameter("groupId", (Object)this.params.getGroup());
                }
                break block5;
            }
            if (!this.params.isExperimenter()) break block5;
            for (String filter : ownerFilters) {
                if (session.getEnabledFilter(filter) != null) {
                    this.newlyEnabledFilters.add(filter);
                }
                session.enableFilter(filter).setParameter("ownerId", (Object)this.params.getExperimenter());
            }
        }
    }

    protected void disableFilters(Session session) {
        for (String enabledFilter : this.newlyEnabledFilters) {
            session.disableFilter(enabledFilter);
        }
    }

    public Query<T> enableQueryCache() {
        this.isCacheable = true;
        return this;
    }

    public Query<T> disableQueryCache() {
        this.isCacheable = false;
        return this;
    }
}

