/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import ome.services.util.ReadOnlyStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class BeanInstantiationGuard
implements BeanFactoryPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanInstantiationGuard.class);
    protected final String targetName;
    private final ReadOnlyStatus readOnly;
    private boolean isWriteDb = false;
    private boolean isWriteRepo = false;

    public BeanInstantiationGuard(ReadOnlyStatus readOnly, String targetName) {
        this.readOnly = readOnly;
        this.targetName = targetName;
    }

    public void setIsWriteDb(boolean isWriteDb) {
        this.isWriteDb = isWriteDb;
    }

    public void setIsWriteRepo(boolean isWriteRepo) {
        this.isWriteRepo = isWriteRepo;
    }

    private boolean isTriggerConditionMet() {
        return this.isWriteDb && this.readOnly.isReadOnlyDb() || this.isWriteRepo && this.readOnly.isReadOnlyRepo();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) {
        if (this.isTriggerConditionMet()) {
            this.setBeanDefinitionForReadOnly((BeanDefinitionRegistry)factory);
        }
    }

    protected void setBeanDefinitionForReadOnly(BeanDefinitionRegistry registry) {
        LOGGER.info("in read-only state so removing Spring bean named {}", (Object)this.targetName);
        registry.removeBeanDefinition(this.targetName);
    }
}

