/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Color;

public class ImprovisionTiffReader
extends BaseTiffReader {
    public static final String IMPROVISION_MAGIC_STRING = "Improvision";
    private ArrayList<Color> channelColors = new ArrayList();
    private String[] cNames;
    private int pixelSizeT;
    private double pixelSizeX;
    private double pixelSizeY;
    private double pixelSizeZ;
    private String[] files;
    private MinimalTiffReader[] readers;
    private int lastFile = 0;

    public ImprovisionTiffReader() {
        super("Improvision TIFF", new String[]{"tif", "tiff"});
        this.suffixSufficient = false;
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser tp = new TiffParser(stream);
        String comment = tp.getComment();
        if (comment == null) {
            return false;
        }
        return comment.indexOf(IMPROVISION_MAGIC_STRING) >= 0;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.cNames = null;
            this.pixelSizeT = 1;
            this.pixelSizeZ = 0.0;
            this.pixelSizeY = 0.0;
            this.pixelSizeX = 0.0;
            if (this.readers != null) {
                for (MinimalTiffReader reader : this.readers) {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            this.readers = null;
            this.files = null;
            this.lastFile = 0;
            this.channelColors.clear();
        }
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return noPixels ? null : this.files;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.readers == null || this.lastFile < 0 || this.lastFile >= this.readers.length || this.readers[this.lastFile] == null) {
            return super.get8BitLookupTable();
        }
        return this.readers[this.lastFile].get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.readers == null || this.lastFile < 0 || this.lastFile >= this.readers.length || this.readers[this.lastFile] == null) {
            return super.get16BitLookupTable();
        }
        return this.readers[this.lastFile].get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int[] zct = this.getZCTCoords(no);
        int file = FormatTools.getIndex((String)"XYZCT", (int)this.getSizeZ(), (int)this.getEffectiveSizeC(), (int)this.getSizeT(), (int)this.getImageCount(), (int)zct[0], (int)zct[1], (int)zct[2]) % this.files.length;
        int plane = no / this.files.length;
        this.lastFile = file;
        return this.readers[file].openBytes(plane, buf, x, y, w, h);
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.put(IMPROVISION_MAGIC_STRING, "yes");
        String[] comments = new String[this.ifds.size()];
        String tz = null;
        String tc = null;
        String tt = null;
        for (int plane = 0; plane < this.ifds.size(); ++plane) {
            String[] lines;
            String comment;
            comments[plane] = comment = ((IFD)this.ifds.get(plane)).getComment();
            if (comment == null) continue;
            for (String line : lines = comment.split("\n")) {
                int equals = line.indexOf(61);
                if (equals < 0) continue;
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                this.addGlobalMeta(key, value);
                if (key.equals("TotalZPlanes")) {
                    tz = value;
                    continue;
                }
                if (key.equals("TotalChannels")) {
                    tc = value;
                    continue;
                }
                if (key.equals("TotalTimepoints")) {
                    tt = value;
                    continue;
                }
                if (key.equals("XCalibrationMicrons")) {
                    this.pixelSizeX = DataTools.parseDouble(value);
                    continue;
                }
                if (key.equals("YCalibrationMicrons")) {
                    this.pixelSizeY = DataTools.parseDouble(value);
                    continue;
                }
                if (key.equals("ZCalibrationMicrons")) {
                    this.pixelSizeZ = DataTools.parseDouble(value);
                    continue;
                }
                if (!key.equals("WhiteColour")) continue;
                String[] rgb = value.split(",");
                if (rgb.length < 3) {
                    this.channelColors.add(null);
                    continue;
                }
                int red = 255;
                try {
                    red = Integer.parseInt(rgb[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int green = 255;
                try {
                    green = Integer.parseInt(rgb[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int blue = 255;
                try {
                    blue = Integer.parseInt(rgb[2]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.channelColors.add(new Color(red, green, blue, 255));
            }
            this.metadata.remove("Comment");
        }
        CoreMetadata m = (CoreMetadata)this.core.get(0, 0);
        m.sizeT = 1;
        if (this.getSizeZ() == 0) {
            m.sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            m.sizeC = 1;
        }
        if (tz != null) {
            m.sizeZ *= Integer.parseInt(tz);
        }
        if (tc != null) {
            m.sizeC *= Integer.parseInt(tc);
        }
        if (tt != null) {
            m.sizeT *= Integer.parseInt(tt);
        }
        if (this.getSizeZ() * this.getSizeC() * this.getSizeT() < this.getImageCount()) {
            m.sizeC *= this.getImageCount();
        } else {
            m.imageCount = this.getSizeZ() * this.getSizeT() * Integer.parseInt(tc);
        }
        long[] stamps = new long[this.ifds.size()];
        int[][] coords = new int[this.ifds.size()][3];
        this.cNames = new String[this.getSizeC()];
        boolean multipleFiles = false;
        block8: for (int i = 0; i < this.ifds.size(); ++i) {
            Arrays.fill(coords[i], -1);
            String comment = comments[i];
            comment = comment.replaceAll("\r\n", "\n");
            comment = comment.replaceAll("\r", "\n");
            String channelName = null;
            String[] lines = comment.split("\n");
            for (String line : lines) {
                int equals = line.indexOf(61);
                if (equals < 0) continue;
                String key = line.substring(0, equals);
                String value = line.substring(equals + 1);
                if (key.equals("TimeStampMicroSeconds")) {
                    stamps[i] = Long.parseLong(value);
                } else if (key.equals("ZPlane")) {
                    coords[i][0] = Integer.parseInt(value);
                } else if (key.equals("ChannelNo")) {
                    coords[i][1] = Integer.parseInt(value);
                    int ndx = Integer.parseInt(value) - 1;
                    if (this.cNames[ndx] == null) {
                        this.cNames[ndx] = channelName;
                    }
                } else if (key.equals("TimepointName")) {
                    coords[i][2] = Integer.parseInt(value);
                } else if (key.equals("ChannelName")) {
                    channelName = value;
                } else if (key.equals("MultiFileTIFF")) {
                    multipleFiles = value.equalsIgnoreCase("yes");
                }
                if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM && coords[i][0] >= 0 && coords[i][1] >= 0 && coords[i][2] >= 0) continue block8;
            }
        }
        if (multipleFiles) {
            String currentUUID = this.getUUID(this.currentId);
            Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
            Object[] list = parent.list(true);
            Arrays.sort(list);
            ArrayList<String> matchingFiles = new ArrayList<String>();
            for (Object f : list) {
                String path = new Location(parent, (String)f).getAbsolutePath();
                if (!this.isThisType(path) || !this.getUUID(path).equals(currentUUID)) continue;
                matchingFiles.add(path);
            }
            this.files = matchingFiles.toArray(new String[matchingFiles.size()]);
        } else {
            this.files = new String[]{this.currentId};
        }
        if (this.files.length * this.ifds.size() < this.getImageCount()) {
            this.files = new String[]{this.currentId};
            m.imageCount = this.ifds.size();
            m.sizeZ = this.ifds.size();
            m.sizeT = 1;
            if (!this.isRGB()) {
                m.sizeC = 1;
            }
        }
        this.readers = new MinimalTiffReader[this.files.length];
        for (int i = 0; i < this.readers.length; ++i) {
            this.readers[i] = new MinimalTiffReader();
            this.readers[i].setId(this.files[i]);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            long sum = 0L;
            for (int i = 1; i < stamps.length; ++i) {
                long diff = stamps[i] - stamps[i - 1];
                if (diff <= 0L) continue;
                sum += diff;
            }
            this.pixelSizeT = (int)(sum / (long)this.getSizeT());
        }
        m.dimensionOrder = "XY";
        if (this.isRGB()) {
            m.dimensionOrder = m.dimensionOrder + 'C';
        }
        for (int i = 1; i < coords.length; ++i) {
            int zDiff = coords[i][0] - coords[i - 1][0];
            int cDiff = coords[i][1] - coords[i - 1][1];
            int tDiff = coords[i][2] - coords[i - 1][2];
            if (zDiff > 0 && this.getDimensionOrder().indexOf(90) < 0) {
                m.dimensionOrder = m.dimensionOrder + 'Z';
            }
            if (cDiff > 0 && this.getDimensionOrder().indexOf(67) < 0) {
                m.dimensionOrder = m.dimensionOrder + 'C';
            }
            if (tDiff > 0 && this.getDimensionOrder().indexOf(84) < 0) {
                m.dimensionOrder = m.dimensionOrder + 'T';
            }
            if (m.dimensionOrder.length() == 5) break;
        }
        if (this.getDimensionOrder().indexOf(90) < 0) {
            m.dimensionOrder = m.dimensionOrder + 'Z';
        }
        if (this.getDimensionOrder().indexOf(67) < 0) {
            m.dimensionOrder = m.dimensionOrder + 'C';
        }
        if (this.getDimensionOrder().indexOf(84) < 0) {
            m.dimensionOrder = m.dimensionOrder + 'T';
        }
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length sizeX = FormatTools.getPhysicalSizeX((Double)this.pixelSizeX);
            Length sizeY = FormatTools.getPhysicalSizeY((Double)this.pixelSizeY);
            Length sizeZ = FormatTools.getPhysicalSizeZ((Double)this.pixelSizeZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
            store.setPixelsTimeIncrement(new Time((Number)((double)this.pixelSizeT / 1000000.0), UNITS.SECOND), 0);
            for (int i = 0; i < this.getEffectiveSizeC(); ++i) {
                int index;
                if (this.cNames != null && i < this.cNames.length) {
                    store.setChannelName(this.cNames[i], 0, i);
                }
                if ((index = this.getIndex(0, i, 0)) >= this.channelColors.size() || this.channelColors.get(index) == null) continue;
                store.setChannelColor(this.channelColors.get(index), 0, i);
            }
            store.setImageDescription("", 0);
        }
    }

    private String getUUID(String path) throws FormatException, IOException {
        String[] lines;
        String comment = null;
        try (RandomAccessInputStream s = new RandomAccessInputStream(path, 16);){
            TiffParser parser = new TiffParser(s);
            comment = parser.getComment();
        }
        comment = comment.replaceAll("\r\n", "\n");
        comment = comment.replaceAll("\r", "\n");
        for (String line : lines = comment.split("\n")) {
            if (!(line = line.trim()).startsWith("SampleUUID=")) continue;
            return line.substring(line.indexOf(61) + 1).trim();
        }
        return "";
    }
}

