/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.Timestamp;

public class MicroCTReader
extends FormatReader {
    private static final String VFF_MAGIC = "ncaa";
    private static final String DATE_FORMAT = "EEE, MMM dd, yyyy HH:mm:ss a";
    private String[] vffs;
    private long[] headerSize;
    private ArrayList<String> metadataFiles = new ArrayList();
    private String date;
    private String time;
    private String imageDescription;
    private Double exposureTime;

    public MicroCTReader() {
        super("MicroCT", "vff");
        this.domains = new String[]{"Medical Imaging"};
        this.datasetDescription = "Directory with XML file and one .tif/.tiff file per plane";
    }

    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 1;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        FilePattern pattern = new FilePattern(FilePattern.findPattern((String)id));
        return pattern.getFiles().length == 1;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return stream.readString(4).equals(VFF_MAGIC);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        ArrayList<String> files = new ArrayList<String>();
        if (!noPixels) {
            for (String file : this.vffs) {
                files.add(file);
            }
        }
        files.addAll(this.metadataFiles);
        return files.toArray(new String[files.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.vffs = null;
            this.headerSize = null;
            this.metadataFiles.clear();
            this.date = null;
            this.time = null;
            this.imageDescription = null;
            this.exposureTime = null;
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int vffIndex = no % this.vffs.length;
        try (RandomAccessInputStream vff = new RandomAccessInputStream(this.vffs[vffIndex]);){
            if (this.headerSize[vffIndex] == 0L) {
                this.skipHeader(vff);
                this.headerSize[vffIndex] = vff.getFilePointer();
            }
            long planeSize = FormatTools.getPlaneSize((IFormatReader)this);
            vff.seek(this.headerSize[vffIndex] + planeSize * (long)(no / this.vffs.length));
            this.readPlane(vff, x, y, w, h, buf);
            byte[] row = new byte[(int)((long)w * (planeSize / (long)(this.getSizeX() * this.getSizeY())))];
            for (int yy = 0; yy < h / 2; ++yy) {
                int topOffset = buf.length - (yy + 1) * row.length;
                int bottomOffset = yy * row.length;
                System.arraycopy(buf, bottomOffset, row, 0, row.length);
                System.arraycopy(buf, topOffset, buf, bottomOffset, row.length);
                System.arraycopy(row, 0, buf, topOffset, row.length);
            }
            byte[] byArray = buf;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFile(String id) throws FormatException, IOException {
        String[] files;
        super.initFile(id);
        FilePattern pattern = new FilePattern(FilePattern.findPattern((String)id));
        this.vffs = pattern.getFiles();
        this.headerSize = new long[this.vffs.length];
        Location parent = new Location(id).getAbsoluteFile().getParentFile();
        for (String file : files = parent.list(true)) {
            Location metadata;
            if (MicroCTReader.checkSuffix((String)file, (String)"vff") || (metadata = new Location(parent, file)).isDirectory()) continue;
            this.metadataFiles.add(metadata.getAbsolutePath());
        }
        CoreMetadata ms = (CoreMetadata)this.core.get(0);
        ms.sizeZ = this.vffs.length;
        PositiveFloat physicalSize = null;
        this.in = new RandomAccessInputStream(id);
        try {
            Object line = this.in.readLine().trim();
            int dimCount = 0;
            while (((String)line).length() > 0) {
                int eq = ((String)line).indexOf("=");
                if (eq >= 0) {
                    String key = ((String)line).substring(0, eq);
                    String value = ((String)line).substring(eq + 1, ((String)line).length() - 1);
                    this.processKey(key, value);
                    if (key.equals("rank")) {
                        dimCount = Integer.parseInt(value);
                    } else if (key.equals("size")) {
                        String[] dims = value.split(" ");
                        if (dimCount > 0) {
                            ms.sizeX = Integer.parseInt(dims[0]);
                        }
                        if (dimCount > 1) {
                            ms.sizeY = Integer.parseInt(dims[1]);
                        }
                        if (dimCount > 2) {
                            ms.sizeZ *= Integer.parseInt(dims[2]);
                        }
                    } else if (key.equals("bits")) {
                        int bits = Integer.parseInt(value);
                        ms.pixelType = FormatTools.pixelTypeFromBytes((int)(bits / 8), (boolean)true, (boolean)false);
                    } else if (key.equals("elementsize")) {
                        Double size = DataTools.parseDouble(value);
                        physicalSize = new PositiveFloat(Double.valueOf(size * 1000.0));
                    }
                }
                line = this.in.readLine().trim();
            }
        }
        finally {
            this.in.close();
        }
        ms.sizeT = 1;
        ms.sizeC = 1;
        ms.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        ms.dimensionOrder = "XYZCT";
        for (String file : this.metadataFiles) {
            String name = new Location(file).getName();
            String data = DataTools.readFile(file).trim();
            if (MicroCTReader.checkSuffix((String)file, (String)"protocol") || MicroCTReader.checkSuffix((String)file, (String)"log") || name.equals("Parameters.txt")) {
                String[] pairs;
                String separator = name.equals("Parameters.txt") ? ":" : "=";
                for (String pair : pairs = data.split("\r\n")) {
                    int sep = pair.indexOf(separator);
                    if (sep < 0) continue;
                    this.processKey(pair.substring(0, sep).trim(), pair.substring(sep + 1).trim());
                }
                continue;
            }
            this.processKey(name, data);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (this.exposureTime != null ? 1 : 0) != 0);
        if (this.imageDescription != null) {
            store.setImageDescription(this.imageDescription, 0);
        }
        if (this.date != null && this.time != null) {
            String timestamp = DateTools.formatDate(this.date + " " + this.time, DATE_FORMAT);
            store.setImageAcquisitionDate(new Timestamp(timestamp), 0);
        }
        if (physicalSize != null) {
            Length size = FormatTools.createLength(physicalSize, (Unit)UNITS.MICROMETER);
            store.setPixelsPhysicalSizeX(size, 0);
            store.setPixelsPhysicalSizeY(size, 0);
            store.setPixelsPhysicalSizeZ(size, 0);
        }
        if (this.exposureTime != null) {
            Time exposureSeconds = new Time((Number)this.exposureTime, UNITS.SECOND);
            for (int i = 0; i < this.getImageCount(); ++i) {
                store.setPlaneExposureTime(exposureSeconds, 0, i);
            }
        }
    }

    private void skipHeader(RandomAccessInputStream s) throws IOException {
        while (s.readLine().trim().length() > 0) {
        }
    }

    private void processKey(String key, String value) {
        this.addGlobalMeta(key, value);
        if (key.equals("Exposure Time (ms)")) {
            this.exposureTime = DataTools.parseDouble(value);
            this.exposureTime = this.exposureTime / 1000.0;
        } else if (key.equals("Description.txt")) {
            this.imageDescription = value;
        } else if (key.equals("Date")) {
            this.date = value;
        } else if (key.equals("Time")) {
            this.time = value;
        }
    }
}

