/*
 * Decompiled with CFR 0.152.
 */
package ome.util.math.geom2D;

import ome.util.math.geom2D.Line;
import ome.util.math.geom2D.PlanePoint;

public class Segment {
    public final double originX1;
    public final double originX2;
    public final double directionX1;
    public final double directionX2;

    public Segment(double originX1, double originX2, double endX1, double endX2) {
        if (originX1 == endX1 && originX2 == endX2) {
            throw new IllegalArgumentException("Need two different points.");
        }
        this.originX1 = originX1;
        this.originX2 = originX2;
        this.directionX1 = endX1 - originX1;
        this.directionX2 = endX2 - originX2;
    }

    public PlanePoint getPoint(double k) {
        if (k < 0.0 || k > 1.0) {
            throw new IllegalArgumentException("Coefficient must be in the range [0, 1].");
        }
        return new PlanePoint(this.originX1 + k * this.directionX1, this.originX2 + k * this.directionX2);
    }

    public boolean lies(double x1, double x2) {
        double k2;
        double k1;
        boolean result = false;
        if (this.directionX1 == 0.0 && this.directionX2 != 0.0) {
            double k22 = (x2 - this.originX2) / this.directionX2;
            result = k22 < 0.0 || k22 > 1.0 ? false : x1 == this.originX1;
        } else if (this.directionX1 != 0.0 && this.directionX2 == 0.0) {
            double k12 = (x1 - this.originX1) / this.directionX1;
            result = k12 < 0.0 || k12 > 1.0 ? false : x2 == this.originX2;
        } else if (this.directionX1 != 0.0 && this.directionX2 != 0.0 && (k1 = (x1 - this.originX1) / this.directionX1) == (k2 = (x2 - this.originX2) / this.directionX2)) {
            result = !(k1 < 0.0) && !(k1 > 1.0);
        }
        return result;
    }

    public boolean equals(double k, double x1, double x2) {
        if (k < 0.0 || k > 1.0) {
            throw new IllegalArgumentException("Coefficient must be in the range [0, 1].");
        }
        double kPointX1 = this.originX1 + k * this.directionX1;
        double kPointX2 = this.originX2 + k * this.directionX2;
        return kPointX1 == x1 && kPointX2 == x2;
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o != null && o instanceof Line) {
            Line other = (Line)o;
            isEqual = other.origin.x1 == this.originX1 && other.origin.x2 == this.originX2 && other.direction.x1 == this.directionX1 && other.direction.x2 == this.directionX2;
        }
        return isEqual;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.originX1);
        return (int)(bits ^= Double.doubleToLongBits(this.originX2) * 31L) ^ (int)(bits >> 32);
    }
}

