/*
 * Decompiled with CFR 0.152.
 */
package ome.security.auth;

import java.util.Collections;
import ome.model.meta.Experimenter;
import ome.security.auth.ConfigurablePasswordProvider;
import ome.security.auth.PasswordChangeException;
import ome.security.auth.PasswordUtil;
import ome.services.messages.EventLogMessage;
import org.springframework.context.ApplicationEvent;

public class JdbcPasswordProvider
extends ConfigurablePasswordProvider {
    public JdbcPasswordProvider(PasswordUtil util) {
        super(util);
    }

    public JdbcPasswordProvider(PasswordUtil util, boolean ignoreUnknown) {
        super(util, ignoreUnknown);
    }

    public JdbcPasswordProvider(PasswordUtil util, boolean ignoreUnknown, boolean salt) {
        super(util, ignoreUnknown, salt);
    }

    @Override
    public boolean hasPassword(String user) {
        Long id = this.util.userId(user);
        return id != null;
    }

    @Override
    public Boolean checkPassword(String user, String password, boolean readOnly) {
        Long id = this.util.userId(user);
        Boolean b = null;
        if (id == null) {
            b = super.checkPassword(user, password, readOnly);
        } else {
            String trusted = this.util.getUserPasswordHash(id);
            b = this.comparePasswords(id, trusted, password);
        }
        this.loginAttempt(user, b);
        return b;
    }

    @Override
    public void changePassword(String user, String password) throws PasswordChangeException {
        this.changePassword(user, password, this.salt ? PasswordUtil.METHOD.ALL : PasswordUtil.METHOD.LEGACY);
    }

    protected void changePassword(String user, String password, PasswordUtil.METHOD method) throws PasswordChangeException {
        Long id = this.util.userId(user);
        if (id == null) {
            throw new PasswordChangeException("Couldn't find id: " + user);
        }
        this.util.changeUserPasswordById(id, password, method);
        EventLogMessage event = new EventLogMessage(this, "PASSWORD", Experimenter.class, Collections.singletonList(id));
        this.ctx.publishEvent((ApplicationEvent)event);
    }
}

