/*
 * Decompiled with CFR 0.152.
 */
package ome.tools;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ome.model.IObject;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.model.core.Image;
import ome.util.CBlock;

public class HierarchyTransformations {
    public static <T extends IObject> Set<T> invertPDI(Set<Image> imagesAll, CBlock<T> block) {
        HashSet<Object> cleared = new HashSet<Object>();
        HashSet<Object> hierarchies = new HashSet<Object>();
        Iterator<Image> i = imagesAll.iterator();
        while (i.hasNext()) {
            Image img = (Image)block.call((IObject)i.next());
            List d_list = img.linkedDatasetList();
            Iterator d = d_list.iterator();
            if (!d.hasNext()) {
                hierarchies.add(img);
                continue;
            }
            while (d.hasNext()) {
                Dataset ds = (Dataset)block.call((IObject)d.next());
                if (!cleared.contains(ds)) {
                    ds.putAt("ome.model.containers.Dataset_imageLinks", new HashSet());
                    cleared.add(ds);
                }
                ds.linkImage(img);
                List p_list = ds.linkedProjectList();
                Iterator p = p_list.iterator();
                if (!p.hasNext()) {
                    hierarchies.add(ds);
                    continue;
                }
                while (p.hasNext()) {
                    Project prj = (Project)block.call((IObject)p.next());
                    if (!cleared.contains(prj)) {
                        prj.putAt("ome.model.containers.Project_datasetLinks", new HashSet());
                        cleared.add(prj);
                    }
                    prj.linkDataset(ds);
                    hierarchies.add(prj);
                }
            }
        }
        return hierarchies;
    }
}

