/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import io.airlift.compress.MalformedInputException;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.io.IOException;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;
import ome.codecs.UnsupportedCompressionException;

public class ZstdCodec
extends BaseCodec {
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("No data to compress");
        }
        throw new UnsupportedCompressionException("Zstandard Compression not currently supported.");
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        long byteCount = in.length() - in.getFilePointer();
        if (byteCount > Integer.MAX_VALUE || byteCount < 0L) {
            throw new CodecException("Integer overflow detected when calculating file byteCount.");
        }
        byte[] data = new byte[(int)byteCount];
        in.readFully(data);
        return this.decompress(data);
    }

    @Override
    public byte[] decompress(byte[] data) throws CodecException {
        return this.decompress(data, 0, data.length);
    }

    @Override
    public byte[] decompress(byte[] data, CodecOptions options) throws CodecException {
        return this.decompress(data, 0, data.length);
    }

    public byte[] decompress(byte[] data, int inputOffset, int length) throws CodecException {
        ZstdDecompressor decompressor = new ZstdDecompressor();
        byte[] output = new byte[(int)ZstdDecompressor.getDecompressedSize((byte[])data, (int)inputOffset, (int)length)];
        try {
            decompressor.decompress(data, inputOffset, length, output, 0, output.length);
        }
        catch (MalformedInputException e) {
            throw new CodecException(e);
        }
        return output;
    }
}

