/*
 * Decompiled with CFR 0.152.
 */
package omeis.providers.re;

import java.io.Serializable;
import java.util.Arrays;

public class RGBBuffer
implements Serializable {
    private static final long serialVersionUID = 5319594152389817323L;
    public static final int R_BAND = 0;
    public static final int G_BAND = 1;
    public static final int B_BAND = 2;
    private byte[][] bands;
    private int sizeX1;
    private int sizeX2;

    protected RGBBuffer() {
    }

    public RGBBuffer(int sizeX1, int sizeX2) {
        this.sizeX1 = sizeX1;
        this.sizeX2 = sizeX2;
        this.bands = new byte[3][];
        for (int i = 0; i < 3; ++i) {
            this.bands[i] = new byte[sizeX1 * sizeX2];
        }
    }

    public byte[] getRedBand() {
        return this.bands[0];
    }

    public byte[] getGreenBand() {
        return this.bands[1];
    }

    public byte[] getBlueBand() {
        return this.bands[2];
    }

    public int getSizeX1() {
        return this.sizeX1;
    }

    public int getSizeX2() {
        return this.sizeX2;
    }

    public synchronized void setRedValue(int index, int value) {
        this.bands[0][index] = (byte)value;
    }

    public synchronized void setGreenValue(int index, int value) {
        this.bands[1][index] = (byte)value;
    }

    public synchronized void setBlueValue(int index, int value) {
        this.bands[2][index] = (byte)value;
    }

    public byte getRedValue(int index) {
        return this.bands[0][index];
    }

    public byte getGreenValue(int index) {
        return this.bands[1][index];
    }

    public byte getBlueValue(int index) {
        return this.bands[2][index];
    }

    public void zero() {
        for (int i = 0; i < this.bands.length; ++i) {
            Arrays.fill(this.bands[i], (byte)0);
        }
    }
}

