/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd;

import Ice.Current;
import java.util.Map;
import ome.security.basic.CurrentDetails;
import ome.system.OmeroContext;
import omero.SecurityViolation;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CallContext
implements MethodInterceptor {
    public static final String FILENAME_KEY = "omero.logfilename";
    public static final String TOKEN_KEY = "omero.logfilename.token";
    private static Logger log = LoggerFactory.getLogger(CallContext.class);
    private final CurrentDetails cd;
    private final String token;
    private final Current current;

    public CallContext(OmeroContext ctx, String token, Current current) {
        this.cd = (CurrentDetails)ctx.getBean(CurrentDetails.class);
        this.token = token;
        this.current = current;
    }

    public CallContext(OmeroContext ctx, String token) {
        this(ctx, token, null);
    }

    public CallContext(CurrentDetails cd, String token) {
        this.cd = cd;
        this.token = token;
        this.current = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation arg0) throws Throwable {
        Object last;
        Object[] args;
        if (arg0 != null && (args = arg0.getArguments()) != null && args.length > 0 && Current.class.isAssignableFrom((last = args[args.length - 1]).getClass())) {
            Current current = (Current)last;
            Map ctx = current.ctx;
            if (ctx != null && ctx.size() > 0) {
                this.cd.setContext(ctx);
                if (!this.checkLogFile(ctx, true) && this.current != null) {
                    this.checkLogFile(this.current.ctx, true);
                }
            }
        }
        try {
            Object object = arg0.proceed();
            return object;
        }
        finally {
            this.cd.setContext(null);
            MDC.clear();
        }
    }

    private boolean checkLogFile(Map<String, String> ctx, boolean requireToken) throws SecurityViolation {
        String token;
        if (ctx == null) {
            return false;
        }
        String filename = ctx.get(FILENAME_KEY);
        if (filename == null) {
            return false;
        }
        if (requireToken && !this.token.equals(token = ctx.get(TOKEN_KEY))) {
            log.error("Found bad token: user={} != server={}", (Object)token, (Object)this.token);
            throw new SecurityViolation(null, null, String.format("Setting the %s value is not permitted without a secure server token!", FILENAME_KEY));
        }
        MDC.put((String)"fileset", (String)filename);
        return true;
    }
}

