/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.basic;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.OK;
import omero.cmd.Response;
import omero.cmd.Timing;

public class TimingI
extends Timing
implements IRequest {
    private static final long serialVersionUID = -1L;
    private final CountDownLatch latch = new CountDownLatch(1);
    private Helper helper;

    @Override
    public Map<String, String> getCallContext() {
        return null;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        if (this.steps > 1000000) {
            helper.cancel(new ERR(), null, "too-many-steps", "steps", "" + this.steps);
        } else if (this.millisPerStep > 300000) {
            helper.cancel(new ERR(), null, "too-long-steps", "millisPerStep", "" + this.millisPerStep);
        } else if (this.millisPerStep * this.steps > 300000) {
            helper.cancel(new ERR(), null, "too-long", "millisPerStep", "" + this.millisPerStep, "steps", "" + this.steps);
        }
        this.helper.setSteps(this.steps);
    }

    @Override
    public Object step(int step) {
        this.helper.assertStep(step);
        try {
            this.latch.await(this.millisPerStep, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.helper.debug("Interrupted", new Object[0]);
        }
        return null;
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (this.helper.isLast(step)) {
            this.helper.setResponseIfNull(new OK());
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }
}

