/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.IndexMap;
import ch.systemsx.cisd.hdf5.exceptions.HDF5SpaceRankMismatch;
import hdf.hdf5lib.exceptions.HDF5JavaException;

public final class HDF5ArrayBlockParams {
    int[] blockDimensions;
    long[] blockIndex;
    long[] blockOffset;
    long[] boundIndexArray;
    IndexMap boundIndexMap;

    HDF5ArrayBlockParams() {
    }

    int[] getBlockDimensions() {
        return this.blockDimensions;
    }

    long[] getOffset(int[] blockDimensions) {
        if (this.blockOffset == null) {
            if (blockDimensions == null) {
                throw new HDF5JavaException("No block dimensions set");
            }
            this.blockOffset = new long[blockDimensions.length];
            if (this.blockIndex != null) {
                if (blockDimensions.length != this.blockIndex.length) {
                    throw new HDF5SpaceRankMismatch(blockDimensions.length, this.blockIndex.length);
                }
                int i = 0;
                while (i < this.blockOffset.length) {
                    this.blockOffset[i] = this.blockIndex[i] * (long)blockDimensions[i];
                    ++i;
                }
            }
        }
        return this.blockOffset;
    }

    long[] getOffset() {
        return this.getOffset(this.blockDimensions);
    }

    long[] getBoundIndexArray() {
        return this.boundIndexArray;
    }

    IndexMap getBoundIndexMap() {
        return this.boundIndexMap;
    }

    boolean hasBlock() {
        return this.blockDimensions != null || this.blockIndex != null || this.blockOffset != null;
    }

    boolean hasSlice() {
        return this.boundIndexArray != null || this.boundIndexMap != null;
    }

    public HDF5ArrayBlockParams block(int ... dimensions) {
        this.blockDimensions = dimensions;
        return this;
    }

    public HDF5ArrayBlockParams index(long ... blockIndex) {
        this.blockIndex = blockIndex;
        return this;
    }

    public HDF5ArrayBlockParams offset(long ... offset) {
        this.blockOffset = offset;
        return this;
    }

    public HDF5ArrayBlockParams slice(long ... boundIndices) {
        this.boundIndexArray = boundIndices;
        return this;
    }

    public HDF5ArrayBlockParams slice(IndexMap boundIndices) {
        this.boundIndexMap = boundIndices;
        return this;
    }
}

