/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.internal;

import java.util.ArrayList;
import java.util.List;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.NonNegativeInteger;

public abstract class WellContainer
implements Comparable<WellContainer> {
    private int plateAcquisitionIndex;
    private int rowIndex;
    private int columnIndex;
    private transient int wellIndex;
    private int fieldCount;
    private List<String> files = new ArrayList<String>();

    public WellContainer() {
    }

    public WellContainer(int pa, int row, int col, int fields) {
        this.plateAcquisitionIndex = pa;
        this.rowIndex = row;
        this.columnIndex = col;
        this.fieldCount = fields;
    }

    public String getFile(int fieldIndex, int planeIndex) {
        String[] fieldFiles = this.getFiles(fieldIndex);
        if (fieldFiles != null && planeIndex < fieldFiles.length) {
            return fieldFiles[planeIndex];
        }
        return null;
    }

    public abstract String[] getFiles(int var1);

    public List<String> getAllFiles() {
        return this.files;
    }

    public void addFile(String file) {
        this.files.add(file);
    }

    public int getPlateAcquisition() {
        return this.plateAcquisitionIndex;
    }

    public void setPlateAcquisition(int pa) {
        this.plateAcquisitionIndex = pa;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int newRow) {
        this.rowIndex = newRow;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int newColumn) {
        this.columnIndex = newColumn;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public void setFieldCount(int fields) {
        this.fieldCount = fields;
    }

    public int getWellIndex() {
        return this.wellIndex;
    }

    public void setWellIndex(int index) {
        this.wellIndex = index;
    }

    public void fillMetadataStore(MetadataStore store, int plate, int plateAcq, int wellSampleStart, int nextImage) {
        this.fillMetadataStore(store, plate, plateAcq, this.wellIndex, wellSampleStart, nextImage);
    }

    public void fillMetadataStore(MetadataStore store, int plate, int plateAcq, int well, int wellSampleStart, int nextImage) {
        store.setWellID(MetadataTools.createLSID("Well", plate, well), plate, well);
        store.setWellRow(new NonNegativeInteger(Integer.valueOf(this.getRowIndex())), plate, well);
        store.setWellColumn(new NonNegativeInteger(Integer.valueOf(this.getColumnIndex())), plate, well);
        for (int field = 0; field < this.getFieldCount(); ++field) {
            int wellSampleIndex = field + wellSampleStart;
            String wellSample = MetadataTools.createLSID("WellSample", plate, well, wellSampleIndex);
            store.setWellSampleID(wellSample, plate, well, wellSampleIndex);
            int imageIndex = nextImage + field;
            store.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(imageIndex)), plate, well, wellSampleIndex);
            String imageID = MetadataTools.createLSID("Image", imageIndex);
            store.setImageID(imageID, imageIndex);
            store.setWellSampleImageRef(imageID, plate, well, wellSampleIndex);
            store.setPlateAcquisitionWellSampleRef(wellSample, plate, plateAcq, imageIndex);
        }
    }

    @Override
    public int compareTo(WellContainer w) {
        int paDiff = this.getPlateAcquisition() - w.getPlateAcquisition();
        if (paDiff != 0) {
            return paDiff;
        }
        int rowDiff = this.getRowIndex() - w.getRowIndex();
        if (rowDiff != 0) {
            return rowDiff;
        }
        return this.getColumnIndex() - w.getColumnIndex();
    }
}

