/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.model.DataObject;
import omero.gateway.model.SearchResult;

public class SearchResultCollection
extends ArrayList<SearchResult> {
    public static final int NO_ERROR = 0;
    public static final int GENERAL_ERROR = 1;
    public static final int TOO_MANY_RESULTS_ERROR = 2;
    public static final int TOO_MANY_CLAUSES = 3;
    private int error = 0;

    public boolean isError() {
        return this.error != 0;
    }

    public void setError(int error) {
        this.error = error;
    }

    public int getError() {
        return this.error;
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof SearchResult)) {
            return false;
        }
        SearchResult a = (SearchResult)o;
        for (SearchResult b : this) {
            if (!b.getType().equals(a.getType()) || b.getObjectId() != a.getObjectId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.error = 0;
    }

    public List<SearchResult> getResults(int scopeId, Class<? extends DataObject> type) {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        for (SearchResult r : this) {
            if (scopeId < 0 && r.getScopeId() != scopeId || type != null && !r.getType().equals(type)) continue;
            result.add(r);
        }
        return result;
    }

    public List<DataObject> getDataObjects(int scopeId, Class<? extends DataObject> type) {
        ArrayList<DataObject> result = new ArrayList<DataObject>();
        for (SearchResult r : this) {
            if (scopeId >= 0 && r.getScopeId() != scopeId || type != null && !r.getType().equals(type)) continue;
            result.add(r.getObject());
        }
        return result;
    }

    public Map<Long, List<SearchResult>> getByGroup() {
        return this.getByGroup(null);
    }

    public Map<Long, List<SearchResult>> getByGroup(Class<? extends DataObject> type) {
        HashMap<Long, List<SearchResult>> result = new HashMap<Long, List<SearchResult>>();
        for (SearchResult r : this) {
            ArrayList<SearchResult> list = (ArrayList<SearchResult>)result.get(r.getGroupId());
            if (list == null) {
                list = new ArrayList<SearchResult>();
                result.put(r.getGroupId(), list);
            }
            if (type != null && !r.getType().equals(type)) continue;
            list.add(r);
        }
        return result;
    }

    public void consolidate() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            SearchResult r = (SearchResult)it.next();
            if (r.getObject() != null) continue;
            it.remove();
        }
    }

    @Override
    public String toString() {
        String s = "SearchResultCollection [error=" + this.error + "]:\n";
        for (SearchResult r : this) {
            s = s + r.toString() + "\n";
        }
        return s;
    }
}

