/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import omero.RType;
import omero.cmd.OriginalMetadataResponse;
import omero.gateway.util.ModelMapper;
import omero.gateway.util.Utils;

public class OriginalMetadataParser {
    private final File file;
    private final StringBuffer buffer;

    private String writeMap(Map<String, RType> map, String separator) {
        if (map == null || map.size() == 0) {
            return null;
        }
        if (Utils.isBlank(separator)) {
            separator = " ";
        }
        TreeSet<String> sortedSet = new TreeSet<String>(map.keySet());
        Iterator<String> j = sortedSet.iterator();
        StringBuffer buffer = new StringBuffer();
        while (j.hasNext()) {
            Object l;
            String key = j.next();
            buffer.append(key);
            buffer.append(separator);
            Object v = ModelMapper.convertRTypeToJava(map.get(key));
            if (v instanceof List) {
                l = (List)v;
                Iterator k = l.iterator();
                while (k.hasNext()) {
                    buffer.append(k.next());
                    buffer.append(" ");
                }
            } else if (v instanceof Map) {
                l = (Map)v;
                for (Map.Entry e : l.entrySet()) {
                    buffer.append((String)e.getKey());
                    buffer.append(separator);
                    buffer.append(e.getValue());
                }
            } else {
                buffer.append(v.toString());
            }
            buffer.append(System.getProperty("line.separator"));
        }
        return buffer.toString();
    }

    public OriginalMetadataParser(File file) {
        if (file == null) {
            throw new IllegalArgumentException("No file to write the content to.");
        }
        this.file = file;
        this.buffer = new StringBuffer();
    }

    public OriginalMetadataParser(StringBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("No buffer to write the content to.");
        }
        this.file = null;
        this.buffer = buffer;
    }

    public void read(OriginalMetadataResponse response) throws Exception {
        this.read(response, null);
    }

    public void read(OriginalMetadataResponse response, String separator) throws Exception {
        String value = this.writeMap(response.globalMetadata, separator);
        if (value != null) {
            this.buffer.append("[GlobalMetadata]");
            this.buffer.append(System.getProperty("line.separator"));
            this.buffer.append(this.writeMap(response.globalMetadata, separator));
            this.buffer.append(System.getProperty("line.separator"));
        }
        if ((value = this.writeMap(response.seriesMetadata, separator)) != null) {
            this.buffer.append("[SeriesMetadata]");
            this.buffer.append(System.getProperty("line.separator"));
            this.buffer.append(this.writeMap(response.seriesMetadata, separator));
        }
        if (this.file != null) {
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "UTF-8");){
                BufferedWriter bufferWriter = new BufferedWriter(writer);
                bufferWriter.write(this.buffer.toString());
                this.buffer.setLength(0);
            }
            catch (Exception e) {
                throw new Exception("Error while writing metadata to file.", e);
            }
        }
    }
}

