/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.store;

import dev.zarr.zarrjava.store.Store;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FilesystemStore
implements Store,
Store.ListableStore {
    @Nonnull
    private final Path path;

    public FilesystemStore(@Nonnull Path path) {
        this.path = path;
    }

    public FilesystemStore(@Nonnull String path) {
        this.path = Paths.get(path, new String[0]);
    }

    Path resolveKeys(String[] keys) {
        Path newPath = this.path;
        for (String key : keys) {
            newPath = newPath.resolve(key);
        }
        return newPath;
    }

    @Override
    public boolean exists(String[] keys) {
        return Files.exists(this.resolveKeys(keys), new LinkOption[0]);
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys) {
        try {
            return ByteBuffer.wrap(Files.readAllBytes(this.resolveKeys(keys)));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys, long start) {
        ByteBuffer byteBuffer;
        block8: {
            SeekableByteChannel byteChannel = Files.newByteChannel(this.resolveKeys(keys), new OpenOption[0]);
            try {
                long startOffset = 0L;
                startOffset = start >= 0L ? start : byteChannel.size() + start;
                long endOffset = byteChannel.size();
                ByteBuffer bytes = Utils.allocateNative((int)(endOffset - startOffset));
                byteChannel.position(startOffset);
                byteChannel.read(bytes);
                bytes.rewind();
                byteBuffer = bytes;
                if (byteChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (byteChannel != null) {
                        try {
                            byteChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            byteChannel.close();
        }
        return byteBuffer;
    }

    @Override
    @Nullable
    public ByteBuffer get(String[] keys, long start, long end) {
        ByteBuffer byteBuffer;
        block8: {
            SeekableByteChannel byteChannel = Files.newByteChannel(this.resolveKeys(keys), new OpenOption[0]);
            try {
                long startOffset = 0L;
                startOffset = start >= 0L ? start : byteChannel.size() + start;
                ByteBuffer bytes = Utils.allocateNative((int)(end - startOffset));
                byteChannel.position(startOffset);
                byteChannel.read(bytes);
                bytes.rewind();
                byteBuffer = bytes;
                if (byteChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (byteChannel != null) {
                        try {
                            byteChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            byteChannel.close();
        }
        return byteBuffer;
    }

    @Override
    public void set(String[] keys, ByteBuffer bytes) {
        Path keyPath = this.resolveKeys(keys);
        try {
            Files.createDirectories(keyPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (SeekableByteChannel channel = Files.newByteChannel(keyPath.toAbsolutePath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            channel.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(String[] keys) {
        try {
            Files.delete(this.resolveKeys(keys));
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Stream<String> list(String[] keys) {
        try {
            return Files.list(this.resolveKeys(keys)).map(p -> p.toFile().getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nonnull
    public StoreHandle resolve(String ... keys) {
        return new StoreHandle(this, keys);
    }

    public String toString() {
        return this.path.toUri().toString().replaceAll("\\/$", "");
    }
}

