/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.codec.CodecPipeline;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v3.ArrayMetadata;
import dev.zarr.zarrjava.v3.ArrayMetadataBuilder;
import dev.zarr.zarrjava.v3.Node;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class Array
extends Node
implements dev.zarr.zarrjava.core.Array {
    public ArrayMetadata metadata;
    CodecPipeline codecPipeline;

    protected Array(StoreHandle storeHandle, ArrayMetadata arrayMetadata) throws ZarrException {
        super(storeHandle);
        this.metadata = arrayMetadata;
        this.codecPipeline = new CodecPipeline(arrayMetadata.codecs, arrayMetadata.coreArrayMetadata);
    }

    public static Array open(StoreHandle storeHandle) throws IOException, ZarrException {
        return new Array(storeHandle, (ArrayMetadata)Array.makeObjectMapper().readValue(Utils.toArray(storeHandle.resolve("zarr.json").readNonNull()), ArrayMetadata.class));
    }

    public static Array create(StoreHandle storeHandle, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        return Array.create(storeHandle, arrayMetadata, false);
    }

    public static Array create(StoreHandle storeHandle, ArrayMetadata arrayMetadata, boolean existsOk) throws IOException, ZarrException {
        StoreHandle metadataHandle = storeHandle.resolve("zarr.json");
        if (!existsOk && metadataHandle.exists()) {
            throw new RuntimeException("Trying to create a new array in " + storeHandle + ". But " + metadataHandle + " already exists.");
        }
        ObjectMapper objectMapper = Array.makeObjectMapper();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectMapper.writeValueAsBytes((Object)arrayMetadata));
        metadataHandle.set(metadataBytes);
        return new Array(storeHandle, arrayMetadata);
    }

    public static Array create(StoreHandle storeHandle, Function<ArrayMetadataBuilder, ArrayMetadataBuilder> arrayMetadataBuilderMapper, boolean existsOk) throws IOException, ZarrException {
        return Array.create(storeHandle, arrayMetadataBuilderMapper.apply(new ArrayMetadataBuilder()).build(), existsOk);
    }

    @Nonnull
    public static ArrayMetadataBuilder metadataBuilder() {
        return new ArrayMetadataBuilder();
    }

    @Nonnull
    public static ArrayMetadataBuilder metadataBuilder(ArrayMetadata existingMetadata) {
        return ArrayMetadataBuilder.fromArrayMetadata(existingMetadata);
    }

    @Override
    public CodecPipeline codecPipeline() {
        return this.codecPipeline;
    }

    @Override
    public ArrayMetadata metadata() {
        return this.metadata;
    }

    private Array writeMetadata(ArrayMetadata newArrayMetadata) throws ZarrException, IOException {
        ObjectMapper objectMapper = Array.makeObjectMapper();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectMapper.writeValueAsBytes((Object)newArrayMetadata));
        this.storeHandle.resolve("zarr.json").set(metadataBytes);
        return new Array(this.storeHandle, newArrayMetadata);
    }

    public Array resize(long[] newShape) throws ZarrException, IOException {
        if (newShape.length != this.metadata.ndim()) {
            throw new IllegalArgumentException("'newShape' needs to have rank '" + this.metadata.ndim() + "'.");
        }
        ArrayMetadata newArrayMetadata = ArrayMetadataBuilder.fromArrayMetadata(this.metadata).withShape(newShape).build();
        return this.writeMetadata(newArrayMetadata);
    }

    public Array setAttributes(Map<String, Object> newAttributes) throws ZarrException, IOException {
        ArrayMetadata newArrayMetadata = ArrayMetadataBuilder.fromArrayMetadata(this.metadata).withAttributes(newAttributes).build();
        return this.writeMetadata(newArrayMetadata);
    }

    public Array updateAttributes(Function<Map<String, Object>, Map<String, Object>> attributeMapper) throws ZarrException, IOException {
        return this.setAttributes(attributeMapper.apply((Map<String, Object>)new HashMap<String, Object>(this.metadata.attributes){}));
    }

    public String toString() {
        return String.format("<v3.Array {%s} (%s) %s>", this.storeHandle, Arrays.stream(this.metadata.shape).mapToObj(Long::toString).collect(Collectors.joining(", ")), this.metadata.dataType);
    }
}

