/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.utils;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;

public class MultiArrayUtils {
    public static void copyRegion(Array source, int[] sourceOffset, Array target, int[] targetOffset, int[] shape) {
        if (sourceOffset.length != targetOffset.length) {
            throw new IllegalArgumentException("'sourceOffset' and 'targetOffset' do not have the same rank.");
        }
        if (source.getRank() != sourceOffset.length) {
            throw new IllegalArgumentException("'sourceOffset' and 'source' do not have the same rank.");
        }
        if (target.getRank() != targetOffset.length) {
            throw new IllegalArgumentException("'targetOffset' and 'target' do not have the same rank.");
        }
        if (shape.length != sourceOffset.length) {
            throw new IllegalArgumentException("'shape' and 'sourceOffset' do not have the same rank.");
        }
        try {
            ArrayList<Range> sourceRanges = new ArrayList<Range>();
            ArrayList<Range> targetRanges = new ArrayList<Range>();
            for (int dimIdx = 0; dimIdx < shape.length; ++dimIdx) {
                if (sourceOffset[dimIdx] + shape[dimIdx] > source.getShape()[dimIdx]) {
                    throw new IllegalArgumentException("'sourceOffset + shape' needs to be less or equal than 'source.getShape()'.");
                }
                if (targetOffset[dimIdx] + shape[dimIdx] > target.getShape()[dimIdx]) {
                    throw new IllegalArgumentException("'targetOffset + shape' needs to be less or equal than 'target.getShape()'.");
                }
                sourceRanges.add(new Range(sourceOffset[dimIdx], sourceOffset[dimIdx] + shape[dimIdx] - 1));
                targetRanges.add(new Range(targetOffset[dimIdx], targetOffset[dimIdx] + shape[dimIdx] - 1));
            }
            IndexIterator sourceRangeIterator = source.getRangeIterator(sourceRanges);
            IndexIterator targetRangeIterator = target.getRangeIterator(targetRanges);
            Class elementType = source.getElementType();
            ValueAccessor accessor = MultiArrayUtils.createValueAccessor(elementType);
            while (sourceRangeIterator.hasNext()) {
                accessor.copy(sourceRangeIterator, targetRangeIterator);
            }
        }
        catch (InvalidRangeException ex) {
            throw new RuntimeException("Unreachable");
        }
    }

    public static Array fill(@Nonnull Array array, @Nonnull Object fillValue) {
        IndexIterator iterator = array.getIndexIterator();
        Class elementType = array.getElementType();
        ValueAccessor accessor = MultiArrayUtils.createValueAccessor(elementType);
        while (iterator.hasNext()) {
            accessor.set(iterator, fillValue);
        }
        return array;
    }

    public static boolean allValuesEqual(Array array, Object value) {
        IndexIterator iterator = array.getIndexIterator();
        Class elementType = array.getElementType();
        ValueAccessor accessor = MultiArrayUtils.createValueAccessor(elementType);
        while (iterator.hasNext()) {
            boolean isEqual = accessor.isEqual(iterator, value);
            if (isEqual) continue;
            return false;
        }
        return true;
    }

    public static boolean allValuesEqual(Array source, Array target) {
        if (!Arrays.equals(source.getShape(), target.getShape())) {
            return false;
        }
        if (!source.getElementType().equals(target.getElementType())) {
            return false;
        }
        IndexIterator sourceIterator = source.getIndexIterator();
        IndexIterator targetIterator = target.getIndexIterator();
        Class elementType = source.getElementType();
        ValueAccessor accessor = MultiArrayUtils.createValueAccessor(elementType);
        while (sourceIterator.hasNext()) {
            boolean isEqual = accessor.isEqual(sourceIterator, targetIterator);
            if (isEqual) continue;
            return false;
        }
        return true;
    }

    static ValueAccessor createValueAccessor(Class elementType) {
        if (elementType == Double.TYPE) {
            return new ValueAccessor(){

                @Override
                public void copy(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    targetIterator.setDoubleNext(sourceIterator.getDoubleNext());
                }

                @Override
                public void set(IndexIterator iterator, Object value) {
                    iterator.setDoubleNext(((Double)value).doubleValue());
                }

                @Override
                public boolean isEqual(IndexIterator iterator, Object value) {
                    return iterator.getDoubleNext() == ((Double)value).doubleValue();
                }

                @Override
                public boolean isEqual(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    return targetIterator.getDoubleNext() == sourceIterator.getDoubleNext();
                }
            };
        }
        if (elementType == Float.TYPE) {
            return new ValueAccessor(){

                @Override
                public void copy(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    targetIterator.setFloatNext(sourceIterator.getFloatNext());
                }

                @Override
                public void set(IndexIterator iterator, Object value) {
                    iterator.setFloatNext(((Float)value).floatValue());
                }

                @Override
                public boolean isEqual(IndexIterator iterator, Object value) {
                    return iterator.getFloatNext() == ((Float)value).floatValue();
                }

                @Override
                public boolean isEqual(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    return targetIterator.getFloatNext() == sourceIterator.getFloatNext();
                }
            };
        }
        if (elementType == Long.TYPE) {
            return new ValueAccessor(){

                @Override
                public void copy(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    targetIterator.setLongNext(sourceIterator.getLongNext());
                }

                @Override
                public void set(IndexIterator iterator, Object value) {
                    iterator.setLongNext(((Long)value).longValue());
                }

                @Override
                public boolean isEqual(IndexIterator iterator, Object value) {
                    return iterator.getLongNext() == ((Long)value).longValue();
                }

                @Override
                public boolean isEqual(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    return targetIterator.getLongNext() == sourceIterator.getLongNext();
                }
            };
        }
        if (elementType == Integer.TYPE) {
            return new ValueAccessor(){

                @Override
                public void copy(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    targetIterator.setIntNext(sourceIterator.getIntNext());
                }

                @Override
                public void set(IndexIterator iterator, Object value) {
                    iterator.setIntNext(((Integer)value).intValue());
                }

                @Override
                public boolean isEqual(IndexIterator iterator, Object value) {
                    return iterator.getIntNext() == ((Integer)value).intValue();
                }

                @Override
                public boolean isEqual(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    return targetIterator.getIntNext() == sourceIterator.getIntNext();
                }
            };
        }
        if (elementType == Short.TYPE) {
            return new ValueAccessor(){

                @Override
                public void copy(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    targetIterator.setShortNext(sourceIterator.getShortNext());
                }

                @Override
                public void set(IndexIterator iterator, Object value) {
                    iterator.setShortNext(((Short)value).shortValue());
                }

                @Override
                public boolean isEqual(IndexIterator iterator, Object value) {
                    return iterator.getShortNext() == ((Short)value).shortValue();
                }

                @Override
                public boolean isEqual(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    return targetIterator.getShortNext() == sourceIterator.getShortNext();
                }
            };
        }
        if (elementType == Byte.TYPE) {
            return new ValueAccessor(){

                @Override
                public void copy(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    targetIterator.setByteNext(sourceIterator.getByteNext());
                }

                @Override
                public void set(IndexIterator iterator, Object value) {
                    iterator.setByteNext(((Byte)value).byteValue());
                }

                @Override
                public boolean isEqual(IndexIterator iterator, Object value) {
                    return iterator.getByteNext() == ((Byte)value).byteValue();
                }

                @Override
                public boolean isEqual(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    return targetIterator.getByteNext() == sourceIterator.getByteNext();
                }
            };
        }
        if (elementType == Boolean.TYPE) {
            return new ValueAccessor(){

                @Override
                public void copy(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    targetIterator.setBooleanNext(sourceIterator.getBooleanNext());
                }

                @Override
                public void set(IndexIterator iterator, Object value) {
                    iterator.setBooleanNext(((Boolean)value).booleanValue());
                }

                @Override
                public boolean isEqual(IndexIterator iterator, Object value) {
                    return iterator.getBooleanNext() == ((Boolean)value).booleanValue();
                }

                @Override
                public boolean isEqual(IndexIterator sourceIterator, IndexIterator targetIterator) {
                    return targetIterator.getBooleanNext() == sourceIterator.getBooleanNext();
                }
            };
        }
        return new ValueAccessor(){

            @Override
            public void copy(IndexIterator sourceIterator, IndexIterator targetIterator) {
                targetIterator.setObjectNext(sourceIterator.getObjectNext());
            }

            @Override
            public void set(IndexIterator iterator, Object value) {
                iterator.setObjectNext(value);
            }

            @Override
            public boolean isEqual(IndexIterator iterator, Object value) {
                return iterator.getObjectNext().equals(value);
            }

            @Override
            public boolean isEqual(IndexIterator sourceIterator, IndexIterator targetIterator) {
                return targetIterator.getObjectNext().equals(sourceIterator.getObjectNext());
            }
        };
    }

    private static interface ValueAccessor {
        public void copy(IndexIterator var1, IndexIterator var2);

        public void set(IndexIterator var1, Object var2);

        public boolean isEqual(IndexIterator var1, Object var2);

        public boolean isEqual(IndexIterator var1, IndexIterator var2);
    }
}

