/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.cmd.CmdCallback;
import omero.cmd.CmdCallbackI;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FilesetData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImage;
import org.openmicroscopy.shoola.agents.events.iviewer.ViewImageObject;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.util.FileImportComponentI;
import org.openmicroscopy.shoola.agents.fsimporter.util.ImportStatus;
import org.openmicroscopy.shoola.env.data.ImportException;
import org.openmicroscopy.shoola.env.data.model.FileObject;
import org.openmicroscopy.shoola.env.data.model.ImportableFile;
import org.openmicroscopy.shoola.env.data.util.Status;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;

public class LightFileImportComponent
implements PropertyChangeListener,
FileImportComponentI {
    private FileImportComponentI.ContainerType type;
    private Object image;
    private boolean reimported;
    private Status status;
    private Map<File, LightFileImportComponent> components;
    private DataObject containerFromFolder;
    private DataObject data;
    private DatasetData dataset;
    private Object refNode;
    private FileImportComponentI parent;
    private ImportStatus resultIndex;
    private int index;
    private CmdCallback callback;
    private ImportableFile importable;
    private Collection<TagAnnotationData> tags;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    private void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(name, oldValue, newValue);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    private void formatResult() {
        Object result = this.status.getImportResult();
        if (this.image instanceof ImportException) {
            result = this.image;
        }
        if (result instanceof ImportException) {
            ImportException e = (ImportException)result;
            int status = e.getStatus();
            this.resultIndex = status == ImportException.CHECKSUM_MISMATCH ? ImportStatus.UPLOAD_FAILURE : (status == ImportException.MISSING_LIBRARY ? ImportStatus.FAILURE_LIBRARY : ImportStatus.FAILURE);
        } else if (result instanceof CmdCallback) {
            this.callback = (CmdCallback)result;
        } else {
            this.resultIndex = ImportStatus.SUCCESS;
        }
    }

    private void cancel(boolean fire) {
        boolean b;
        boolean bl = b = this.status.isCancellable() || this.getFile().isDirectory();
        if (!this.isCancelled() && !this.hasImportFailed() && b && !this.status.isMarkedAsDuplicate()) {
            this.status.markedAsCancel();
            this.firePropertyChange("cancelImport", null, this);
        }
    }

    @Override
    public Collection<? extends FileImportComponentI> getChildren() {
        try {
            return this.components.values();
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    private void initComponents() {
        this.status = new Status(this.importable.getFile());
        this.status.addPropertyChangeListener(this);
        this.image = null;
    }

    private void attachListeners(LightFileImportComponent c) {
        PropertyChangeListener[] listeners = this.getPropertyChangeListeners();
        if (listeners != null && listeners.length > 0) {
            for (int j = 0; j < listeners.length; ++j) {
                c.addPropertyChangeListener(listeners[j]);
            }
        }
    }

    private void insertFiles(Map<File, Status> files) {
        this.resultIndex = ImportStatus.SUCCESS;
        if (files == null || files.size() == 0) {
            return;
        }
        this.components = Collections.synchronizedMap(new HashMap());
        Iterator<Map.Entry<File, Status>> i = files.entrySet().iterator();
        DatasetData d = this.dataset;
        Object node = this.refNode;
        if (this.importable.isFolderAsContainer()) {
            node = null;
            d = new DatasetData();
            d.setName(this.getFile().getName());
        }
        while (i.hasNext()) {
            Map.Entry<File, Status> entry = i.next();
            File f = entry.getKey();
            ImportableFile copy = this.importable.copy();
            copy.setFile(f);
            LightFileImportComponent c = new LightFileImportComponent(copy, this.getIndex(), this.tags);
            if (f.isFile()) {
                c.setLocation(this.data, d, node);
                c.setParent(this);
            }
            c.setType(this.getType());
            this.attachListeners(c);
            c.setStatusLabel(entry.getValue());
            entry.getValue().addPropertyChangeListener(this);
            this.components.put(entry.getKey(), c);
        }
    }

    public LightFileImportComponent(ImportableFile importable, int index, Collection<TagAnnotationData> tags) {
        if (importable == null) {
            throw new IllegalArgumentException("No file specified.");
        }
        if (importable.getGroup() == null) {
            throw new IllegalArgumentException("No group specified.");
        }
        this.index = index;
        this.tags = tags;
        this.importable = importable;
        this.resultIndex = ImportStatus.QUEUED;
        this.initComponents();
        this.setLocation(importable.getParent(), importable.getDataset(), importable.getRefNode());
    }

    @Override
    public FileObject getFile() {
        return this.importable.getFile();
    }

    @Override
    public FileObject getOriginalFile() {
        return this.importable.getOriginalFile();
    }

    @Override
    public void setLocation(DataObject data, DatasetData dataset, Object refNode) {
        this.data = data;
        this.dataset = dataset;
        this.refNode = refNode;
    }

    @Override
    public void setImportLogFile(Collection<FileAnnotationData> data, long id) {
    }

    @Override
    public DatasetData getDataset() {
        return this.dataset;
    }

    @Override
    public DataObject getDataObject() {
        return this.data;
    }

    void setStatusLabel(Status label) {
        this.status = label;
        this.status.addPropertyChangeListener(this);
    }

    void setParent(FileImportComponentI parent) {
        this.parent = parent;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    private FileObject getAssociatedFile(int series) {
        List<FileObject> l = this.getFile().getAssociatedFiles();
        for (FileObject f : l) {
            if (f.getIndex() != series) continue;
            return f;
        }
        return null;
    }

    private boolean hasAssociatedFiles() {
        List<FileObject> l = this.getFile().getAssociatedFiles();
        return CollectionUtils.isNotEmpty(l);
    }

    @Override
    public void setStatus(Object image) {
        this.image = image;
        if (image instanceof Collection) {
            Object obj;
            Collection c = (Collection)image;
            if (!c.isEmpty() && (obj = c.iterator().next()) instanceof PixelsData) {
                this.image = null;
                this.formatResult();
            }
        } else if (image instanceof ImportException) {
            if (this.getFile().isDirectory()) {
                this.image = null;
            } else {
                this.formatResult();
            }
        } else if (image instanceof Boolean && (this.status.isMarkedAsCancel() || this.status.isMarkedAsDuplicate())) {
            this.resultIndex = ImportStatus.IGNORED;
            this.image = null;
        }
        if (this.callback != null) {
            try {
                ((CmdCallbackI)this.callback).close(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileImportComponentI> getImportErrors() {
        ArrayList<FileImportComponentI> l = null;
        if (this.getFile().isFile()) {
            Object r = this.status.getImportResult();
            if (r instanceof Exception || this.image instanceof Exception) {
                l = new ArrayList<FileImportComponentI>();
                l.add(this);
                return l;
            }
        } else if (this.components != null) {
            Collection<LightFileImportComponent> values = this.components.values();
            Map<File, LightFileImportComponent> map = this.components;
            synchronized (map) {
                Iterator<LightFileImportComponent> i = values.iterator();
                l = new ArrayList();
                while (i.hasNext()) {
                    FileImportComponentI fc = i.next();
                    List<FileImportComponentI> list = fc.getImportErrors();
                    if (!CollectionUtils.isNotEmpty(list)) continue;
                    l.addAll(list);
                }
            }
        }
        return l;
    }

    @Override
    public long getGroupID() {
        return this.importable.getGroup().getId();
    }

    @Override
    public long getExperimenterID() {
        return this.importable.getUser().getId();
    }

    @Override
    public ImportErrorObject getImportErrorObject() {
        FilesetData data;
        Object r = this.status.getImportResult();
        Exception e = null;
        if (r instanceof Exception) {
            e = (Exception)r;
        } else if (this.image instanceof Exception) {
            e = (Exception)this.image;
        }
        if (e == null) {
            return null;
        }
        ImportErrorObject object = new ImportErrorObject(this.getFile().getTrueFile(), e, this.getGroupID());
        object.setImportContainer(this.status.getImportContainer());
        long id = this.status.getLogFileID();
        if (id <= 0L && (data = this.status.getFileset()) != null) {
            id = data.getId();
            object.setRetrieveFromAnnotation(true);
        }
        object.setLogFileID(id);
        return object;
    }

    @Override
    public boolean hasImportFailed() {
        return this.resultIndex == ImportStatus.FAILURE || this.resultIndex == ImportStatus.UPLOAD_FAILURE;
    }

    @Override
    public boolean hasUploadFailed() {
        return this.resultIndex == ImportStatus.UPLOAD_FAILURE || this.resultIndex == ImportStatus.FAILURE && !this.status.didUploadStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        boolean b = this.status.isMarkedAsCancel();
        if (b || this.getFile().isFile()) {
            return b;
        }
        if (this.components == null) {
            return false;
        }
        Collection<LightFileImportComponent> values = this.components.values();
        Map<File, LightFileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<LightFileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                if (!i.next().isCancelled()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasImportToCancel() {
        boolean b = this.status.isMarkedAsCancel();
        if (b) {
            return false;
        }
        if (this.getFile().isFile() && !this.hasImportStarted()) {
            return true;
        }
        if (this.components == null) {
            return false;
        }
        Collection<LightFileImportComponent> values = this.components.values();
        Map<File, LightFileImportComponent> map = this.components;
        synchronized (map) {
            for (FileImportComponentI fileImportComponentI : values) {
                if (fileImportComponentI.isCancelled() || fileImportComponentI.hasImportStarted()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFailuresToReimport() {
        if (this.getFile().isFile()) {
            return this.hasUploadFailed() && !this.reimported;
        }
        if (this.components == null) {
            return false;
        }
        Collection<LightFileImportComponent> values = this.components.values();
        Map<File, LightFileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<LightFileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                if (!i.next().hasUploadFailed()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFailuresToReupload() {
        if (this.getFile().isFile()) {
            return this.hasUploadFailed() && !this.reimported;
        }
        if (this.components == null) {
            return false;
        }
        Collection<LightFileImportComponent> values = this.components.values();
        Map<File, LightFileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<LightFileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                if (!i.next().hasFailuresToReupload()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasImportStarted() {
        if (this.getFile().isFile()) {
            return this.resultIndex != ImportStatus.QUEUED;
        }
        if (this.components == null) {
            return false;
        }
        Map<File, LightFileImportComponent> map = this.components;
        synchronized (map) {
            for (LightFileImportComponent c : this.components.values()) {
                if (c.hasImportStarted()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFailuresToSend() {
        if (this.getFile().isFile()) {
            return this.resultIndex == ImportStatus.FAILURE;
        }
        if (this.components == null) {
            return false;
        }
        Collection<LightFileImportComponent> values = this.components.values();
        Map<File, LightFileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<LightFileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                if (!i.next().hasFailuresToSend()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasComponents() {
        return this.components != null && this.components.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportStatus getImportStatus() {
        if (this.getFile().isFile()) {
            if (this.hasImportFailed()) {
                return ImportStatus.FAILURE;
            }
            return this.resultIndex;
        }
        if (this.components == null || this.components.size() == 0) {
            if (this.image instanceof Boolean) {
                if (this.getFile().isDirectory()) {
                    return ImportStatus.SUCCESS;
                }
                if (!this.status.isMarkedAsCancel() && !this.status.isMarkedAsDuplicate()) {
                    return ImportStatus.FAILURE;
                }
            }
            return this.resultIndex;
        }
        Collection<LightFileImportComponent> values = this.components.values();
        int n = this.components.size();
        int count = 0;
        Map<File, LightFileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<LightFileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                if (!i.next().hasImportFailed()) continue;
                ++count;
            }
        }
        if (count == n) {
            return ImportStatus.FAILURE;
        }
        if (count > 0) {
            return ImportStatus.PARTIAL;
        }
        return ImportStatus.SUCCESS;
    }

    @Override
    public boolean hasToRefreshTree() {
        if (this.getFile().isFile()) {
            if (this.hasImportFailed()) {
                return false;
            }
            switch (this.type) {
                case PROJECT: 
                case NA: {
                    return true;
                }
            }
            return false;
        }
        if (this.components == null) {
            return false;
        }
        if (this.importable.isFolderAsContainer() && this.type != FileImportComponentI.ContainerType.PROJECT) {
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelLoading() {
        if (this.components == null || this.components.isEmpty()) {
            this.cancel(this.getFile().isFile());
            return;
        }
        Collection<LightFileImportComponent> values = this.components.values();
        Map<File, LightFileImportComponent> map = this.components;
        synchronized (map) {
            Iterator<LightFileImportComponent> i = values.iterator();
            while (i.hasNext()) {
                i.next().cancelLoading();
            }
        }
    }

    @Override
    public void setType(FileImportComponentI.ContainerType type) {
        this.type = type;
    }

    @Override
    public FileImportComponentI.ContainerType getType() {
        return this.type;
    }

    @Override
    public boolean isFolderAsContainer() {
        return this.importable.isFolderAsContainer();
    }

    @Override
    public DataObject getContainerFromFolder() {
        return this.containerFromFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FileImportComponentI> getFilesToReupload() {
        ArrayList<FileImportComponentI> l = null;
        if (this.getFile().isFile()) {
            if (this.hasFailuresToReupload() && !this.reimported) {
                ArrayList<FileImportComponentI> ret = new ArrayList<FileImportComponentI>();
                ret.add(this);
                return ret;
            }
        } else if (this.components != null) {
            Collection<LightFileImportComponent> values = this.components.values();
            Map<File, LightFileImportComponent> map = this.components;
            synchronized (map) {
                Iterator<LightFileImportComponent> i = values.iterator();
                l = new ArrayList<FileImportComponentI>();
                while (i.hasNext()) {
                    FileImportComponentI fc = i.next();
                    List<FileImportComponentI> list = fc.getFilesToReupload();
                    if (CollectionUtils.isEmpty(list)) continue;
                    l.addAll(list);
                }
            }
        }
        return l;
    }

    @Override
    public void setReimported(boolean reimported) {
        this.reimported = reimported;
    }

    @Override
    public void uploadComplete(Object result) {
        if (result instanceof CmdCallback) {
            this.callback = (CmdCallback)result;
        }
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Object getImportResult() {
        return this.status.getImportResult();
    }

    @Override
    public boolean isHCS() {
        return this.status.isHCS();
    }

    @Override
    public long getImportSize() {
        return this.status.getSizeUpload();
    }

    @Override
    public boolean hasResult() {
        return this.image != null;
    }

    @Override
    public ImportableFile getImportableFile() {
        return this.importable;
    }

    @Override
    public void onResultsSaving(String message, boolean busy) {
    }

    @Override
    public void propagateSuccessfulOfflineImportStatus() {
    }

    @Override
    public void propagateOfflineImportFailureStatus(Exception cause) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("scanning".equals(name)) {
            this.firePropertyChange("scanning", evt.getOldValue(), evt.getNewValue());
        } else if ("filesSet".equals(name)) {
            if (this.isCancelled()) {
                return;
            }
            Map files = (Map)evt.getNewValue();
            int n = files.size();
            this.insertFiles(files);
            this.firePropertyChange("importFilesNumber", null, n);
        } else if ("fileImportStarted".equals(name)) {
            this.resultIndex = ImportStatus.STARTED;
            Status sl = (Status)evt.getNewValue();
            if (sl.equals(this.status)) {
                this.firePropertyChange("fileImportStarted", null, this);
            }
        } else if ("uploadDone".equals(name)) {
            Status sl = (Status)evt.getNewValue();
            if (sl.equals(this.status) && this.hasParent()) {
                if (sl.isMarkedAsCancel()) {
                    this.cancel(true);
                } else {
                    this.formatResult();
                    this.firePropertyChange("uploadDone", null, this);
                }
            }
        } else if ("fileReset".equals(name)) {
            this.importable.setFile((File)evt.getNewValue());
        } else if ("browsePlate".equals(name)) {
            this.firePropertyChange("browse", evt.getOldValue(), evt.getNewValue());
        } else if ("containerFromFolder".equals(name)) {
            this.containerFromFolder = (DataObject)evt.getNewValue();
        } else if ("debugText".equals(name)) {
            this.firePropertyChange(name, evt.getOldValue(), evt.getNewValue());
        } else if ("viewImage".equals(name)) {
            SecurityContext ctx = new SecurityContext(this.importable.getGroup().getId());
            EventBus bus = ImporterAgent.getRegistry().getEventBus();
            Long id = (Long)evt.getNewValue();
            bus.post(new ViewImage(ctx, new ViewImageObject(id), null));
        } else if ("importDone".equals(name) || "processingError".equals(name)) {
            Status sl = (Status)evt.getNewValue();
            if (sl.equals(this.status)) {
                this.firePropertyChange("importDone", null, this);
            }
        } else if ("step".equals(name)) {
            this.firePropertyChange("step", evt.getOldValue(), evt.getNewValue());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getFile().getAbsolutePath());
        if (this.importable.getGroup() != null) {
            buf.append("_" + this.importable.getGroup().getId());
        }
        if (this.importable.getUser() != null) {
            buf.append("_" + this.importable.getUser().getId());
        }
        return buf.toString();
    }
}

