/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.RatingAnnotationData;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.util.ui.RatingComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class RatingTaskPaneUI
extends AnnotationTaskPaneUI
implements PropertyChangeListener {
    private RatingComponent rating;
    private JLabel otherRating;
    private int originalValue = 0;
    private int selectedValue = 0;

    public RatingTaskPaneUI(EditorModel model, EditorUI view, EditorControl controller) {
        super(model, view, controller);
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.rating = new RatingComponent(this.originalValue, 1);
        this.rating.setOpaque(false);
        this.rating.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.rating.addPropertyChangeListener(this);
        this.add(this.rating);
        this.add(Box.createHorizontalStrut(2));
        this.otherRating = new JLabel();
        this.otherRating.setBackground(UIUtilities.BACKGROUND_COLOR);
        Font font = this.otherRating.getFont();
        this.otherRating.setFont(font.deriveFont(2, font.getSize() - 2));
        this.add(this.otherRating);
    }

    @Override
    void clearDisplay() {
        this.originalValue = 0;
        this.selectedValue = 0;
        this.rating.removePropertyChangeListener(this);
        this.rating.setValue(this.originalValue);
        this.rating.addPropertyChangeListener(this);
        this.otherRating.setText("");
        this.otherRating.setVisible(false);
    }

    @Override
    void refreshUI() {
        this.clearDisplay();
        StringBuilder buffer = new StringBuilder();
        if (!this.model.isMultiSelection()) {
            this.originalValue = this.model.getUserRating();
            int n = this.model.getRatingCount(0);
            if (n > 0) {
                buffer.append("(avg:" + this.model.getRatingAverage(0) + " | " + n + " vote");
                if (n > 1) {
                    buffer.append("s");
                }
                buffer.append(")");
            }
            this.otherRating.setVisible(n > 0);
        } else {
            this.originalValue = this.model.getRatingAverage(1);
            int n = this.model.getRatingCount(1);
            if (n > 0) {
                buffer.append("out of " + n);
                buffer.append(" rating");
                if (n > 1) {
                    buffer.append("s");
                }
            }
            this.otherRating.setVisible(true);
        }
        this.selectedValue = this.originalValue;
        this.otherRating.setText(buffer.toString());
        this.rating.removePropertyChangeListener(this);
        this.rating.setValue(this.originalValue);
        this.rating.addPropertyChangeListener(this);
        this.rating.setEnabled(this.model.canAnnotate());
    }

    @Override
    List<JButton> getToolbarButtons() {
        ArrayList<JButton> buttons = new ArrayList<JButton>();
        IconManager icons = IconManager.getInstance();
        JButton unrateButton = new JButton(icons.getIcon(57));
        UIUtilities.unifiedButtonLookAndFeel(unrateButton);
        unrateButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        unrateButton.setToolTipText("Delete rating");
        unrateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RatingTaskPaneUI.this.rating.setValue(0);
                RatingTaskPaneUI.this.view.saveData(true);
            }
        });
        buttons.add(unrateButton);
        return buttons;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("rate".equals(name)) {
            int newValue = (Integer)evt.getNewValue();
            if (newValue != this.selectedValue) {
                this.selectedValue = newValue;
                this.view.saveData(true);
            }
        } else if ("rateEnd".equals(name)) {
            this.view.saveData(true);
        }
    }

    @Override
    List<AnnotationData> getAnnotationsToSave() {
        if (this.selectedValue != this.originalValue) {
            RatingAnnotationData ra = this.model.getUserRatingData();
            if (ra == null) {
                ra = new RatingAnnotationData(this.selectedValue);
            } else {
                ra.setRating(this.selectedValue);
            }
            return Collections.singletonList(ra);
        }
        return Collections.emptyList();
    }

    @Override
    List<Object> getAnnotationsToRemove() {
        RatingAnnotationData rating;
        if (this.selectedValue != this.originalValue && this.selectedValue == 0 && (rating = this.model.getUserRatingAnnotation()) != null) {
            return Collections.singletonList(rating);
        }
        return Collections.emptyList();
    }

    @Override
    void onRelatedNodesSet() {
        this.rating.setEnabled(this.model.canAddAnnotationLink());
    }

    @Override
    int getUnfilteredAnnotationCount() {
        if (this.model.isMultiSelection()) {
            return this.model.getRatingCount(1);
        }
        return this.model.getRatingCount(0);
    }
}

