/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class StructuredAnnotationLoader
extends BatchCallTree {
    public static final int RATING = 10;
    public static final int ROI_MEASUREMENT = 11;
    public static final int ALL = 1;
    public static final int SINGLE = 2;
    private Object result;
    private BatchCall loadCall;
    private SecurityContext ctx;

    private BatchCall loadSpeficiedAnnotationLinkedTo(final Class<? extends DataObject> rootType, final List<Long> rootIDs, final Class<?> annotationType, final List<String> nsInclude, final List<String> nsExlcude) {
        return new BatchCall("Loading Specified Annotation"){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadAnnotations(StructuredAnnotationLoader.this.ctx, rootType, rootIDs, annotationType, nsInclude, nsExlcude);
            }
        };
    }

    private BatchCall loadAnnotations(final Class annotationType, final long userID) {
        return new BatchCall("Loading Existing Annotations"){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadAnnotations(StructuredAnnotationLoader.this.ctx, annotationType, null, userID);
            }
        };
    }

    private BatchCall loadAnnotations(final List<SecurityContext> ctx, final Class annotationType, final long userID) {
        return new BatchCall("Loading Existing Annotations"){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                Iterator i = ctx.iterator();
                ArrayList l = new ArrayList();
                while (i.hasNext()) {
                    l.addAll(os.loadAnnotations((SecurityContext)i.next(), annotationType, null, userID));
                }
                StructuredAnnotationLoader.this.result = l;
            }
        };
    }

    private BatchCall loadRatings(final Class type, final long id, final long userID) {
        return new BatchCall("Loading Ratings"){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadRatings(StructuredAnnotationLoader.this.ctx, type, id, userID);
            }
        };
    }

    private BatchCall loadROIMeasurements(final Class type, final long id, final long userID) {
        return new BatchCall("Loading Measurements"){

            @Override
            public void doCall() throws Exception {
                OmeroImageService os = StructuredAnnotationLoader.this.context.getImageService();
                StructuredAnnotationLoader.this.result = os.loadROIMeasurements(StructuredAnnotationLoader.this.ctx, type, id, userID);
            }
        };
    }

    private BatchCall loadStructuredData(final Object object, final long userID) {
        return new BatchCall("Loading Structured Data"){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadStructuredData(StructuredAnnotationLoader.this.ctx, object, userID, true);
            }
        };
    }

    private BatchCall loadStructuredData(final List<DataObject> data, final long userID, final boolean viewed) {
        return new BatchCall("Loading Structured Data"){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadStructuredData(StructuredAnnotationLoader.this.ctx, data, userID, viewed);
            }
        };
    }

    private BatchCall loadAnnotation(final long annotationID) {
        return new BatchCall("Loading Annotation"){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadAnnotation(StructuredAnnotationLoader.this.ctx, annotationID);
            }
        };
    }

    private BatchCall loadRatings(final Class type, final List<Long> ids, final long userID) {
        return new BatchCall("Loading Ratings"){

            @Override
            public void doCall() throws Exception {
                OmeroMetadataService os = StructuredAnnotationLoader.this.context.getMetadataService();
                StructuredAnnotationLoader.this.result = os.loadRatings(StructuredAnnotationLoader.this.ctx, type, ids, userID);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public StructuredAnnotationLoader(SecurityContext ctx, int index, Class type, List<Long> ids, long userID) {
        this.ctx = ctx;
        switch (index) {
            case 10: {
                this.loadCall = this.loadRatings(type, ids, userID);
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    public StructuredAnnotationLoader(SecurityContext ctx, int index, List<DataObject> data, long userID, boolean viewed) {
        this.ctx = ctx;
        switch (index) {
            case 1: {
                this.loadCall = this.loadStructuredData(data, userID, viewed);
            }
        }
    }

    public StructuredAnnotationLoader(SecurityContext ctx, int index, Object object, long userID) {
        if (object == null) {
            throw new IllegalArgumentException("Object not defined.");
        }
        this.ctx = ctx;
        switch (index) {
            case 1: {
                this.loadCall = this.loadStructuredData(object, userID);
                break;
            }
            case 10: {
                if (!(object instanceof DataObject)) break;
                DataObject ho = (DataObject)object;
                this.loadCall = this.loadRatings(object.getClass(), ho.getId(), userID);
                break;
            }
            case 11: {
                DataObject ho = (DataObject)object;
                this.loadCall = this.loadROIMeasurements(object.getClass(), ho.getId(), userID);
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    public StructuredAnnotationLoader(SecurityContext ctx, Class annotationType, long userID) {
        this.ctx = ctx;
        this.loadCall = this.loadAnnotations(annotationType, userID);
    }

    public StructuredAnnotationLoader(SecurityContext ctx, long annotationID) {
        this.ctx = ctx;
        this.loadCall = this.loadAnnotation(annotationID);
    }

    public StructuredAnnotationLoader(List<SecurityContext> ctx, Class annotationType, long userID) {
        this.loadCall = this.loadAnnotations(ctx, annotationType, userID);
    }

    public StructuredAnnotationLoader(SecurityContext ctx, Class<? extends DataObject> rootType, List<Long> rootIDs, Class<?> annotationType, List<String> nsInclude, List<String> nsExlcude) {
        this.ctx = ctx;
        this.loadCall = this.loadSpeficiedAnnotationLinkedTo(rootType, rootIDs, annotationType, nsInclude, nsExlcude);
    }
}

