/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourChangedEvent;
import org.openmicroscopy.shoola.util.ui.colourpicker.HSVWheelListener;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBControl;

class HSVWheel
extends JPanel {
    private static final Stroke LINE = new BasicStroke(1.0f);
    private static final Color LINE_COLOR = Color.BLACK;
    private BufferedImage img;
    private float wheelwidth;
    private float radius;
    private PlanePoint puck;
    private Color puckColour;
    private Color puckfillColour;
    private int[][][] lut;
    private List<ChangeListener> listeners;
    private RGBControl control;
    private HSVWheelListener mouselistener;

    private void createColourWheelFromLUT() {
        if (this.img == null) {
            return;
        }
        int sz = (int)this.radius;
        float szsz = sz * sz;
        float value = this.control.getValue();
        for (int x = sz; x > -sz; --x) {
            for (int y = sz; y > -sz; --y) {
                if (!((float)(x * x + y * y) < szsz)) continue;
                this.img.setRGB(sz + x, sz + y, Factory.makeARGB((int)(this.control.getAlpha() * 255.0f), (int)((float)this.lut[x + sz][y + sz][0] * value), (int)((float)this.lut[x + sz][y + sz][1] * value), (int)((float)this.lut[x + sz][y + sz][2] * value)));
            }
        }
    }

    private void buildComponents() {
        int sz = (int)this.radius;
        float szsz = sz * sz;
        float value = 1.0f;
        float fsz = sz;
        for (int x = sz; x > -sz; --x) {
            block9: for (int y = sz; y > -sz; --y) {
                if (!((float)(x * x + y * y) < szsz)) continue;
                float s = (float)Math.sqrt(x * x + y * y);
                float xd = (float)x / fsz;
                float yd = (float)y / fsz;
                float sd = s / fsz;
                float angle = sd != 0.0f ? (float)Math.toDegrees(Math.acos(xd / sd)) : 90.0f;
                if (yd < 0.0f) {
                    angle = 360.0f - angle;
                }
                int hi = (int)angle / 60 % 6;
                switch (hi) {
                    case 0: {
                        float f = angle / 60.0f - (float)hi;
                        float p = value * (1.0f - sd);
                        float t = value * (1.0f - (1.0f - f) * sd);
                        this.lut[x + sz][y + sz][0] = (int)(value * 255.0f);
                        this.lut[x + sz][y + sz][1] = (int)(t * 255.0f);
                        this.lut[x + sz][y + sz][2] = (int)(p * 255.0f);
                        continue block9;
                    }
                    case 1: {
                        float f = angle / 60.0f - (float)hi;
                        float p = value * (1.0f - sd);
                        float q = value * (1.0f - f * sd);
                        this.lut[x + sz][y + sz][0] = (int)(q * 255.0f);
                        this.lut[x + sz][y + sz][1] = (int)(value * 255.0f);
                        this.lut[x + sz][y + sz][2] = (int)(p * 255.0f);
                        continue block9;
                    }
                    case 2: {
                        float f = angle / 60.0f - (float)hi;
                        float p = value * (1.0f - sd);
                        float t = value * (1.0f - (1.0f - f) * sd);
                        this.lut[x + sz][y + sz][0] = (int)(p * 255.0f);
                        this.lut[x + sz][y + sz][1] = (int)(value * 255.0f);
                        this.lut[x + sz][y + sz][2] = (int)(t * 255.0f);
                        continue block9;
                    }
                    case 3: {
                        float f = angle / 60.0f - (float)hi;
                        float p = value * (1.0f - sd);
                        float q = value * (1.0f - f * sd);
                        this.lut[x + sz][y + sz][0] = (int)(p * 255.0f);
                        this.lut[x + sz][y + sz][1] = (int)(q * 255.0f);
                        this.lut[x + sz][y + sz][2] = (int)(value * 255.0f);
                        continue block9;
                    }
                    case 4: {
                        float f = angle / 60.0f - (float)hi;
                        float p = value * (1.0f - sd);
                        float t = value * (1.0f - (1.0f - f) * sd);
                        this.lut[x + sz][y + sz][0] = (int)(t * 255.0f);
                        this.lut[x + sz][y + sz][1] = (int)(p * 255.0f);
                        this.lut[x + sz][y + sz][2] = (int)(value * 255.0f);
                        continue block9;
                    }
                    case 5: {
                        float f = angle / 60.0f - (float)hi;
                        float p = value * (1.0f - sd);
                        float q = value * (1.0f - f * sd);
                        this.lut[x + sz][y + sz][0] = (int)(value * 255.0f);
                        this.lut[x + sz][y + sz][1] = (int)(p * 255.0f);
                        this.lut[x + sz][y + sz][2] = (int)(q * 255.0f);
                    }
                }
            }
        }
    }

    private void render(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Ellipse2D.Float ellipse = new Ellipse2D.Float(1.0f, 1.0f, this.wheelwidth - 2.0f, this.wheelwidth - 2.0f);
        Color c = this.getBackground();
        g.setColor(LINE_COLOR);
        g.draw(ellipse);
        g.setColor(c);
        g.drawImage(this.img, 0, 0, (int)this.wheelwidth, (int)this.wheelwidth, null);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.puck == null) {
            return;
        }
        g.setStroke(LINE);
        g.setPaint(this.puckfillColour);
        g.fillRect((int)this.puck.x1 - 2, (int)this.puck.x2 - 2, 4, 4);
        g.setPaint(this.puckColour);
        g.drawRect((int)this.puck.x1 - 2, (int)this.puck.x2 - 2, 4, 4);
    }

    private void buildLUT() {
        this.lut = new int[(int)this.wheelwidth][(int)this.wheelwidth][3];
        this.buildComponents();
    }

    private void fireChangeEvent() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).stateChanged(new ColourChangedEvent(this));
        }
    }

    private void changePanelSize() {
        this.wheelwidth = this.getWidth() < this.getHeight() ? (float)this.getWidth() : (float)this.getHeight();
        this.radius = this.wheelwidth / 2.0f;
        this.puckColour = Color.black;
        this.puckfillColour = Color.white;
        this.img = new BufferedImage((int)this.wheelwidth, (int)this.wheelwidth, 2);
        this.buildLUT();
        this.createColourWheelFromLUT();
        this.findPuck();
    }

    HSVWheel(RGBControl c) {
        if (c == null) {
            throw new NullPointerException("No control.");
        }
        this.control = c;
        this.radius = 1.0f;
        this.puck = new PlanePoint(this.radius, this.radius);
        this.mouselistener = new HSVWheelListener(this);
        this.addMouseListener(this.mouselistener);
        this.addMouseMotionListener(this.mouselistener);
        this.listeners = new ArrayList<ChangeListener>();
    }

    void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    float getHue() {
        double x = this.puck.x1 - (double)this.radius;
        double y = this.puck.x2 - (double)this.radius;
        double s = Math.sqrt(x * x + y * y);
        double xd = x / (double)this.radius;
        double yd = y / (double)this.radius;
        double sd = s / (double)this.radius;
        if (x == 0.0 && y == 0.0) {
            return 0.0f;
        }
        double angle = sd != 0.0 ? (double)((float)Math.toDegrees(Math.acos(xd / sd))) : 90.0;
        if (yd < 0.0) {
            angle = 360.0 - angle;
        }
        return (float)angle / 360.0f;
    }

    float getSaturation() {
        double x = this.puck.x1 - (double)this.radius;
        double y = this.puck.x2 - (double)this.radius;
        double s = Math.sqrt(x * x + y * y);
        return (float)s / this.radius;
    }

    boolean picked(int x, int y) {
        float dx = (float)x - this.radius;
        float dx2 = dx * dx;
        float dy = (float)y - this.radius;
        float dy2 = dy * dy;
        float dist = dx2 + dy2;
        float r2 = this.radius * this.radius;
        if (dist <= r2) {
            this.puck = new PlanePoint(x, y);
            return true;
        }
        return false;
    }

    void mouseDown(int x, int y) {
        if (this.picked(x, y)) {
            this.fireChangeEvent();
        }
    }

    void mouseDrag(int x, int y) {
        if (this.picked(x, y)) {
            this.fireChangeEvent();
        }
    }

    void findPuck() {
        float h = this.control.getHue() * 360.0f;
        float s = this.control.getSaturation();
        double x = (double)s * Math.cos(Math.toRadians(h));
        double y = (double)s * Math.sin(Math.toRadians(h));
        if (s != 0.0f) {
            this.puck.x1 = x * (double)this.radius + (double)this.radius;
            this.puck.x2 = y * (double)this.radius + (double)this.radius;
        } else {
            this.puck.x1 = this.radius;
            this.puck.x2 = this.radius;
        }
    }

    void refresh() {
        this.createColourWheelFromLUT();
    }

    @Override
    public void setBounds(int x, int y, int h, int w) {
        super.setBounds(x, y, w, h);
        this.changePanelSize();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.changePanelSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.render((Graphics2D)g);
    }
}

