/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import omero.IllegalArgumentException;
import omero.gateway.SecurityContext;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.facility.ROIFacility;
import omero.gateway.facility.TablesFacility;
import omero.gateway.model.DatasetData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import omero.gateway.model.MaskData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ROIData;
import omero.gateway.model.TableData;
import omero.gateway.model.TableDataColumn;
import omero.gateway.model.WellData;
import omero.grid.BoolColumn;
import omero.grid.Column;
import omero.grid.Data;
import omero.grid.DatasetColumn;
import omero.grid.DoubleArrayColumn;
import omero.grid.DoubleColumn;
import omero.grid.FileColumn;
import omero.grid.FloatArrayColumn;
import omero.grid.ImageColumn;
import omero.grid.LongArrayColumn;
import omero.grid.LongColumn;
import omero.grid.MaskColumn;
import omero.grid.PlateColumn;
import omero.grid.RoiColumn;
import omero.grid.StringColumn;
import omero.grid.WellColumn;
import omero.model.FileAnnotationI;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.OriginalFile;
import omero.model.OriginalFileI;
import omero.model.Plate;
import omero.model.PlateI;
import omero.model.RoiI;
import omero.model.WellI;

public class TablesFacilityHelper {
    private Object[][] dataArray;
    private int nCols;
    private int nRows;
    private Column[] gridColumns;
    private TablesFacility fac;
    private SecurityContext ctx;

    TablesFacilityHelper(TablesFacility fac, SecurityContext ctx) {
        this.fac = fac;
        this.ctx = ctx;
    }

    void parseTableData(TableData data) {
        if (data == null) {
            return;
        }
        TableDataColumn[] columns = data.getColumns() != null ? data.getColumns() : new TableDataColumn[]{};
        this.gridColumns = new Column[data.getColumns().length];
        for (int i = 0; i < data.getColumns().length; ++i) {
            String cname = columns.length > i ? columns[i].getName() : "";
            String desc = columns.length > i ? columns[i].getDescription() : "";
            Object[] d = data.getData().length > i ? data.getData()[i] : new Object[]{};
            this.gridColumns[i] = this.createColumn(cname, desc, data.getColumns()[i].getType(), d);
        }
    }

    void parseData(Data data, TableDataColumn[] header) {
        if (data == null || header == null) {
            return;
        }
        if (header.length != data.columns.length) {
            throw new IllegalArgumentException("Number of column definitions must match the number of columns of the table");
        }
        this.nCols = data.columns.length;
        this.nRows = data.rowNumbers.length;
        this.dataArray = new Object[this.nCols][this.nRows];
        BrowseFacility b = null;
        ROIFacility r = null;
        try {
            b = this.fac.gateway.getFacility(BrowseFacility.class);
            r = this.fac.gateway.getFacility(ROIFacility.class);
        }
        catch (ExecutionException e) {
            this.fac.logWarn(this, "Can't get references to Facilities. Objects might be unloaded.", e);
        }
        for (int i = 0; i < data.columns.length; ++i) {
            Number[] tmp;
            int j;
            Object tableData;
            Object[] rowData;
            Column col = data.columns[i];
            if (col instanceof BoolColumn) {
                rowData = new Boolean[this.nRows];
                tableData = ((BoolColumn)col).values;
                for (j = 0; j < this.nRows; ++j) {
                    rowData[j] = tableData[j];
                }
                this.dataArray[i] = rowData;
                header[i].setType(Boolean.class);
            }
            if (col instanceof DoubleArrayColumn) {
                rowData = new Double[this.nRows][];
                tableData = ((DoubleArrayColumn)col).values;
                for (j = 0; j < this.nRows; ++j) {
                    tmp = new Double[((boolean)tableData[j]).length];
                    for (int k = 0; k < ((boolean)tableData[j]).length; ++k) {
                        tmp[k] = (double)tableData[j][k];
                    }
                    rowData[j] = tmp;
                }
                this.dataArray[i] = rowData;
                header[i].setType(Double[].class);
            }
            if (col instanceof DoubleColumn) {
                rowData = new Double[this.nRows];
                tableData = ((DoubleColumn)col).values;
                for (j = 0; j < this.nRows; ++j) {
                    rowData[j] = (double)tableData[j];
                }
                this.dataArray[i] = rowData;
                header[i].setType(Double.class);
            }
            if (col instanceof FileColumn) {
                rowData = new FileAnnotationData[this.nRows];
                tableData = ((FileColumn)col).values;
                for (j = 0; j < this.nRows; ++j) {
                    FileAnnotationI fa = new FileAnnotationI();
                    fa.setFile(new OriginalFileI(tableData[j], false));
                    rowData[j] = new FileAnnotationData(fa);
                    if (b == null) continue;
                    try {
                        fa = new FileAnnotationI();
                        OriginalFile tmp2 = new OriginalFileI(tableData[j], false);
                        tmp2 = (OriginalFile)b.findIObject(this.ctx, tmp2);
                        fa.setFile(tmp2);
                        rowData[j] = new FileAnnotationData(fa);
                        continue;
                    }
                    catch (Exception e) {
                        this.fac.logWarn(this, "Can't load object.", e);
                    }
                }
                this.dataArray[i] = rowData;
                header[i].setType(FileAnnotationData.class);
            }
            if (col instanceof FloatArrayColumn) {
                rowData = new Float[this.nRows][];
                tableData = ((FloatArrayColumn)col).values;
                for (j = 0; j < this.nRows; ++j) {
                    tmp = new Float[((boolean)tableData[j]).length];
                    for (int k = 0; k < ((boolean)tableData[j]).length; ++k) {
                        tmp[k] = Float.valueOf((float)tableData[j][k]);
                    }
                    rowData[j] = tmp;
                }
                this.dataArray[i] = rowData;
                header[i].setType(Float[].class);
            }
            if (col instanceof ImageColumn) {
                rowData = new ImageData[this.nRows];
                tableData = ((ImageColumn)col).values;
                for (j = 0; j < this.nRows; ++j) {
                    ImageI im = new ImageI(tableData[j], false);
                    rowData[j] = new ImageData(im);
                    if (b == null) continue;
                    try {
                        rowData[j] = new ImageData((Image)b.findIObject(this.ctx, im));
                        continue;
                    }
                    catch (Exception e) {
                        this.fac.logWarn(this, "Can't load object.", e);
                    }
                }
                this.dataArray[i] = rowData;
                header[i].setType(ImageData.class);
            }
            if (col instanceof DatasetColumn) {
                this.fac.logWarn(this, "DatasetColumn not supported yet.", null);
            }
            if (col instanceof LongArrayColumn) {
                rowData = new Long[this.nRows][];
                tableData = ((LongArrayColumn)col).values;
                for (j = 0; j < this.nRows; ++j) {
                    tmp = new Long[((boolean)tableData[j]).length];
                    for (int k = 0; k < ((boolean)tableData[j]).length; ++k) {
                        tmp[k] = (long)tableData[j][k];
                    }
                    rowData[j] = tmp;
                }
                this.dataArray[i] = rowData;
                header[i].setType(Long[].class);
            }
            if (col instanceof LongColumn) {
                rowData = new Long[this.nRows];
                tableData = ((LongColumn)col).values;
                for (j = 0; j < this.nRows; ++j) {
                    rowData[j] = (long)tableData[j];
                }
                this.dataArray[i] = rowData;
                header[i].setType(Long.class);
            }
            if (col instanceof MaskColumn) {
                MaskColumn mc = (MaskColumn)col;
                MaskData[] rowData2 = new MaskData[this.nRows];
                for (j = 0; j < this.nRows; ++j) {
                    double x = j < mc.x.length ? mc.x[j] : -1.0;
                    double y = j < mc.y.length ? mc.y[j] : -1.0;
                    double w = j < mc.w.length ? mc.w[j] : -1.0;
                    double h = j < mc.h.length ? mc.h[j] : -1.0;
                    byte[] d = j < mc.bytes.length ? mc.bytes[j] : new byte[]{};
                    MaskData md = new MaskData(x, y, w, h, d);
                    if (j < mc.theZ.length) {
                        md.setZ(mc.theZ[j]);
                    }
                    if (j < mc.theT.length) {
                        md.setT(mc.theT[j]);
                    }
                    if (b != null && j < mc.imageId.length && mc.imageId[j] >= 0L) {
                        try {
                            md.setImage(new ImageData((Image)b.findIObject(this.ctx, new ImageI(mc.imageId[j], false))));
                        }
                        catch (Exception e) {
                            this.fac.logWarn(this, "Can't load object.", e);
                        }
                    }
                    rowData2[j] = md;
                }
                this.dataArray[i] = rowData2;
                header[i].setType(MaskData.class);
            }
            if (col instanceof PlateColumn) {
                rowData = new PlateData[this.nRows];
                tableData = ((PlateColumn)col).values;
                for (j = 0; j < this.nRows; ++j) {
                    PlateI p = new PlateI(tableData[j], false);
                    rowData[j] = new PlateData(p);
                    if (b == null) continue;
                    try {
                        rowData[j] = new PlateData((Plate)b.findIObject(this.ctx, p));
                        continue;
                    }
                    catch (Exception e) {
                        this.fac.logWarn(this, "Can't load object.", e);
                    }
                }
                this.dataArray[i] = rowData;
                header[i].setType(PlateData.class);
            }
            if (col instanceof RoiColumn) {
                rowData = new ROIData[this.nRows];
                tableData = ((RoiColumn)col).values;
                for (j = 0; j < this.nRows; ++j) {
                    RoiI p = new RoiI(tableData[j], false);
                    rowData[j] = new ROIData(p);
                    if (r == null) continue;
                    try {
                        rowData[j] = r.loadROI(this.ctx, tableData[j]).getROIs().iterator().next();
                        continue;
                    }
                    catch (Exception e) {
                        this.fac.logWarn(this, "Can't load object.", e);
                    }
                }
                this.dataArray[i] = rowData;
                header[i].setType(ROIData.class);
            }
            if (col instanceof StringColumn) {
                this.dataArray[i] = ((StringColumn)col).values;
                header[i].setType(String.class);
            }
            if (!(col instanceof WellColumn)) continue;
            rowData = new WellData[this.nRows];
            tableData = ((WellColumn)col).values;
            for (j = 0; j < this.nRows; ++j) {
                WellI p = new WellI(tableData[j], false);
                rowData[j] = new WellData(p);
                if (b == null) continue;
                try {
                    rowData[j] = new WellData((WellI)b.findIObject(this.ctx, p));
                    continue;
                }
                catch (Exception e) {
                    this.fac.logWarn(this, "Can't load object.", e);
                }
            }
            this.dataArray[i] = rowData;
            header[i].setType(WellData.class);
        }
    }

    private Column createColumn(String header, String description, Class<?> type, Object[] data) {
        Column c = null;
        if (type.equals(Boolean.class)) {
            boolean[] d = new boolean[data.length];
            for (int i = 0; i < data.length; ++i) {
                d[i] = (Boolean)data[i];
            }
            c = new BoolColumn(header, description, d);
        } else if (type.equals(Double[].class)) {
            double[][] d = new double[data.length][];
            int l = 0;
            for (int i = 0; i < data.length; ++i) {
                Double[] src = (Double[])data[i];
                double[] dst = new double[src.length];
                for (int j = 0; j < src.length; ++j) {
                    dst[j] = src[j];
                }
                d[i] = dst;
                l = dst.length;
            }
            c = new DoubleArrayColumn(header, description, l, d);
        } else if (type.equals(Double.class)) {
            double[] d = new double[data.length];
            for (int i = 0; i < data.length; ++i) {
                d[i] = (Double)data[i];
            }
            c = new DoubleColumn(header, description, d);
        } else if (type.equals(OriginalFile.class)) {
            long[] d = new long[data.length];
            for (int i = 0; i < data.length; ++i) {
                d[i] = ((OriginalFile)data[i]).getId().getValue();
            }
            c = new FileColumn(header, description, d);
        } else if (type.equals(FileAnnotationData.class)) {
            long[] d = new long[data.length];
            for (int i = 0; i < data.length; ++i) {
                d[i] = ((FileAnnotationData)data[i]).getFileID();
            }
            c = new FileColumn(header, description, d);
            this.fac.logWarn(this, "Support for FileAnnotationData is deprecated. Use OriginalFile instead.", null);
        } else if (type.equals(Float[].class)) {
            float[][] d = new float[data.length][];
            int l = 0;
            for (int i = 0; i < data.length; ++i) {
                Float[] src = (Float[])data[i];
                float[] dst = new float[src.length];
                for (int j = 0; j < src.length; ++j) {
                    dst[j] = src[j].floatValue();
                }
                d[i] = dst;
                l = dst.length;
            }
            c = new FloatArrayColumn(header, description, l, d);
        } else if (type.equals(ImageData.class)) {
            long[] d = new long[data.length];
            for (int i = 0; i < data.length; ++i) {
                d[i] = ((ImageData)data[i]).getId();
            }
            c = new ImageColumn(header, description, d);
        } else if (type.equals(Long[].class)) {
            long[][] d = new long[data.length][];
            int l = 0;
            for (int i = 0; i < data.length; ++i) {
                Long[] src = (Long[])data[i];
                long[] dst = new long[src.length];
                for (int j = 0; j < src.length; ++j) {
                    dst[j] = src[j];
                }
                d[i] = dst;
                l = dst.length;
            }
            c = new LongArrayColumn(header, description, l, d);
        } else if (type.equals(Long.class)) {
            long[] d = new long[data.length];
            for (int i = 0; i < data.length; ++i) {
                d[i] = (Long)data[i];
            }
            c = new LongColumn(header, description, d);
        } else if (type.equals(MaskData.class)) {
            long[] imageId = new long[data.length];
            int[] theZ = new int[data.length];
            int[] theT = new int[data.length];
            double[] x = new double[data.length];
            double[] y = new double[data.length];
            double[] w = new double[data.length];
            double[] h = new double[data.length];
            byte[][] bytes = new byte[data.length][];
            for (int i = 0; i < data.length; ++i) {
                MaskData md = (MaskData)data[i];
                imageId[i] = md.getImage() != null ? md.getImage().getId() : -1L;
                theZ[i] = md.getZ();
                theT[i] = md.getT();
                x[i] = md.getX();
                y[i] = md.getY();
                w[i] = md.getWidth();
                h[i] = md.getHeight();
                bytes[i] = md.getMask();
            }
            c = new MaskColumn(header, description, imageId, theZ, theT, x, y, w, h, bytes);
        } else if (type.equals(PlateData.class)) {
            long[] d = new long[data.length];
            for (int i = 0; i < data.length; ++i) {
                d[i] = ((PlateData)data[i]).getId();
            }
            c = new PlateColumn(header, description, d);
        } else if (type.equals(ROIData.class)) {
            long[] d = new long[data.length];
            for (int i = 0; i < data.length; ++i) {
                d[i] = ((ROIData)data[i]).getId();
            }
            c = new RoiColumn(header, description, d);
        } else if (type.equals(String.class)) {
            String[] d = new String[data.length];
            int size = 0;
            for (int i = 0; i < data.length; ++i) {
                d[i] = (String)data[i];
                byte[] raw = d[i].getBytes(StandardCharsets.UTF_8);
                if (raw.length <= size) continue;
                size = raw.length;
            }
            c = new StringColumn(header, description, size, d);
        } else if (type.equals(WellData.class)) {
            long[] d = new long[data.length];
            for (int i = 0; i < data.length; ++i) {
                d[i] = ((WellData)data[i]).getId();
            }
            c = new WellColumn(header, description, d);
        } else if (type.equals(DatasetData.class)) {
            this.fac.logWarn(this, "Dataset not supported yet.", null);
        } else if (type.equals(Object.class)) {
            this.fac.logWarn(this, "No concrete type specified for column '" + header + "', using Object.toString()", null);
            String[] d = new String[data.length];
            for (int i = 0; i < data.length; ++i) {
                d[i] = data[i].toString();
            }
            c = new StringColumn(header, description, 32767L, d);
        }
        return c;
    }

    int getNCols() {
        return this.nCols;
    }

    int getNRows() {
        return this.nRows;
    }

    Object[][] getDataArray() {
        return this.dataArray;
    }

    protected Column[] getGridColumns() {
        return this.gridColumns;
    }

    static void updateData(Data toUpdate, TableData data) {
        if (toUpdate.columns.length != data.getData().length) {
            throw new IllegalArgumentException("Column size is different!");
        }
        if (toUpdate.rowNumbers.length != data.getData()[0].length) {
            throw new IllegalArgumentException("Row size is different!");
        }
        for (int c = 0; c < data.getColumns().length; ++c) {
            Column col = toUpdate.columns[c];
            for (int r = 0; r < data.getData()[0].length; ++r) {
                int i;
                Object[] b;
                Number[] a;
                if (col instanceof BoolColumn) {
                    if (!data.getColumns()[c].getType().equals(Boolean.class)) {
                        throw new IllegalArgumentException("Boolean type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    ((BoolColumn)col).values[r] = (Boolean)data.getData()[c][r];
                }
                if (col instanceof DoubleArrayColumn) {
                    if (!data.getColumns()[c].getType().equals(Double[].class)) {
                        throw new IllegalArgumentException("Double[] type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    if (((DoubleArrayColumn)col).size != (long)((Double[])data.getData()[c][r]).length) {
                        throw new IllegalArgumentException("Can't change the length of the array");
                    }
                    a = (Double[])data.getData()[c][r];
                    b = new double[a.length];
                    for (i = 0; i < a.length; ++i) {
                        b[i] = (Double)a[i];
                    }
                    ((DoubleArrayColumn)col).values[r] = b;
                }
                if (col instanceof DoubleColumn) {
                    if (!data.getColumns()[c].getType().equals(Double.class)) {
                        throw new IllegalArgumentException("Double type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    ((DoubleColumn)col).values[r] = (Double)data.getData()[c][r];
                }
                if (col instanceof FileColumn) {
                    if (data.getColumns()[c].getType().equals(OriginalFile.class)) {
                        ((FileColumn)col).values[r] = ((OriginalFile)data.getData()[c][r]).getId().getValue();
                    } else if (data.getColumns()[c].getType().equals(FileAnnotationData.class)) {
                        ((FileColumn)col).values[r] = ((FileAnnotationData)data.getData()[c][r]).getFileID();
                    } else {
                        throw new IllegalArgumentException("OriginalFile or FileAnnotationData type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                }
                if (col instanceof FloatArrayColumn) {
                    if (!data.getColumns()[c].getType().equals(Float[].class)) {
                        throw new IllegalArgumentException("Float[] type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    if (((FloatArrayColumn)col).size != (long)((Float[])data.getData()[c][r]).length) {
                        throw new IllegalArgumentException("Can't change the length of the array");
                    }
                    a = (Float[])data.getData()[c][r];
                    b = new float[a.length];
                    for (i = 0; i < a.length; ++i) {
                        b[i] = ((Float)a[i]).floatValue();
                    }
                    ((FloatArrayColumn)col).values[r] = (float[])b;
                }
                if (col instanceof ImageColumn) {
                    if (!data.getColumns()[c].getType().equals(ImageData.class)) {
                        throw new IllegalArgumentException("ImageData type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    ((ImageColumn)col).values[r] = ((ImageData)data.getData()[c][r]).getId();
                }
                if (col instanceof LongArrayColumn) {
                    if (!data.getColumns()[c].getType().equals(Long[].class)) {
                        throw new IllegalArgumentException("Long[] type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    if (((LongArrayColumn)col).size != (long)((Long[])data.getData()[c][r]).length) {
                        throw new IllegalArgumentException("Can't change the length of the array");
                    }
                    a = (Long[])data.getData()[c][r];
                    b = new long[a.length];
                    for (i = 0; i < a.length; ++i) {
                        b[i] = ((Long)a[i]).longValue();
                    }
                    ((LongArrayColumn)col).values[r] = (long[])b;
                }
                if (col instanceof LongColumn) {
                    if (!data.getColumns()[c].getType().equals(Long.class)) {
                        throw new IllegalArgumentException("Long type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    ((LongColumn)col).values[r] = (Long)data.getData()[c][r];
                }
                if (col instanceof MaskColumn) {
                    if (!data.getColumns()[c].getType().equals(MaskData.class)) {
                        throw new IllegalArgumentException("MaskData type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    MaskData md = (MaskData)data.getData()[c][r];
                    ((MaskColumn)col).bytes[r] = md.getMask();
                    ((MaskColumn)col).x[r] = md.getX();
                    ((MaskColumn)col).y[r] = md.getY();
                    ((MaskColumn)col).w[r] = md.getWidth();
                    ((MaskColumn)col).h[r] = md.getHeight();
                    ((MaskColumn)col).theZ[r] = md.getZ();
                    ((MaskColumn)col).theT[r] = md.getT();
                }
                if (col instanceof PlateColumn) {
                    if (!data.getColumns()[c].getType().equals(PlateData.class)) {
                        throw new IllegalArgumentException("PlateData type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    ((PlateColumn)col).values[r] = ((PlateData)data.getData()[c][r]).getId();
                }
                if (col instanceof RoiColumn) {
                    if (!data.getColumns()[c].getType().equals(ROIData.class)) {
                        throw new IllegalArgumentException("ROIData type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    ((RoiColumn)col).values[r] = ((ROIData)data.getData()[c][r]).getId();
                }
                if (col instanceof StringColumn) {
                    if (!data.getColumns()[c].getType().equals(String.class)) {
                        throw new IllegalArgumentException("String type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                    }
                    ((StringColumn)col).values[r] = (String)data.getData()[c][r];
                }
                if (!(col instanceof WellColumn)) continue;
                if (!data.getColumns()[c].getType().equals(WellData.class)) {
                    throw new IllegalArgumentException("WellData type expected for column " + c + ", but is " + data.getColumns()[c].getType().getSimpleName() + " !");
                }
                ((WellColumn)col).values[r] = ((WellData)data.getData()[c][r]).getId();
            }
        }
    }
}

