/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.gui.Roi;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class Overlay {
    private Vector list = new Vector();
    private boolean label;
    private boolean drawNames;
    private boolean drawBackgrounds;
    private Color labelColor;
    private Font labelFont;
    private boolean isCalibrationBar;

    public Overlay() {
    }

    public Overlay(Roi roi) {
        this.list.add(roi);
    }

    public void add(Roi roi) {
        this.list.add(roi);
    }

    public void addElement(Roi roi) {
        this.list.add(roi);
    }

    public void remove(int index) {
        this.list.remove(index);
    }

    public void remove(Roi roi) {
        this.list.remove(roi);
    }

    public void clear() {
        this.list.clear();
    }

    public Roi get(int index) {
        return (Roi)this.list.get(index);
    }

    public int getIndex(String name) {
        if (name == null) {
            return -1;
        }
        Roi[] rois = this.toArray();
        for (int i = rois.length - 1; i >= 0; --i) {
            if (!name.equals(rois[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Roi roi) {
        return this.list.contains(roi);
    }

    public int size() {
        return this.list.size();
    }

    public Roi[] toArray() {
        Roi[] array = new Roi[this.list.size()];
        return this.list.toArray(array);
    }

    public void setStrokeColor(Color color) {
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            rois[i].setStrokeColor(color);
        }
    }

    public void setFillColor(Color color) {
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            rois[i].setFillColor(color);
        }
    }

    public void translate(int dx, int dy) {
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            Rectangle2D r;
            Roi roi = rois[i];
            if (roi.subPixelResolution()) {
                r = roi.getFloatBounds();
                roi.setLocation(r.getX() + (double)dx, r.getY() + (double)dy);
                continue;
            }
            r = roi.getBounds();
            roi.setLocation(((Rectangle)r).x + dx, ((Rectangle)r).y + dy);
        }
    }

    public void translate(double dx, double dy) {
        Roi[] rois = this.toArray();
        boolean intArgs = (double)((int)dx) == dx && (double)((int)dy) == dy;
        for (int i = 0; i < rois.length; ++i) {
            Rectangle2D r;
            Roi roi = rois[i];
            if (roi.subPixelResolution() || !intArgs) {
                r = roi.getFloatBounds();
                roi.setLocation(r.getX() + dx, r.getY() + dy);
                continue;
            }
            r = roi.getBounds();
            roi.setLocation(((Rectangle)r).x + (int)dx, ((Rectangle)r).y + (int)dy);
        }
    }

    public Overlay crop(Rectangle bounds) {
        int dy;
        Roi[] allRois;
        if (bounds == null) {
            return this.duplicate();
        }
        Overlay overlay2 = new Overlay();
        for (Roi roi : allRois = this.toArray()) {
            Rectangle roiBounds = roi.getBounds();
            if (roiBounds.width == 0) {
                roiBounds.width = 1;
            }
            if (roiBounds.height == 0) {
                roiBounds.height = 1;
            }
            if (!bounds.intersects(roiBounds)) continue;
            overlay2.add((Roi)roi.clone());
        }
        int dx = bounds.x > 0 ? bounds.x : 0;
        int n = dy = bounds.y > 0 ? bounds.y : 0;
        if (dx > 0 || dy > 0) {
            overlay2.translate(-dx, -dy);
        }
        return overlay2;
    }

    public void crop(int firstSlice, int lastSlice) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Roi roi = this.get(i);
            int position = roi.getPosition();
            if (position <= 0) continue;
            if (position < firstSlice || position > lastSlice) {
                this.remove(i);
                continue;
            }
            roi.setPosition(position - firstSlice + 1);
        }
    }

    public void crop(int firstC, int lastC, int firstZ, int lastZ, int firstT, int lastT) {
        int nc = lastC - firstC + 1;
        int nz = lastZ - firstZ + 1;
        int nt = lastT - firstT + 1;
        boolean toCStack = nz == 1 && nt == 1;
        boolean toZStack = nt == 1 && nc == 1;
        boolean toTStack = nc == 1 && nz == 1;
        for (int i = this.size() - 1; i >= 0; --i) {
            Roi roi = this.get(i);
            int c = roi.getCPosition();
            int z = roi.getZPosition();
            int t = roi.getTPosition();
            int c2 = c - firstC + 1;
            int z2 = z - firstZ + 1;
            int t2 = t - firstT + 1;
            if (toCStack) {
                roi.setPosition(c2);
            } else if (toZStack) {
                roi.setPosition(z2);
            } else if (toTStack) {
                roi.setPosition(t2);
            } else {
                roi.setPosition(c2, z2, t2);
            }
            if ((c2 >= 1 && c2 <= nc || c <= 0) && (z2 >= 1 && z2 <= nz || z <= 0) && (t2 >= 1 && t2 <= nt || t <= 0)) continue;
            this.remove(i);
        }
    }

    public Overlay duplicate() {
        Roi[] rois = this.toArray();
        Overlay overlay2 = new Overlay();
        for (int i = 0; i < rois.length; ++i) {
            overlay2.add((Roi)rois[i].clone());
        }
        overlay2.drawLabels(this.label);
        overlay2.drawNames(this.drawNames);
        overlay2.drawBackgrounds(this.drawBackgrounds);
        overlay2.setLabelColor(this.labelColor);
        overlay2.setLabelFont(this.labelFont);
        return overlay2;
    }

    public String toString() {
        return this.list.toString();
    }

    public void drawLabels(boolean b) {
        this.label = b;
    }

    public boolean getDrawLabels() {
        return this.label;
    }

    public void drawNames(boolean b) {
        this.drawNames = b;
        Roi[] rois = this.toArray();
        for (int i = 0; i < rois.length; ++i) {
            rois[i].setIgnoreClipRect(this.drawNames);
        }
    }

    public boolean getDrawNames() {
        return this.drawNames;
    }

    public void drawBackgrounds(boolean b) {
        this.drawBackgrounds = b;
    }

    public boolean getDrawBackgrounds() {
        return this.drawBackgrounds;
    }

    public void setLabelColor(Color c) {
        this.labelColor = c;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setIsCalibrationBar(boolean b) {
        this.isCalibrationBar = b;
    }

    public boolean isCalibrationBar() {
        return this.isCalibrationBar;
    }

    void setVector(Vector v) {
        this.list = v;
    }

    Vector getVector() {
        return this.list;
    }
}

