/*
 * Decompiled with CFR 0.152.
 */
package ome.services.search;

import java.util.ArrayList;
import java.util.List;
import ome.model.annotations.TagAnnotation;
import ome.services.search.SearchAction;
import ome.services.search.SearchValues;
import ome.system.ServiceFactory;
import ome.tools.hibernate.QueryBuilder;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

public class TagsAndGroups
extends SearchAction {
    private static final long serialVersionUID = 1L;
    private final String str;
    private final boolean byTagForGroups;

    public TagsAndGroups(SearchValues values, String query, boolean byTagForGroups) {
        super(values);
        this.byTagForGroups = byTagForGroups;
        this.str = query == null || query.length() < 1 ? null : query;
    }

    @Transactional(readOnly=true)
    public Object doWork(Session session, ServiceFactory sf) {
        QueryBuilder qb = new QueryBuilder(128);
        qb.select("target.textValue");
        qb.from("AnnotationAnnotationLink", "link");
        if (this.byTagForGroups) {
            qb.join("link.parent", "source", false, false);
            qb.join("link.child", "target", false, false);
        } else {
            qb.join("link.parent", "target", false, false);
            qb.join("link.child", "source", false, false);
        }
        qb.where();
        qb.and("source.class = TagAnnotation");
        qb.and("target.class = TagAnnotation");
        if (this.str != null) {
            qb.and("source.textValue = :str");
            qb.param("str", (Object)this.str);
        }
        this.ownerOrGroup(TagAnnotation.class, qb, "source.");
        this.createdOrModified(TagAnnotation.class, qb, "source.");
        if (this.byTagForGroups) {
            this.annotatedBy(qb, "source.");
            this.annotatedBetween(qb, "source.");
        } else {
            this.annotatedBy(qb, "target.");
            this.annotatedBetween(qb, "target.");
        }
        Query query = qb.query(session);
        if (this.timeout != null) {
            query.setTimeout(this.timeout.intValue());
        }
        ArrayList<TagAnnotation> rv = new ArrayList<TagAnnotation>();
        List tags = query.list();
        for (String tag : tags) {
            TagAnnotation ta = new TagAnnotation();
            ta.setTextValue(tag);
            rv.add(ta);
        }
        return rv;
    }
}

