/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.DecoratorVisitor;

class DatasetsModel
extends DataBrowserModel {
    DatasetsModel(SecurityContext ctx, Object parent, Set<DatasetData> datasets) {
        super(ctx);
        if (datasets == null) {
            throw new IllegalArgumentException("No datasets.");
        }
        this.parent = parent;
        Set visTrees = DataBrowserTranslator.transformHierarchy(datasets);
        this.browser = BrowserFactory.createBrowser(visTrees);
        this.browser.accept(new DecoratorVisitor(this.getCurrentUser().getId()));
        Iterator<DatasetData> i = datasets.iterator();
        ArrayList<Long> ids = new ArrayList<Long>();
        while (i.hasNext()) {
            DatasetData data = i.next();
            Set<ImageData> images = data.getImages();
            if (images == null) continue;
            for (ImageData img : images) {
                if (ids.contains(img.getId())) continue;
                try {
                    img.getDefaultPixels();
                    ids.add(img.getId());
                    ++this.numberOfImages;
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected List<DataBrowserLoader> createDataLoader(boolean refresh, Collection ids) {
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded != 0 && ids != null) {
            this.imagesLoaded -= ids.size();
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return null;
        }
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Iterator<ImageNode> i = nodes.iterator();
        ArrayList<ImageData> imgs = new ArrayList<ImageData>();
        ArrayList<Long> loaded = new ArrayList<Long>();
        if (ids != null) {
            while (i.hasNext()) {
                ImageData img;
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null || !ids.contains((img = (ImageData)node.getHierarchyObject()).getId()) || loaded.contains(img.getId())) continue;
                try {
                    img.getDefaultPixels();
                    imgs.add(img);
                    loaded.add(img.getId());
                    ++this.imagesLoaded;
                }
                catch (Exception exception) {}
            }
        } else {
            while (i.hasNext()) {
                ImageData img;
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null || loaded.contains((img = (ImageData)node.getHierarchyObject()).getId())) continue;
                try {
                    img.getDefaultPixels();
                    imgs.add(img);
                    loaded.add(img.getId());
                    ++this.imagesLoaded;
                }
                catch (Exception exception) {}
            }
        }
        if (imgs.size() == 0) {
            return null;
        }
        return this.createThumbnailsLoader(this.sorter.sort(imgs));
    }

    @Override
    protected int getType() {
        return 0;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

